/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.process.parser;

import java.math.BigDecimal;
import java.math.RoundingMode;
import net.sf.jsqlparser.expression.operators.arithmetic.Division;
import org.apache.inlong.sdk.transform.decode.SourceData;
import org.apache.inlong.sdk.transform.process.Context;
import org.apache.inlong.sdk.transform.process.operator.OperatorTools;
import org.apache.inlong.sdk.transform.process.parser.TransformParser;
import org.apache.inlong.sdk.transform.process.parser.ValueParser;

@TransformParser(values={Division.class})
public class DivisionParser
implements ValueParser {
    private ValueParser left;
    private ValueParser right;
    private final int DEFAULT_SCALE_DIFFERENCE = 4;

    public DivisionParser(Division expr) {
        this.left = OperatorTools.buildParser(expr.getLeftExpression());
        this.right = OperatorTools.buildParser(expr.getRightExpression());
    }

    @Override
    public Object parse(SourceData sourceData, int rowIndex, Context context) {
        Object leftObj = this.left.parse(sourceData, rowIndex, context);
        Object rightObj = this.right.parse(sourceData, rowIndex, context);
        BigDecimal leftValue = OperatorTools.parseBigDecimal(leftObj);
        BigDecimal rightValue = OperatorTools.parseBigDecimal(rightObj);
        try {
            return leftValue.divide(rightValue);
        }
        catch (Exception e) {
            int scale = Math.max(leftValue.scale(), rightValue.scale()) + 4;
            return leftValue.divide(rightValue, scale, RoundingMode.HALF_UP);
        }
    }
}

