/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.process.parser;

import java.math.BigDecimal;
import net.sf.jsqlparser.expression.SignedExpression;
import org.apache.inlong.sdk.transform.decode.SourceData;
import org.apache.inlong.sdk.transform.process.Context;
import org.apache.inlong.sdk.transform.process.operator.OperatorTools;
import org.apache.inlong.sdk.transform.process.parser.TransformParser;
import org.apache.inlong.sdk.transform.process.parser.ValueParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@TransformParser(values={SignedExpression.class})
public class SignParser
implements ValueParser {
    private static final Logger log = LoggerFactory.getLogger(SignParser.class);
    private final char sign;
    private final ValueParser number;

    public SignParser(SignedExpression expr) {
        this.sign = expr.getSign();
        this.number = OperatorTools.buildParser(expr.getExpression());
    }

    @Override
    public Object parse(SourceData sourceData, int rowIndex, Context context) {
        try {
            Object numberObject = this.number.parse(sourceData, rowIndex, context);
            if (numberObject == null) {
                return null;
            }
            BigDecimal numberValue = OperatorTools.parseBigDecimal(numberObject);
            switch (this.sign) {
                case '-': {
                    return numberValue.multiply(new BigDecimal(-1));
                }
                case '~': {
                    return Long.toUnsignedString(numberValue.toBigInteger().not().longValue());
                }
            }
        }
        catch (Exception e) {
            log.error("Value parsing failed", (Throwable)e);
        }
        return null;
    }
}

