/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.dataproxy.source;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.timeout.ReadTimeoutHandler;
import java.lang.reflect.Constructor;
import java.util.concurrent.TimeUnit;
import org.apache.inlong.dataproxy.source.BaseSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerMessageFactory
extends ChannelInitializer<SocketChannel> {
    public static final int INLONG_LENGTH_FIELD_OFFSET = 0;
    public static final int INLONG_LENGTH_FIELD_LENGTH = 4;
    public static final int INLONG_LENGTH_ADJUSTMENT = 0;
    public static final int INLONG_INITIAL_BYTES_TO_STRIP = 0;
    public static final boolean DEFAULT_FAIL_FAST = true;
    private static final Logger LOG = LoggerFactory.getLogger(ServerMessageFactory.class);
    private final BaseSource source;

    public ServerMessageFactory(BaseSource source) {
        this.source = source;
    }

    protected void initChannel(SocketChannel ch) throws Exception {
        if (this.source.getProtocolName().equalsIgnoreCase("tcp")) {
            ch.pipeline().addLast("messageDecoder", (ChannelHandler)new LengthFieldBasedFrameDecoder(this.source.getMaxMsgLength(), 0, 4, 0, 0, true));
            ch.pipeline().addLast("readTimeoutHandler", (ChannelHandler)new ReadTimeoutHandler(this.source.getMaxReadIdleTimeMs(), TimeUnit.MILLISECONDS));
        } else if (this.source.getProtocolName().equalsIgnoreCase("http")) {
            ch.pipeline().addLast("msgCodec", (ChannelHandler)new HttpServerCodec());
            ch.pipeline().addLast("msgAggregator", (ChannelHandler)new HttpObjectAggregator(this.source.getMaxMsgLength()));
            ch.pipeline().addLast("readTimeoutHandler", (ChannelHandler)new ReadTimeoutHandler(this.source.getMaxReadIdleTimeMs(), TimeUnit.MILLISECONDS));
        }
        if (this.source.getChannelProcessor() != null) {
            try {
                Class<?> clazz = Class.forName(this.source.getMessageHandlerName());
                Constructor<?> ctor = clazz.getConstructor(BaseSource.class);
                ChannelInboundHandlerAdapter messageHandler = (ChannelInboundHandlerAdapter)ctor.newInstance(this.source);
                ch.pipeline().addLast("messageHandler", (ChannelHandler)messageHandler);
            }
            catch (Throwable e) {
                LOG.error("{} newInstance {} failure!", new Object[]{this.source.getCachedSrcName(), this.source.getMessageHandlerName(), e});
            }
        }
    }
}

