/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.rpc.subscription.payload.poll;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public enum SubscriptionPollRequestType {
    POLL(0),
    POLL_FILE(1),
    POLL_TABLETS(2);

    private final short type;
    private static final Map<Short, SubscriptionPollRequestType> TYPE_MAP;

    private SubscriptionPollRequestType(short type) {
        this.type = type;
    }

    public short getType() {
        return this.type;
    }

    public static boolean isValidatedRequestType(short type) {
        return TYPE_MAP.containsKey(type);
    }

    public static SubscriptionPollRequestType valueOf(short type) {
        return TYPE_MAP.get(type);
    }

    static {
        TYPE_MAP = Arrays.stream(SubscriptionPollRequestType.values()).collect(HashMap::new, (typeMap, messageType) -> typeMap.put(messageType.getType(), messageType), HashMap::putAll);
    }
}

