/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.analyze;

import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathPatternTree;
import org.apache.iotdb.commons.path.PathPatternTreeUtils;
import org.apache.iotdb.db.exception.sql.StatementAnalyzeException;
import org.apache.iotdb.db.queryengine.common.MPPQueryContext;
import org.apache.iotdb.db.queryengine.plan.analyze.ExpressionAnalyzer;
import org.apache.iotdb.db.queryengine.plan.expression.Expression;
import org.apache.iotdb.db.queryengine.plan.statement.Statement;
import org.apache.iotdb.db.queryengine.plan.statement.component.ResultColumn;
import org.apache.iotdb.db.queryengine.plan.statement.component.SelectComponent;
import org.apache.iotdb.db.queryengine.plan.statement.crud.QueryStatement;

public class ConcatPathRewriter {
    private PathPatternTree patternTree;

    public PathPatternTree getPatternTree() {
        return this.patternTree;
    }

    public Statement rewrite(Statement statement, PathPatternTree patternTree, MPPQueryContext queryContext) throws StatementAnalyzeException {
        QueryStatement queryStatement = (QueryStatement)statement;
        this.patternTree = patternTree;
        List<PartialPath> prefixPaths = queryStatement.getFromComponent().getPrefixPaths();
        if (queryStatement.isAlignByDevice()) {
            for (ResultColumn resultColumn : queryStatement.getSelectComponent().getResultColumns()) {
                ExpressionAnalyzer.constructPatternTreeFromExpression(resultColumn.getExpression(), prefixPaths, patternTree);
            }
            if (queryStatement.hasGroupByExpression()) {
                ExpressionAnalyzer.constructPatternTreeFromExpression(queryStatement.getGroupByComponent().getControlColumnExpression(), prefixPaths, patternTree);
            }
            if (queryStatement.hasOrderByExpression()) {
                for (Expression sortItemExpression : queryStatement.getExpressionSortItemList()) {
                    ExpressionAnalyzer.constructPatternTreeFromExpression(sortItemExpression, prefixPaths, patternTree);
                }
            }
        } else {
            List<ResultColumn> resultColumns = this.concatSelectWithFrom(queryStatement.getSelectComponent(), prefixPaths, queryContext);
            queryStatement.getSelectComponent().setResultColumns(resultColumns);
            if (queryStatement.hasGroupByExpression()) {
                queryStatement.getGroupByComponent().setControlColumnExpression(this.contactGroupByWithFrom(queryStatement.getGroupByComponent().getControlColumnExpression(), prefixPaths, queryContext));
            }
            if (queryStatement.hasOrderByExpression()) {
                List<Expression> sortItemExpressions = queryStatement.getExpressionSortItemList();
                sortItemExpressions.replaceAll(expression -> this.contactOrderByWithFrom((Expression)expression, prefixPaths, queryContext));
            }
        }
        if (queryStatement.getWhereCondition() != null) {
            ExpressionAnalyzer.constructPatternTreeFromExpression(queryStatement.getWhereCondition().getPredicate(), prefixPaths, patternTree);
        }
        if (queryStatement.getHavingCondition() != null) {
            ExpressionAnalyzer.constructPatternTreeFromExpression(queryStatement.getHavingCondition().getPredicate(), prefixPaths, patternTree);
        }
        patternTree.constructTree();
        this.patternTree = PathPatternTreeUtils.intersectWithFullPathPrefixTree((PathPatternTree)patternTree, (PathPatternTree)queryStatement.getAuthorityScope());
        return queryStatement;
    }

    private List<ResultColumn> concatSelectWithFrom(SelectComponent selectComponent, List<PartialPath> prefixPaths, MPPQueryContext queryContext) throws StatementAnalyzeException {
        ArrayList<ResultColumn> resultColumns = new ArrayList<ResultColumn>();
        for (ResultColumn resultColumn : selectComponent.getResultColumns()) {
            List<Expression> resultExpressions = ExpressionAnalyzer.concatExpressionWithSuffixPaths(resultColumn.getExpression(), prefixPaths, this.patternTree, queryContext);
            for (Expression resultExpression : resultExpressions) {
                resultColumns.add(new ResultColumn(resultExpression, resultColumn.getAlias(), resultColumn.getColumnType()));
            }
        }
        return resultColumns;
    }

    private Expression contactGroupByWithFrom(Expression expression, List<PartialPath> prefixPaths, MPPQueryContext queryContext) {
        List<Expression> resultExpressions = ExpressionAnalyzer.concatExpressionWithSuffixPaths(expression, prefixPaths, this.patternTree, queryContext);
        if (resultExpressions.size() != 1) {
            throw new IllegalStateException("Expression in group by should indicate one value");
        }
        return resultExpressions.get(0);
    }

    private Expression contactOrderByWithFrom(Expression expression, List<PartialPath> prefixPaths, MPPQueryContext queryContext) {
        List<Expression> resultExpressions = ExpressionAnalyzer.concatExpressionWithSuffixPaths(expression, prefixPaths, this.patternTree, queryContext);
        if (resultExpressions.size() != 1) {
            throw new IllegalStateException("Expression in order by should indicate one value");
        }
        return resultExpressions.get(0);
    }
}

