/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.process;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.utils.TestOnly;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.runtime.IntoProcessException;
import org.apache.iotdb.db.protocol.client.DataNodeInternalClient;
import org.apache.iotdb.db.queryengine.execution.operator.Operator;
import org.apache.iotdb.db.queryengine.execution.operator.OperatorContext;
import org.apache.iotdb.db.queryengine.execution.operator.process.ProcessOperator;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.read.common.block.TsBlock;

public abstract class AbstractIntoOperator
implements ProcessOperator {
    protected final OperatorContext operatorContext;
    protected final Operator child;
    protected TsBlock cachedTsBlock;
    protected DataNodeInternalClient client;
    protected final ExecutorService writeOperationExecutor;
    protected ListenableFuture<TSStatus> writeOperationFuture;
    protected boolean finished = false;
    protected int maxRowNumberInStatement;
    protected long maxReturnSize;
    protected final List<TSDataType> inputColumnTypes;

    protected AbstractIntoOperator(OperatorContext operatorContext, Operator child, List<TSDataType> inputColumnTypes, ExecutorService intoOperationExecutor, long statementSizePerLine) {
        this.operatorContext = operatorContext;
        this.child = child;
        this.inputColumnTypes = inputColumnTypes;
        this.writeOperationExecutor = intoOperationExecutor;
        this.setMaxRowNumberInStatement(statementSizePerLine);
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        ListenableFuture<?> childBlocked = this.child.isBlocked();
        boolean childDone = childBlocked.isDone();
        boolean writeDone = this.writeOperationDone();
        if (writeDone && childDone) {
            return NOT_BLOCKED;
        }
        if (childDone) {
            return this.writeOperationFuture;
        }
        if (writeDone) {
            return childBlocked;
        }
        return Futures.successfulAsList(Arrays.asList(this.writeOperationFuture, childBlocked));
    }

    @Override
    public boolean hasNext() throws Exception {
        return !this.finished;
    }

    @Override
    public TsBlock next() throws Exception {
        this.checkLastWriteOperation();
        if (!this.processTsBlock(this.cachedTsBlock)) {
            return null;
        }
        this.cachedTsBlock = null;
        if (this.child.hasNextWithTimer()) {
            TsBlock inputTsBlock = this.child.nextWithTimer();
            this.processTsBlock(inputTsBlock);
            return null;
        }
        return this.tryToReturnResultTsBlock();
    }

    @Override
    public boolean isFinished() throws Exception {
        return this.finished;
    }

    @Override
    public void close() throws Exception {
        if (this.client != null) {
            this.client.close();
        }
        if (this.writeOperationFuture != null) {
            this.writeOperationFuture.cancel(true);
        }
        this.child.close();
    }

    @Override
    public long calculateMaxPeekMemory() {
        return Math.max(this.child.calculateMaxPeekMemoryWithCounter(), this.calculateRetainedSizeAfterCallingNext() + this.calculateMaxReturnSize());
    }

    @Override
    public long calculateMaxReturnSize() {
        return this.maxReturnSize;
    }

    @Override
    public long calculateRetainedSizeAfterCallingNext() {
        return this.child.calculateMaxReturnSize() + this.child.calculateRetainedSizeAfterCallingNext();
    }

    @TestOnly
    public long getMaxRowNumberInStatement() {
        return this.maxRowNumberInStatement;
    }

    protected void checkLastWriteOperation() {
        if (this.writeOperationFuture == null) {
            return;
        }
        try {
            if (!this.writeOperationFuture.isDone()) {
                throw new IllegalStateException("The operator cannot continue until the last write operation is done.");
            }
            TSStatus executionStatus = (TSStatus)this.writeOperationFuture.get();
            if (executionStatus.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode() && executionStatus.getCode() != TSStatusCode.REDIRECTION_RECOMMEND.getStatusCode()) {
                String message = String.format("Error occurred while inserting tablets in SELECT INTO: %s", executionStatus.getMessage());
                throw new IntoProcessException(message, executionStatus.getCode());
            }
            this.resetInsertTabletStatementGenerators();
            this.writeOperationFuture = null;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IntoProcessException(e);
        }
        catch (ExecutionException e) {
            throw new IntoProcessException(e);
        }
    }

    protected abstract boolean processTsBlock(TsBlock var1);

    protected abstract TsBlock tryToReturnResultTsBlock();

    protected abstract void resetInsertTabletStatementGenerators();

    private void setMaxRowNumberInStatement(long statementSizePerLine) {
        long intoOperationBufferSizeInByte = IoTDBDescriptor.getInstance().getConfig().getIntoOperationBufferSizeInByte();
        long memAllowedMaxRowNumber = Math.max(intoOperationBufferSizeInByte / statementSizePerLine, 1L);
        if (memAllowedMaxRowNumber > Integer.MAX_VALUE) {
            memAllowedMaxRowNumber = Integer.MAX_VALUE;
        }
        this.maxRowNumberInStatement = Math.min((int)memAllowedMaxRowNumber, IoTDBDescriptor.getInstance().getConfig().getSelectIntoInsertTabletPlanRowLimit());
    }

    private boolean writeOperationDone() {
        if (this.writeOperationFuture == null) {
            return true;
        }
        return this.writeOperationFuture.isDone();
    }
}

