/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.service.metric;

import org.apache.iotdb.commons.exception.StartupException;
import org.apache.iotdb.commons.service.IService;
import org.apache.iotdb.commons.service.JMXService;
import org.apache.iotdb.commons.service.ServiceType;
import org.apache.iotdb.commons.service.metric.MetricServiceMBean;
import org.apache.iotdb.metrics.AbstractMetricService;
import org.apache.iotdb.metrics.config.ReloadLevel;
import org.apache.iotdb.metrics.core.IoTDBMetricManager;
import org.apache.iotdb.metrics.core.reporter.IoTDBJmxReporter;
import org.apache.iotdb.metrics.metricsets.IMetricSet;
import org.apache.iotdb.metrics.reporter.JmxReporter;
import org.apache.iotdb.metrics.reporter.Reporter;
import org.apache.iotdb.metrics.reporter.iotdb.IoTDBInternalMemoryReporter;
import org.apache.iotdb.metrics.reporter.iotdb.IoTDBInternalReporter;
import org.apache.iotdb.metrics.reporter.iotdb.IoTDBSessionReporter;
import org.apache.iotdb.metrics.reporter.prometheus.PrometheusReporter;
import org.apache.iotdb.metrics.utils.ReporterType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricService
extends AbstractMetricService
implements MetricServiceMBean,
IService {
    private static final Logger LOGGER = LoggerFactory.getLogger(MetricService.class);
    private final String mbeanName = String.format("%s:%s=%s", "org.apache.iotdb.service", "type", this.getID().getJmxName());

    private MetricService() {
    }

    protected void loadManager() {
        this.metricManager = IoTDBMetricManager.getInstance();
    }

    protected void loadReporter() {
        LOGGER.info("Load metric reporters, type: {}", (Object)METRIC_CONFIG.getMetricReporterList());
        this.compositeReporter.clearReporter();
        if (METRIC_CONFIG.getMetricReporterList() == null) {
            return;
        }
        boolean hasJmxReporter = false;
        for (ReporterType reporterType : METRIC_CONFIG.getMetricReporterList()) {
            IoTDBJmxReporter reporter = null;
            switch (reporterType) {
                case JMX: {
                    reporter = IoTDBJmxReporter.getInstance();
                    this.metricManager.setBindJmxReporter((JmxReporter)reporter);
                    hasJmxReporter = true;
                    break;
                }
                case PROMETHEUS: {
                    reporter = new PrometheusReporter(this.metricManager);
                    break;
                }
                case IOTDB: {
                    reporter = new IoTDBSessionReporter(this.metricManager);
                    break;
                }
            }
            if (reporter == null) {
                LOGGER.warn("Failed to load reporter which type is {}", (Object)reporterType);
                continue;
            }
            this.compositeReporter.addReporter((Reporter)reporter);
        }
        if (!hasJmxReporter) {
            this.metricManager.setBindJmxReporter(null);
        }
    }

    @Override
    public void start() throws StartupException {
        try {
            LOGGER.info("MetricService start to init.");
            JMXService.registerMBean(MetricService.getInstance(), this.mbeanName);
            this.startService();
            LOGGER.info("MetricService start successfully.");
        }
        catch (Exception e) {
            LOGGER.error("MetricService failed to start {} because: ", (Object)this.getID().getName(), (Object)e);
            throw new StartupException(this.getID().getName(), e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void restartService() {
        LOGGER.info("MetricService try to restart.");
        this.stopCoreModule();
        this.internalReporter.clear();
        this.startCoreModule();
        MetricService metricService = this;
        synchronized (metricService) {
            for (IMetricSet metricSet : this.metricSets) {
                LOGGER.info("MetricService rebind metricSet: {}", (Object)metricSet.getClass().getName());
                metricSet.unbindFrom((AbstractMetricService)this);
                metricSet.bindTo((AbstractMetricService)this);
            }
        }
        LOGGER.info("MetricService restart successfully.");
    }

    @Override
    public void stop() {
        LOGGER.info("MetricService try to stop.");
        this.internalReporter.stop();
        this.internalReporter = new IoTDBInternalMemoryReporter();
        this.stopService();
        JMXService.deregisterMBean(this.mbeanName);
        LOGGER.info("MetricService stop successfully.");
    }

    public void reloadInternalReporter(IoTDBInternalReporter internalReporter) {
        LOGGER.info("MetricService reload internal reporter.");
        internalReporter.addAutoGauge(this.internalReporter.getAllAutoGauge());
        this.internalReporter.stop();
        this.internalReporter = internalReporter;
        this.startInternalReporter();
        LOGGER.info("MetricService reload internal reporter successfully.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reloadService(ReloadLevel reloadLevel) {
        MetricService metricService = this;
        synchronized (metricService) {
            switch (reloadLevel) {
                case RESTART_METRIC: {
                    this.restartService();
                    break;
                }
                case RESTART_REPORTER: {
                    this.stopAllReporter();
                    this.loadReporter();
                    this.startAllReporter();
                    LOGGER.info("MetricService restart reporters successfully.");
                    break;
                }
                case NOTHING: {
                    LOGGER.debug("There are nothing change in metric config.");
                    break;
                }
            }
        }
    }

    @Override
    public ServiceType getID() {
        return ServiceType.METRIC_SERVICE;
    }

    public void updateInternalReporter(IoTDBInternalReporter internalReporter) {
        this.internalReporter = internalReporter;
    }

    public void startInternalReporter() {
        if (!this.internalReporter.start()) {
            LOGGER.warn("Internal Reporter failed to start!");
            this.internalReporter = new IoTDBInternalMemoryReporter();
        }
    }

    public static MetricService getInstance() {
        return MetricsServiceHolder.INSTANCE;
    }

    private static class MetricsServiceHolder {
        private static final MetricService INSTANCE = new MetricService();

        private MetricsServiceHolder() {
        }
    }
}

