/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.process;

import java.util.Arrays;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.InputLocation;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertTabletStatement;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.read.common.block.TsBlock;
import org.apache.tsfile.read.common.type.Type;
import org.apache.tsfile.utils.Accountable;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.utils.BitMap;
import org.apache.tsfile.utils.RamUsageEstimator;
import org.apache.tsfile.write.UnSupportedDataTypeException;

public abstract class InsertTabletStatementGenerator
implements Accountable {
    protected final int rowLimit;
    protected final PartialPath devicePath;
    protected final boolean isAligned;
    protected final String[] measurements;
    protected final TSDataType[] dataTypes;
    protected final InputLocation[] inputLocations;
    protected final Type[] typeConvertors;
    protected int rowCount = 0;
    protected long[] times;
    protected Object[] columns;
    protected BitMap[] bitMaps;

    public InsertTabletStatementGenerator(PartialPath devicePath, String[] measurements, TSDataType[] dataTypes, InputLocation[] inputLocations, Type[] typeConvertors, boolean isAligned, int rowLimit) {
        this.devicePath = devicePath;
        this.measurements = measurements;
        this.dataTypes = dataTypes;
        this.inputLocations = inputLocations;
        this.typeConvertors = typeConvertors;
        this.isAligned = isAligned;
        this.rowLimit = rowLimit;
    }

    public void initialize() {
        int i;
        this.rowCount = 0;
        this.times = new long[this.rowLimit];
        this.columns = new Object[this.measurements.length];
        block8: for (i = 0; i < this.measurements.length; ++i) {
            switch (this.dataTypes[i]) {
                case BOOLEAN: {
                    this.columns[i] = new boolean[this.rowLimit];
                    continue block8;
                }
                case INT32: 
                case DATE: {
                    this.columns[i] = new int[this.rowLimit];
                    continue block8;
                }
                case INT64: 
                case TIMESTAMP: {
                    this.columns[i] = new long[this.rowLimit];
                    continue block8;
                }
                case FLOAT: {
                    this.columns[i] = new float[this.rowLimit];
                    continue block8;
                }
                case DOUBLE: {
                    this.columns[i] = new double[this.rowLimit];
                    continue block8;
                }
                case TEXT: 
                case STRING: 
                case BLOB: {
                    this.columns[i] = new Binary[this.rowLimit];
                    Arrays.fill((Binary[])this.columns[i], Binary.EMPTY_VALUE);
                    continue block8;
                }
                default: {
                    throw new UnSupportedDataTypeException(String.format("Data type %s is not supported.", this.dataTypes[i]));
                }
            }
        }
        this.bitMaps = new BitMap[this.measurements.length];
        for (i = 0; i < this.bitMaps.length; ++i) {
            this.bitMaps[i] = new BitMap(this.rowLimit);
            this.bitMaps[i].markAll();
        }
    }

    public void reset() {
        this.rowCount = 0;
        Arrays.fill(this.times, 0L);
        block8: for (int i = 0; i < this.measurements.length; ++i) {
            switch (this.dataTypes[i]) {
                case BOOLEAN: {
                    Arrays.fill((boolean[])this.columns[i], false);
                    continue block8;
                }
                case INT32: 
                case DATE: {
                    Arrays.fill((int[])this.columns[i], 0);
                    continue block8;
                }
                case INT64: 
                case TIMESTAMP: {
                    Arrays.fill((long[])this.columns[i], 0L);
                    continue block8;
                }
                case FLOAT: {
                    Arrays.fill((float[])this.columns[i], 0.0f);
                    continue block8;
                }
                case DOUBLE: {
                    Arrays.fill((double[])this.columns[i], 0.0);
                    continue block8;
                }
                case TEXT: 
                case STRING: 
                case BLOB: {
                    Arrays.fill((Binary[])this.columns[i], Binary.EMPTY_VALUE);
                    continue block8;
                }
                default: {
                    throw new UnSupportedDataTypeException(String.format("Data type %s is not supported.", this.dataTypes[i]));
                }
            }
        }
        for (BitMap bitMap : this.bitMaps) {
            bitMap.markAll();
        }
    }

    public InsertTabletStatement constructInsertTabletStatement() {
        InsertTabletStatement insertTabletStatement = new InsertTabletStatement();
        insertTabletStatement.setDevicePath(this.devicePath);
        insertTabletStatement.setAligned(this.isAligned);
        insertTabletStatement.setMeasurements(this.measurements);
        insertTabletStatement.setDataTypes(this.dataTypes);
        insertTabletStatement.setTypeConvertors(this.typeConvertors);
        insertTabletStatement.setInputLocations(this.inputLocations);
        insertTabletStatement.setRowCount(this.rowCount);
        if (this.rowCount != this.rowLimit) {
            this.times = Arrays.copyOf(this.times, this.rowCount);
            block8: for (int i = 0; i < this.columns.length; ++i) {
                this.bitMaps[i] = this.bitMaps[i].getRegion(0, this.rowCount);
                switch (this.dataTypes[i]) {
                    case BOOLEAN: {
                        this.columns[i] = Arrays.copyOf((boolean[])this.columns[i], this.rowCount);
                        continue block8;
                    }
                    case INT32: 
                    case DATE: {
                        this.columns[i] = Arrays.copyOf((int[])this.columns[i], this.rowCount);
                        continue block8;
                    }
                    case INT64: 
                    case TIMESTAMP: {
                        this.columns[i] = Arrays.copyOf((long[])this.columns[i], this.rowCount);
                        continue block8;
                    }
                    case FLOAT: {
                        this.columns[i] = Arrays.copyOf((float[])this.columns[i], this.rowCount);
                        continue block8;
                    }
                    case DOUBLE: {
                        this.columns[i] = Arrays.copyOf((double[])this.columns[i], this.rowCount);
                        continue block8;
                    }
                    case TEXT: 
                    case STRING: 
                    case BLOB: {
                        this.columns[i] = Arrays.copyOf((Binary[])this.columns[i], this.rowCount);
                        continue block8;
                    }
                    default: {
                        throw new UnSupportedDataTypeException(String.format("Data type %s is not supported.", this.dataTypes[i]));
                    }
                }
            }
        }
        insertTabletStatement.setTimes(this.times);
        insertTabletStatement.setBitMaps(this.bitMaps);
        insertTabletStatement.setColumns(this.columns);
        return insertTabletStatement;
    }

    public boolean isFull() {
        return this.rowCount == this.rowLimit;
    }

    public boolean isEmpty() {
        return this.rowCount == 0;
    }

    public String getDevice() {
        return this.devicePath.toString();
    }

    protected long ramBytesUsedByTimeAndColumns() {
        return RamUsageEstimator.sizeOf((long[])this.times) + this.getColumnsBytes() + this.getBitMapsBytes();
    }

    public abstract long getWrittenCount();

    public abstract long getWrittenCount(String var1);

    public abstract int processTsBlock(TsBlock var1, int var2);

    protected void processColumn(Column valueColumn, Object columns, TSDataType dataType, Type sourceTypeConvertor, int rowIndex) {
        switch (dataType) {
            case INT32: 
            case DATE: {
                ((int[])columns)[this.rowCount] = sourceTypeConvertor.getInt(valueColumn, rowIndex);
                break;
            }
            case INT64: 
            case TIMESTAMP: {
                ((long[])columns)[this.rowCount] = sourceTypeConvertor.getLong(valueColumn, rowIndex);
                break;
            }
            case FLOAT: {
                ((float[])columns)[this.rowCount] = sourceTypeConvertor.getFloat(valueColumn, rowIndex);
                break;
            }
            case DOUBLE: {
                ((double[])columns)[this.rowCount] = sourceTypeConvertor.getDouble(valueColumn, rowIndex);
                break;
            }
            case BOOLEAN: {
                ((boolean[])columns)[this.rowCount] = sourceTypeConvertor.getBoolean(valueColumn, rowIndex);
                break;
            }
            case TEXT: 
            case STRING: 
            case BLOB: {
                ((Binary[])columns)[this.rowCount] = sourceTypeConvertor.getBinary(valueColumn, rowIndex);
                break;
            }
            default: {
                throw new UnSupportedDataTypeException(String.format("data type %s is not supported when convert data at client", valueColumn.getDataType()));
            }
        }
    }

    protected long sizeOf(Object[] arr, Class<?> clazz) {
        if (arr == null) {
            return 0L;
        }
        long size = RamUsageEstimator.shallowSizeOf((Object[])arr);
        long clazzSize = RamUsageEstimator.shallowSizeOfInstance(clazz);
        for (Object s : arr) {
            if (s == null) continue;
            size += clazzSize;
        }
        return size;
    }

    private long getBitMapsBytes() {
        if (this.bitMaps == null) {
            return 0L;
        }
        return Arrays.stream(this.bitMaps).mapToLong(x -> BitMap.getSizeOfBytes((int)x.getSize())).sum();
    }

    private long getColumnsBytes() {
        if (this.columns == null) {
            return 0L;
        }
        long bytes = 0L;
        block8: for (int i = 0; i < this.columns.length; ++i) {
            switch (this.dataTypes[i]) {
                case INT32: 
                case DATE: {
                    bytes += RamUsageEstimator.sizeOf((int[])((int[])this.columns[i]));
                    continue block8;
                }
                case INT64: 
                case TIMESTAMP: {
                    bytes += RamUsageEstimator.sizeOf((long[])((long[])this.columns[i]));
                    continue block8;
                }
                case FLOAT: {
                    bytes += RamUsageEstimator.sizeOf((float[])((float[])this.columns[i]));
                    continue block8;
                }
                case DOUBLE: {
                    bytes += RamUsageEstimator.sizeOf((double[])((double[])this.columns[i]));
                    continue block8;
                }
                case BOOLEAN: {
                    bytes += RamUsageEstimator.sizeOf((boolean[])((boolean[])this.columns[i]));
                    continue block8;
                }
                case TEXT: 
                case STRING: 
                case BLOB: {
                    bytes += RamUsageEstimator.sizeOf((Accountable[])((Binary[])this.columns[i]));
                    continue block8;
                }
                default: {
                    throw new UnSupportedDataTypeException(String.format("data type %s is not supported when convert data at client", this.dataTypes[i]));
                }
            }
        }
        return bytes;
    }
}

