/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.query.text.filter;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.miscellaneous.ASCIIFoldingFilter;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.util.ArrayUtil;

public final class SelectiveFoldingFilter
extends TokenFilter {
    private final CharTermAttribute termAtt = this.addAttribute(CharTermAttribute.class);
    private CharArraySet whitelisted;

    public SelectiveFoldingFilter(TokenStream input, CharArraySet whitelisted) {
        super(input);
        Objects.requireNonNull(whitelisted, "You must provide the list of whiltelisted characters.");
        this.whitelisted = CharArraySet.unmodifiableSet(CharArraySet.copy(whitelisted));
    }

    @Override
    public boolean incrementToken() throws IOException {
        if (this.input.incrementToken()) {
            char[] buffer = this.termAtt.buffer();
            int length = this.termAtt.length();
            int maxSizeNeeded = 4 * length;
            char[] output = new char[ArrayUtil.oversize(maxSizeNeeded, 2)];
            for (int i = 0; i < length; ++i) {
                char c = buffer[i];
                if (c >= '\u0080' && !this.whitelisted.contains(Character.valueOf(c))) {
                    ASCIIFoldingFilter.foldToASCII(buffer, i, output, i, 1);
                    continue;
                }
                output[i] = c;
            }
            this.termAtt.copyBuffer(output, 0, length);
            return true;
        }
        return false;
    }
}

