/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rfc3986.cmd;

import java.io.PrintStream;
import org.apache.jena.rfc3986.IRI3986;
import org.apache.jena.rfc3986.IRIParseException;
import org.apache.jena.rfc3986.RFC3986;

public class CmdIRI {
    public static void main(String ... args) {
        if (args.length == 0) {
            System.err.println("No iri string");
            System.exit(1);
        }
        boolean first = true;
        PrintStream out = System.out;
        PrintStream err = System.err;
        for (String iriStrInput : args) {
            if (iriStrInput.startsWith("<") && iriStrInput.endsWith(">")) {
                iriStrInput = iriStrInput.substring(1, iriStrInput.length() - 1);
            }
            if (!first) {
                first = false;
                out.println();
            }
            String iriStr = iriStrInput;
            try {
                IRI3986 iri2 = RFC3986.create(iriStr);
                IRI3986 iri1 = iri2.normalize();
                out.printf("Input: <%s>\n", iriStr);
                out.printf("  Parsed:       %s\n", iri2.rebuild());
                out.printf("  Absolute:     %s\n", iri2.isAbsolute());
                out.printf("  Relative:     %s\n", iri2.isRelative());
                out.printf("  Hierarchical: %s\n", iri2.isHierarchical());
                out.printf("  Rootless:     %s\n", iri2.isRootless());
                if (!iri2.equals(iri1)) {
                    out.printf("  Normalized:   %s\n", iri1);
                }
                out.printf("\n", new Object[0]);
                out.printf("%s|%s|  ", "Scheme", iri2.scheme());
                out.printf("%s|%s|  ", "Authority", iri2.authority());
                out.printf("%s|%s|  ", "Host", iri2.host());
                if (iri2.hasPort()) {
                    out.printf("%s|%s|  ", "Port", iri2.port());
                }
                out.printf("%s|%s|  ", "Path", iri2.path());
                out.printf("%s|%s|  ", "Query", iri2.query());
                out.printf("%s|%s|", "Fragment", iri2.fragment());
                out.println();
                if (!iri2.hasViolations()) continue;
                out.println();
                out.println("Scheme specific warnings:");
                iri2.forEachViolation(v -> {
                    out.print("   ");
                    err.printf("%s\n", v.message());
                });
            }
            catch (IRIParseException ex) {
                System.err.printf("Error: %s\n", ex.getMessage());
            }
        }
    }
}

