/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.xml.bind.metadata.code;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.adapters.XmlAdapter;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.util.Locale;
import org.apache.sis.xml.ValueConverter;
import org.apache.sis.xml.bind.Context;
import org.apache.sis.xml.bind.cat.CodeListUID;
import org.opengis.metadata.identification.CharacterSet;

public final class MD_CharacterSetCode
extends XmlAdapter<MD_CharacterSetCode, Charset> {
    private CodeListUID identifier;

    @Override
    public final Charset unmarshal(MD_CharacterSetCode adapter) throws IllegalCharsetNameException {
        Context context2 = Context.current();
        return Context.converter(context2).toCharset(context2, adapter.identifier.toString());
    }

    @Override
    public final MD_CharacterSetCode marshal(Charset value) {
        Context context2 = Context.current();
        ValueConverter converter = Context.converter(context2);
        String code = converter.toCharsetCode(context2, value);
        if (code != null) {
            Locale locale = context2.getLocale();
            MD_CharacterSetCode c = new MD_CharacterSetCode();
            c.identifier = new CodeListUID(context2, "MD_CharacterSetCode", code, locale != null ? converter.toLanguageCode(context2, locale) : null, locale != null ? value.displayName(locale) : value.displayName());
            return c;
        }
        return null;
    }

    @XmlElement(name="MD_CharacterSetCode", namespace="http://standards.iso.org/iso/19115/-3/lan/1.0")
    public CodeListUID getElement() {
        return this.identifier;
    }

    public void setElement(CodeListUID value) {
        this.identifier = value;
    }

    public static CharacterSet fromCharset(Charset cs) {
        if (cs == null) {
            return null;
        }
        String name = cs.name();
        for (CharacterSet candidate : CharacterSet.values()) {
            for (String n : candidate.names()) {
                if (!name.equals(n)) continue;
                return candidate;
            }
        }
        return CharacterSet.valueOf(name);
    }
}

