/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.jsonld.json;

import com.apicatalog.jsonld.StringUtils;
import com.apicatalog.jsonld.json.JsonProvider;
import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Stream;

public final class JsonUtils {
    JsonUtils() {
    }

    public static final boolean contains(String text, JsonValue value) {
        if (text == null) {
            return value == null;
        }
        if (value == null) {
            return false;
        }
        if (JsonUtils.isString(value)) {
            return text.equals(((JsonString)value).getString());
        }
        if (JsonUtils.isArray(value)) {
            return value.asJsonArray().contains(JsonProvider.instance().createValue(text));
        }
        if (JsonUtils.isObject(value)) {
            return value.asJsonObject().containsKey(text);
        }
        return false;
    }

    public static final boolean containsKey(JsonValue object, String key) {
        return object != null && JsonValue.ValueType.OBJECT.equals((Object)object.getValueType()) && object.asJsonObject().containsKey(key);
    }

    public static final boolean isScalar(JsonValue value) {
        return value != null && !JsonValue.ValueType.ARRAY.equals((Object)value.getValueType()) && !JsonValue.ValueType.OBJECT.equals((Object)value.getValueType());
    }

    public static final boolean isNotScalar(JsonValue value) {
        return !JsonUtils.isScalar(value);
    }

    public static final boolean isNull(JsonValue value) {
        return value == null || JsonValue.ValueType.NULL.equals((Object)value.getValueType());
    }

    public static final boolean isNotNull(JsonValue value) {
        return !JsonUtils.isNull(value);
    }

    public static boolean isString(JsonValue value) {
        return value != null && JsonValue.ValueType.STRING.equals((Object)value.getValueType());
    }

    public static boolean isNotString(JsonValue value) {
        return value == null || !JsonValue.ValueType.STRING.equals((Object)value.getValueType());
    }

    public static boolean isNotArray(JsonValue value) {
        return value == null || !JsonValue.ValueType.ARRAY.equals((Object)value.getValueType());
    }

    public static boolean isArray(JsonValue value) {
        return value != null && JsonValue.ValueType.ARRAY.equals((Object)value.getValueType());
    }

    public static boolean isObject(JsonValue value) {
        return value != null && JsonValue.ValueType.OBJECT.equals((Object)value.getValueType());
    }

    public static boolean isNotObject(JsonValue value) {
        return value == null || !JsonValue.ValueType.OBJECT.equals((Object)value.getValueType());
    }

    public static boolean isNumber(JsonValue value) {
        return value != null && JsonValue.ValueType.NUMBER.equals((Object)value.getValueType());
    }

    public static boolean isNotBoolean(JsonValue value) {
        return value == null || !JsonValue.ValueType.TRUE.equals((Object)value.getValueType()) && !JsonValue.ValueType.FALSE.equals((Object)value.getValueType());
    }

    public static boolean isNotNumber(JsonValue value) {
        return value == null || !JsonValue.ValueType.NUMBER.equals((Object)value.getValueType());
    }

    public static boolean isTrue(JsonValue value) {
        return value != null && JsonValue.ValueType.TRUE.equals((Object)value.getValueType());
    }

    public static boolean isFalse(JsonValue value) {
        return value != null && JsonValue.ValueType.FALSE.equals((Object)value.getValueType());
    }

    public static boolean isEmptyObject(JsonValue value) {
        return JsonUtils.isObject(value) && value.asJsonObject().isEmpty();
    }

    public static boolean isEmptyArray(JsonValue value) {
        return JsonUtils.isArray(value) && value.asJsonArray().isEmpty();
    }

    public static JsonObject toJsonObject(Map<String, JsonValue> map) {
        JsonObjectBuilder builder = JsonProvider.instance().createObjectBuilder();
        map.entrySet().forEach(e2 -> builder.add((String)e2.getKey(), (JsonValue)e2.getValue()));
        return builder.build();
    }

    public static JsonObject merge(JsonObject target, JsonObject source) {
        LinkedHashMap<String, JsonValue> targetMap = new LinkedHashMap<String, JsonValue>(target);
        source.forEach(targetMap::put);
        return JsonUtils.toJsonObject(targetMap);
    }

    public static Collection<JsonValue> toCollection(JsonValue value) {
        if (value == null) {
            return Collections.emptyList();
        }
        if (JsonValue.ValueType.ARRAY.equals((Object)value.getValueType())) {
            return value.asJsonArray();
        }
        return Collections.singletonList(value);
    }

    public static Stream<JsonValue> toStream(JsonValue value) {
        if (value == null) {
            return Stream.empty();
        }
        if (JsonValue.ValueType.ARRAY.equals((Object)value.getValueType())) {
            return value.asJsonArray().stream();
        }
        return Stream.of(value);
    }

    public static JsonArray toJsonArray(JsonValue value) {
        return JsonUtils.isArray(value) ? value.asJsonArray() : JsonProvider.instance().createArrayBuilder().add(value).build();
    }

    public static boolean isBlankString(JsonValue value) {
        return JsonUtils.isString(value) && StringUtils.isBlank(((JsonString)value).getString());
    }

    public static JsonValue toJsonValue(String value) {
        return value != null && StringUtils.isNotBlank(value) ? JsonProvider.instance().createValue(value) : JsonValue.NULL;
    }

    public static boolean isNonEmptyArray(JsonValue value) {
        return JsonUtils.isArray(value) && !value.asJsonArray().isEmpty();
    }

    public static boolean isNonEmptyObject(JsonValue value) {
        return JsonUtils.isObject(value) && !value.asJsonObject().isEmpty();
    }

    @Deprecated
    public static boolean isNotEmptyArray(JsonValue value) {
        return JsonUtils.isNotArray(value) || !value.asJsonArray().isEmpty();
    }

    @Deprecated
    public static boolean isNotEmptyObject(JsonValue value) {
        return JsonUtils.isNotObject(value) || !value.asJsonObject().isEmpty();
    }

    public static JsonValue flatten(JsonValue value, String key) {
        if (JsonUtils.isArray(value) && value.asJsonArray().size() == 1) {
            value = (JsonValue)value.asJsonArray().get(0);
        }
        if (JsonUtils.isObject(value) && value.asJsonObject().containsKey(key)) {
            value = (JsonValue)value.asJsonObject().get(key);
        }
        return value;
    }
}

