/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.lucene90;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.codecs.PointsFormat;
import org.apache.lucene.codecs.PointsReader;
import org.apache.lucene.codecs.PointsWriter;
import org.apache.lucene.codecs.lucene90.Lucene90PointsReader;
import org.apache.lucene.codecs.lucene90.Lucene90PointsWriter;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SegmentWriteState;

public final class Lucene90PointsFormat
extends PointsFormat {
    static final String DATA_CODEC_NAME = "Lucene90PointsFormatData";
    static final String INDEX_CODEC_NAME = "Lucene90PointsFormatIndex";
    static final String META_CODEC_NAME = "Lucene90PointsFormatMeta";
    public static final String DATA_EXTENSION = "kdd";
    public static final String INDEX_EXTENSION = "kdi";
    public static final String META_EXTENSION = "kdm";
    static final int VERSION_START = 0;
    static final int VERSION_BKD_VECTORIZED_BPV24 = 1;
    static final int VERSION_CURRENT = 1;
    private static final Map<Integer, Integer> VERSION_TO_BKD_VERSION = Map.of(0, 9, 1, 10);
    private final int version;

    public Lucene90PointsFormat() {
        this(1);
    }

    Lucene90PointsFormat(int version2) {
        if (!VERSION_TO_BKD_VERSION.containsKey(version2)) {
            throw new IllegalArgumentException("Invalid version: " + version2);
        }
        this.version = version2;
    }

    @Override
    public PointsWriter fieldsWriter(SegmentWriteState state) throws IOException {
        return new Lucene90PointsWriter(state, this.version);
    }

    @Override
    public PointsReader fieldsReader(SegmentReadState state) throws IOException {
        return new Lucene90PointsReader(state);
    }

    static int bkdVersion(int version2) {
        return VERSION_TO_BKD_VERSION.get(version2);
    }
}

