/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.nio.file.Path;
import java.util.Locale;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.logging.Logger;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.store.DataAccessHint;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.FSLockFactory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.store.PreloadHint;
import org.apache.lucene.store.ReadAdvice;
import org.apache.lucene.store.ReadOnceHint;
import org.apache.lucene.util.Constants;

public class MMapDirectory
extends FSDirectory {
    public static final BiPredicate<String, IOContext> ALL_FILES = (filename, context2) -> true;
    public static final BiPredicate<String, IOContext> NO_FILES = (filename, context2) -> false;
    public static final BiPredicate<String, IOContext> PRELOAD_HINT = (filename, context2) -> context2.hints().contains(PreloadHint.INSTANCE);
    public static final String SHARED_ARENA_MAX_PERMITS_SYSPROP = "org.apache.lucene.store.MMapDirectory.sharedArenaMaxPermits";
    public static final Function<String, Optional<String>> NO_GROUPING = filename -> Optional.empty();
    public static final Function<String, Optional<String>> GROUP_BY_SEGMENT = filename -> {
        if (!IndexFileNames.CODEC_FILE_PATTERN.matcher((CharSequence)filename).matches()) {
            return Optional.empty();
        }
        Object groupKey = IndexFileNames.parseSegmentName(filename).substring(1);
        try {
            if (IndexFileNames.parseGeneration(filename) > 0L) {
                groupKey = (String)groupKey + "-g";
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return Optional.of(groupKey);
    };
    public static final BiFunction<String, IOContext, Optional<ReadAdvice>> ADVISE_BY_CONTEXT = (filename, context2) -> {
        if (context2.context() == IOContext.Context.MERGE || context2.context() == IOContext.Context.FLUSH) {
            return Optional.of(ReadAdvice.SEQUENTIAL);
        }
        if (context2.hints().contains(DataAccessHint.RANDOM)) {
            return Optional.of(ReadAdvice.RANDOM);
        }
        if (context2.hints().contains(DataAccessHint.SEQUENTIAL)) {
            return Optional.of(ReadAdvice.SEQUENTIAL);
        }
        return Optional.of(Constants.DEFAULT_READADVICE);
    };
    private BiFunction<String, IOContext, Optional<ReadAdvice>> readAdvice = (filename, context2) -> Optional.empty();
    private BiPredicate<String, IOContext> preload = NO_FILES;
    public static final long DEFAULT_MAX_CHUNK_SIZE;
    final Object attachment = PROVIDER.attachment();
    private Function<String, Optional<String>> groupingFunction = GROUP_BY_SEGMENT;
    final int chunkSizePower;
    static final MMapIndexInputProvider<Object> PROVIDER;

    public MMapDirectory(Path path, LockFactory lockFactory) throws IOException {
        this(path, lockFactory, DEFAULT_MAX_CHUNK_SIZE);
    }

    public MMapDirectory(Path path) throws IOException {
        this(path, FSLockFactory.getDefault());
    }

    public MMapDirectory(Path path, long maxChunkSize) throws IOException {
        this(path, FSLockFactory.getDefault(), maxChunkSize);
    }

    public MMapDirectory(Path path, LockFactory lockFactory, long maxChunkSize) throws IOException {
        super(path, lockFactory);
        if (maxChunkSize <= 0L) {
            throw new IllegalArgumentException("Maximum chunk size for mmap must be >0");
        }
        this.chunkSizePower = 63 - Long.numberOfLeadingZeros(maxChunkSize);
        assert (1L << this.chunkSizePower <= maxChunkSize);
        assert (1L << this.chunkSizePower > maxChunkSize / 2L);
    }

    public void setPreload(BiPredicate<String, IOContext> preload) {
        this.preload = preload;
    }

    public void setReadAdvice(BiFunction<String, IOContext, Optional<ReadAdvice>> toReadAdvice) {
        this.readAdvice = toReadAdvice;
    }

    public void setGroupingFunction(Function<String, Optional<String>> groupingFunction) {
        this.groupingFunction = groupingFunction;
    }

    public final long getMaxChunkSize() {
        return 1L << this.chunkSizePower;
    }

    @Override
    public IndexInput openInput(String name, IOContext context2) throws IOException {
        this.ensureOpen();
        this.ensureCanRead(name);
        Path path = this.directory.resolve(name);
        Function<IOContext, ReadAdvice> toReadAdvice = c -> this.readAdvice.apply(name, (IOContext)c).orElse(Constants.DEFAULT_READADVICE);
        return PROVIDER.openInput(path, this.chunkSizePower, context2, toReadAdvice, context2.hints().contains(ReadOnceHint.INSTANCE), this.preload.test(name, context2), this.groupingFunction.apply(name), this.attachment);
    }

    private static int getSharedArenaMaxPermitsSysprop() {
        int ret = 1024;
        try {
            String str2 = System.getProperty(SHARED_ARENA_MAX_PERMITS_SYSPROP);
            if (str2 != null) {
                ret = Integer.parseInt(str2);
            }
        }
        catch (NumberFormatException | SecurityException ignored) {
            Logger.getLogger(MMapDirectory.class.getName()).warning("Cannot read sysprop org.apache.lucene.store.MMapDirectory.sharedArenaMaxPermits, so the default value will be used.");
        }
        return ret;
    }

    private static <A> MMapIndexInputProvider<A> lookupProvider() {
        int maxPermits = MMapDirectory.getSharedArenaMaxPermitsSysprop();
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        try {
            Class<?> cls = lookup.findClass("org.apache.lucene.store.MemorySegmentIndexInputProvider");
            MethodHandle constr = lookup.findConstructor(cls, MethodType.methodType(Void.TYPE, Integer.TYPE));
            try {
                return constr.invoke(maxPermits);
            }
            catch (Error | RuntimeException e2) {
                throw e2;
            }
            catch (Throwable th) {
                throw new AssertionError((Object)th);
            }
        }
        catch (IllegalAccessException | NoSuchMethodException e3) {
            throw new LinkageError("MemorySegmentIndexInputProvider is missing correctly typed constructor", e3);
        }
        catch (ClassNotFoundException cnfe) {
            throw new LinkageError("MemorySegmentIndexInputProvider is missing in Lucene JAR file", cnfe);
        }
    }

    public static boolean supportsMadvise() {
        return PROVIDER.supportsMadvise();
    }

    static {
        PROVIDER = MMapDirectory.lookupProvider();
        DEFAULT_MAX_CHUNK_SIZE = PROVIDER.getDefaultMaxChunkSize();
    }

    static interface MMapIndexInputProvider<A> {
        public IndexInput openInput(Path var1, int var2, IOContext var3, Function<IOContext, ReadAdvice> var4, boolean var5, boolean var6, Optional<String> var7, A var8) throws IOException;

        public long getDefaultMaxChunkSize();

        public boolean supportsMadvise();

        default public A attachment() {
            return null;
        }

        default public IOException convertMapFailedIOException(IOException ioe, String resourceDescription, long bufSize) {
            Throwable originalCause;
            String originalMessage;
            if (ioe.getCause() instanceof OutOfMemoryError) {
                originalMessage = "Map failed";
                originalCause = null;
            } else {
                originalMessage = ioe.getMessage();
                originalCause = ioe.getCause();
            }
            String moreInfo = !Constants.JRE_IS_64BIT ? "MMapDirectory should only be used on 64bit platforms, because the address space on 32bit operating systems is too small. " : (Constants.WINDOWS ? "Windows is unfortunately very limited on virtual address space. If your index size is several hundred Gigabytes, consider changing to Linux. " : (Constants.LINUX ? "Please review 'ulimit -v', 'ulimit -m' (both should return 'unlimited'), and 'sysctl vm.max_map_count'. " : "Please review 'ulimit -v', 'ulimit -m' (both should return 'unlimited'). "));
            IOException newIoe = new IOException(String.format(Locale.ENGLISH, "%s: %s [this may be caused by lack of enough unfragmented virtual address space or too restrictive virtual memory limits enforced by the operating system, preventing us to map a chunk of %d bytes. %sMore information: https://blog.thetaphi.de/2012/07/use-lucenes-mmapdirectory-on-64bit.html]", originalMessage, resourceDescription, bufSize, moreInfo), originalCause);
            newIoe.setStackTrace(ioe.getStackTrace());
            return newIoe;
        }
    }
}

