/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.log.remote.storage;

import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.server.log.remote.storage.RemoteLogManager;
import org.apache.kafka.storage.internals.epoch.LeaderEpochFileCache;
import org.apache.kafka.storage.internals.log.AsyncOffsetReader;
import org.apache.kafka.storage.internals.log.OffsetResultHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteLogOffsetReader
implements Callable<Void> {
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteLogOffsetReader.class);
    private final RemoteLogManager rlm;
    private final TopicPartition tp;
    private final long timestamp;
    private final long startingOffset;
    private final LeaderEpochFileCache leaderEpochCache;
    private final AsyncOffsetReader.TimestampAndOffsetSupplier searchInLocalLog;
    private final Consumer<OffsetResultHolder.FileRecordsOrError> callback;

    public RemoteLogOffsetReader(RemoteLogManager rlm, TopicPartition tp, long timestamp, long startingOffset, LeaderEpochFileCache leaderEpochCache, AsyncOffsetReader.TimestampAndOffsetSupplier searchInLocalLog, Consumer<OffsetResultHolder.FileRecordsOrError> callback) {
        this.rlm = rlm;
        this.tp = tp;
        this.timestamp = timestamp;
        this.startingOffset = startingOffset;
        this.leaderEpochCache = leaderEpochCache;
        this.searchInLocalLog = searchInLocalLog;
        this.callback = callback;
    }

    @Override
    public Void call() throws Exception {
        OffsetResultHolder.FileRecordsOrError result;
        try {
            Optional<FileRecords.TimestampAndOffset> timestampAndOffsetOpt = this.rlm.findOffsetByTimestamp(this.tp, this.timestamp, this.startingOffset, this.leaderEpochCache);
            if (timestampAndOffsetOpt.isEmpty()) {
                timestampAndOffsetOpt = this.searchInLocalLog.get();
            }
            result = new OffsetResultHolder.FileRecordsOrError(Optional.empty(), timestampAndOffsetOpt);
        }
        catch (Exception e) {
            LOGGER.error("Error occurred while reading the remote log offset for {}", (Object)this.tp, (Object)e);
            result = new OffsetResultHolder.FileRecordsOrError(Optional.of(e), Optional.empty());
        }
        this.callback.accept(result);
        return null;
    }
}

