/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.jaas.modules.encryption;

import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import org.apache.karaf.jaas.modules.Encryption;
import org.apache.karaf.jaas.modules.EncryptionService;
import org.apache.karaf.jaas.modules.JAASUtils;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EncryptionSupport {
    private final Logger logger = LoggerFactory.getLogger(EncryptionSupport.class);
    private BundleContext bundleContext;
    private Encryption encryption;
    private String encryptionPrefix;
    private String encryptionSuffix;
    private boolean debug;
    private boolean enabled;
    private String name;
    private Map<String, String> encOpts;

    public static EncryptionSupport noEncryptionSupport() {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("enabled", "false");
        return new EncryptionSupport(options);
    }

    public EncryptionSupport(Map<String, ?> options) {
        this.debug = Boolean.parseBoolean(JAASUtils.getString(options, "debug"));
        this.bundleContext = (BundleContext)options.get(BundleContext.class.getName());
        this.encOpts = new HashMap<String, String>();
        for (String key : options.keySet()) {
            if (!key.startsWith("encryption.")) continue;
            this.encOpts.put(key.substring("encryption.".length()), options.get(key).toString());
        }
        this.encryptionPrefix = this.defaulIfNull(this.encOpts.remove("prefix"), "");
        this.encryptionSuffix = this.defaulIfNull(this.encOpts.remove("suffix"), "");
        this.enabled = Boolean.parseBoolean(this.encOpts.remove("enabled"));
        if (!this.enabled && this.debug) {
            this.logger.debug("Encryption is disabled.");
        }
        this.name = this.encOpts.remove("name");
        if (this.debug) {
            this.logOptions();
        }
    }

    public String encrypt(String plain) {
        this.getEncryption();
        if (this.encryption == null || this.isEncrypted(plain)) {
            return plain;
        }
        return this.encryptionPrefix + this.encryption.encryptPassword(plain) + this.encryptionSuffix;
    }

    public boolean checkPassword(String provided, String real) {
        this.getEncryption();
        if (this.encryption == null) {
            return provided != null && provided.equals(real);
        }
        String encryptedPassword = real.substring(this.encryptionPrefix.length(), real.length() - this.encryptionSuffix.length());
        return this.encryption.checkPassword(provided, encryptedPassword);
    }

    private void logOptions() {
        if (this.name != null && this.name.length() > 0) {
            this.logger.debug("Encryption is enabled. Using service " + this.name + " with options " + String.valueOf(this.encOpts));
        } else {
            this.logger.debug("Encryption is enabled. Using options " + String.valueOf(this.encOpts));
        }
    }

    private String defaulIfNull(String value, String defaultValue) {
        return value == null ? defaultValue : value;
    }

    private boolean isEncrypted(String password) {
        boolean prefixPresent = "".equals(this.encryptionPrefix) || password.startsWith(this.encryptionPrefix);
        boolean suffixPresent = "".equals(this.encryptionSuffix) || password.endsWith(this.encryptionSuffix);
        return prefixPresent && suffixPresent;
    }

    @Deprecated
    public Encryption getEncryption() {
        if (this.encryption != null || !this.enabled) {
            return this.encryption;
        }
        tracker.open();
        try (ServiceTracker tracker = new ServiceTracker(this.bundleContext, this.getFilter(), null);){
            Encryption encryption = this.getEncryptionInternal((ServiceTracker<EncryptionService, EncryptionService>)tracker);
            return encryption;
        }
    }

    private Encryption getEncryptionInternal(ServiceTracker<EncryptionService, EncryptionService> tracker) {
        try {
            tracker.waitForService(20000L);
        }
        catch (InterruptedException e1) {
            return null;
        }
        SortedMap tracked = tracker.getTracked();
        if (tracked.isEmpty()) {
            throw new IllegalStateException(this.noEncryptionServiceMsg());
        }
        for (EncryptionService encryptionService : tracked.values()) {
            try {
                Encryption encr = encryptionService.createEncryption(this.encOpts);
                if (encr == null) continue;
                this.encryption = encr;
                return this.encryption;
            }
            catch (IllegalStateException illegalStateException) {
            }
        }
        throw new IllegalStateException("No EncryptionService supporting the required options could be found.");
    }

    private String noEncryptionServiceMsg() {
        if (this.name != null && this.name.length() > 0) {
            return "Encryption service " + this.name + " not found. Please check that the encryption service is correctly set up.";
        }
        return "No encryption service found. Please install the Karaf encryption feature and check that the encryption algorithm is supported.";
    }

    private Filter getFilter() {
        String nameFilter = this.name != null && this.name.length() > 0 ? "(name=" + this.name + ")" : null;
        String objFilter = "(objectClass=" + EncryptionService.class.getName() + ")";
        String filter = nameFilter == null ? objFilter : "(&" + nameFilter + objFilter + ")";
        try {
            return FrameworkUtil.createFilter((String)filter);
        }
        catch (InvalidSyntaxException e) {
            throw new IllegalStateException(e);
        }
    }

    @Deprecated
    public String getEncryptionSuffix() {
        return this.encryptionSuffix;
    }

    @Deprecated
    public void setEncryptionSuffix(String encryptionSuffix) {
        this.encryptionSuffix = encryptionSuffix;
    }

    @Deprecated
    public String getEncryptionPrefix() {
        return this.encryptionPrefix;
    }

    @Deprecated
    public void setEncryptionPrefix(String encryptionPrefix) {
        this.encryptionPrefix = encryptionPrefix;
    }

    void setEncryption(Encryption encryption) {
        this.encryption = encryption;
    }
}

