/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juli.logging;

import java.util.List;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogConfigurationException;
import org.ops4j.pax.logging.PaxLogger;
import org.ops4j.pax.logging.PaxLoggingManager;
import org.ops4j.pax.logging.PaxLoggingManagerAwareLogger;
import org.ops4j.pax.logging.internal.Activator;
import org.ops4j.pax.logging.juli.JuliLogger;
import org.ops4j.pax.logging.spi.support.FallbackLogFactory;
import org.osgi.framework.FrameworkUtil;

public class LogFactory {
    private static final LogFactory singleton = new LogFactory();
    private static PaxLoggingManager m_paxLogging;

    private LogFactory() {
    }

    public static void setPaxLoggingManager(PaxLoggingManager manager) {
        m_paxLogging = manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Log getInstance(String name) throws LogConfigurationException {
        PaxLogger logger = m_paxLogging == null ? FallbackLogFactory.createFallbackLog(FrameworkUtil.getBundle(Log.class), name) : m_paxLogging.getLogger(name, JuliLogger.JULI_FQCN);
        JuliLogger juliLogger = new JuliLogger(name, logger);
        if (m_paxLogging == null) {
            List<PaxLoggingManagerAwareLogger> list = Activator.m_loggers;
            synchronized (list) {
                Activator.m_loggers.add(juliLogger);
            }
        }
        return juliLogger;
    }

    public Log getInstance(Class<?> clazz) throws LogConfigurationException {
        return this.getInstance(clazz.getName());
    }

    public static LogFactory getFactory() throws LogConfigurationException {
        return singleton;
    }

    public static Log getLog(Class<?> clazz) throws LogConfigurationException {
        return LogFactory.getFactory().getInstance(clazz);
    }

    public static Log getLog(String name) throws LogConfigurationException {
        return LogFactory.getFactory().getInstance(name);
    }

    public static void release(ClassLoader classLoader) {
    }
}

