/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.config.core.impl;

import java.util.Arrays;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.apache.felix.utils.properties.InterpolationHelper;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.ConfigurationPlugin;

public class KarafConfigurationPlugin
implements ConfigurationPlugin {
    public static final String PLUGIN_ID = "org.apache.karaf.config.plugin";
    public static final int PLUGIN_RANKING = 500;

    public void modifyConfiguration(ServiceReference<?> reference, Dictionary<String, Object> properties) {
        Object pid = properties.get("service.pid");
        Enumeration<String> keys = properties.keys();
        while (keys.hasMoreElements()) {
            String value;
            String key = keys.nextElement();
            String env = (String.valueOf(pid) + "." + key).toUpperCase().replaceAll("\\.", "_").replace("-", "_").replace("~", "_");
            String sys = String.valueOf(pid) + "." + key;
            if (System.getenv(env) != null) {
                value = System.getenv(env);
                if (value.startsWith("[") && value.endsWith("]")) {
                    String[] values = value.substring(1, value.length() - 1).split(",");
                    values = (String[])Arrays.stream(values).map(e -> InterpolationHelper.substVars(e, null, null, KarafConfigurationPlugin.convertDictionaryToMap(properties))).toArray(String[]::new);
                    properties.put(key, values);
                    continue;
                }
                value = InterpolationHelper.substVars(value, null, null, KarafConfigurationPlugin.convertDictionaryToMap(properties));
                try {
                    int intValue = Integer.parseInt(value);
                    properties.put(key, intValue);
                }
                catch (NumberFormatException e2) {
                    properties.put(key, value);
                }
                continue;
            }
            if (System.getProperty(sys) == null) continue;
            value = System.getProperty(sys);
            if (value.startsWith("[") && value.endsWith("]")) {
                String[] values = value.substring(1, value.length() - 1).split(",");
                values = (String[])Arrays.stream(values).map(e -> InterpolationHelper.substVars(e, null, null, KarafConfigurationPlugin.convertDictionaryToMap(properties))).toArray(String[]::new);
                properties.put(key, values);
                continue;
            }
            value = InterpolationHelper.substVars(value, null, null, KarafConfigurationPlugin.convertDictionaryToMap(properties));
            try {
                int intValue = Integer.parseInt(value);
                properties.put(key, intValue);
            }
            catch (NumberFormatException e3) {
                properties.put(key, value);
            }
        }
    }

    private static Map<String, String> convertDictionaryToMap(Dictionary<String, Object> dictionary) {
        HashMap<String, String> converted = new HashMap<String, String>();
        Enumeration<String> keys = dictionary.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            converted.put(key, dictionary.get(key).toString());
        }
        return converted;
    }
}

