/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.ExecutorService;
import org.apache.camel.AggregationStrategy;
import org.apache.camel.AsyncProducer;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.Message;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.Route;
import org.apache.camel.processor.MulticastProcessor;
import org.apache.camel.processor.ProcessorExchangePair;
import org.apache.camel.spi.NormalizedEndpointUri;
import org.apache.camel.spi.ProducerCache;
import org.apache.camel.support.AsyncProcessorConverterHelper;
import org.apache.camel.support.EndpointHelper;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.MessageHelper;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecipientListProcessor
extends MulticastProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(RecipientListProcessor.class);
    private final Iterator<?> iter;
    private boolean ignoreInvalidEndpoints;
    private ProducerCache producerCache;
    private int cacheSize;

    public RecipientListProcessor(CamelContext camelContext, Route route, ProducerCache producerCache, Iterator<?> iter) {
        super(camelContext, route, null);
        this.producerCache = producerCache;
        this.iter = iter;
    }

    public RecipientListProcessor(CamelContext camelContext, Route route, ProducerCache producerCache, Iterator<?> iter, AggregationStrategy aggregationStrategy) {
        super(camelContext, route, null, aggregationStrategy);
        this.producerCache = producerCache;
        this.iter = iter;
    }

    public RecipientListProcessor(CamelContext camelContext, Route route, ProducerCache producerCache, Iterator<?> iter, AggregationStrategy aggregationStrategy, boolean parallelProcessing, ExecutorService executorService, boolean shutdownExecutorService, boolean streaming, boolean stopOnException, long timeout, Processor onPrepare, boolean shareUnitOfWork, boolean parallelAggregate, boolean stopOnAggregateException) {
        super(camelContext, route, null, aggregationStrategy, parallelProcessing, executorService, shutdownExecutorService, streaming, stopOnException, timeout, onPrepare, shareUnitOfWork, parallelAggregate, stopOnAggregateException);
        this.producerCache = producerCache;
        this.iter = iter;
    }

    public int getCacheSize() {
        return this.cacheSize;
    }

    public void setCacheSize(int cacheSize) {
        this.cacheSize = cacheSize;
    }

    public boolean isIgnoreInvalidEndpoints() {
        return this.ignoreInvalidEndpoints;
    }

    public void setIgnoreInvalidEndpoints(boolean ignoreInvalidEndpoints) {
        this.ignoreInvalidEndpoints = ignoreInvalidEndpoints;
    }

    @Override
    protected Iterable<ProcessorExchangePair> createProcessorExchangePairs(Exchange exchange) throws Exception {
        ArrayList<ProcessorExchangePair> result = new ArrayList<ProcessorExchangePair>();
        int index = 0;
        while (this.iter.hasNext()) {
            AsyncProducer producer;
            ExchangePattern pattern;
            Endpoint endpoint;
            boolean prototype = this.cacheSize < 0;
            Object recipient = this.iter.next();
            try {
                recipient = RecipientListProcessor.prepareRecipient(exchange, recipient);
                Endpoint existing = RecipientListProcessor.getExistingEndpoint(exchange, recipient);
                if (existing == null) {
                    endpoint = RecipientListProcessor.resolveEndpoint(exchange, recipient, prototype);
                } else {
                    endpoint = existing;
                    prototype = false;
                }
                pattern = this.resolveExchangePattern(recipient);
                producer = this.producerCache.acquireProducer(endpoint);
            }
            catch (Exception e) {
                if (this.isIgnoreInvalidEndpoints()) {
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug("Endpoint uri is invalid: " + recipient + ". This exception will be ignored.", (Throwable)e);
                    continue;
                }
                throw e;
            }
            result.add(this.createProcessorExchangePair(index++, endpoint, (Producer)producer, exchange, pattern, prototype));
        }
        return result;
    }

    protected ProcessorExchangePair createProcessorExchangePair(int index, Endpoint endpoint, Producer producer, Exchange exchange, ExchangePattern pattern, boolean prototypeEndpoint) {
        Exchange copy = ExchangeHelper.createCorrelatedCopy((Exchange)exchange, (boolean)false);
        if (this.isShareUnitOfWork()) {
            this.prepareSharedUnitOfWork(copy, exchange);
        }
        RecipientListProcessor.setToEndpoint(copy, (Processor)producer);
        Route route = ExchangeHelper.getRoute((Exchange)exchange);
        Processor prepared = this.createErrorHandler(route, copy, (Processor)producer);
        if (this.onPrepare != null) {
            try {
                this.onPrepare.process(copy);
            }
            catch (Exception e) {
                copy.setException((Throwable)e);
            }
        }
        return new RecipientProcessorExchangePair(index, this.producerCache, endpoint, producer, prepared, copy, pattern, prototypeEndpoint);
    }

    protected static Object prepareRecipient(Exchange exchange, Object recipient) throws NoTypeConversionAvailableException {
        if (recipient instanceof Endpoint || recipient instanceof NormalizedEndpointUri) {
            return recipient;
        }
        if (recipient instanceof String) {
            recipient = ((String)recipient).trim();
        }
        if (recipient != null) {
            ExtendedCamelContext ecc = (ExtendedCamelContext)exchange.getContext();
            String uri = recipient instanceof String ? (String)recipient : (String)ecc.getTypeConverter().mandatoryConvertTo(String.class, exchange, recipient);
            return ecc.normalizeUri(uri);
        }
        return null;
    }

    protected static Endpoint getExistingEndpoint(Exchange exchange, Object recipient) {
        if (recipient instanceof Endpoint) {
            return (Endpoint)recipient;
        }
        if (recipient != null) {
            if (recipient instanceof NormalizedEndpointUri) {
                NormalizedEndpointUri nu = (NormalizedEndpointUri)recipient;
                ExtendedCamelContext ecc = (ExtendedCamelContext)exchange.getContext();
                return ecc.hasEndpoint(nu);
            }
            String uri = recipient.toString().trim();
            return exchange.getContext().hasEndpoint(uri);
        }
        return null;
    }

    protected static Endpoint resolveEndpoint(Exchange exchange, Object recipient, boolean prototype) {
        return prototype ? ExchangeHelper.resolvePrototypeEndpoint((Exchange)exchange, (Object)recipient) : ExchangeHelper.resolveEndpoint((Exchange)exchange, (Object)recipient);
    }

    protected ExchangePattern resolveExchangePattern(Object recipient) {
        String s = null;
        if (recipient instanceof NormalizedEndpointUri) {
            s = ((NormalizedEndpointUri)recipient).getUri();
        } else if (recipient instanceof String) {
            s = ((String)recipient).trim();
        }
        if (s != null) {
            return EndpointHelper.resolveExchangePatternFromUrl((String)s);
        }
        return null;
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        ObjectHelper.notNull((Object)this.producerCache, (String)"producerCache", (Object)((Object)this));
        ServiceHelper.startService((Object)this.producerCache);
    }

    @Override
    protected void doStop() throws Exception {
        ServiceHelper.stopService((Object)this.producerCache);
        super.doStop();
    }

    @Override
    protected void doShutdown() throws Exception {
        ServiceHelper.stopAndShutdownService((Object)this.producerCache);
        super.doShutdown();
    }

    @Override
    public String getTraceLabel() {
        return "recipientList";
    }

    static final class RecipientProcessorExchangePair
    implements ProcessorExchangePair {
        private final int index;
        private final Endpoint endpoint;
        private final AsyncProducer producer;
        private Processor prepared;
        private final Exchange exchange;
        private final ProducerCache producerCache;
        private final ExchangePattern pattern;
        private volatile ExchangePattern originalPattern;
        private final boolean prototypeEndpoint;

        private RecipientProcessorExchangePair(int index, ProducerCache producerCache, Endpoint endpoint, Producer producer, Processor prepared, Exchange exchange, ExchangePattern pattern, boolean prototypeEndpoint) {
            this.index = index;
            this.producerCache = producerCache;
            this.endpoint = endpoint;
            this.producer = AsyncProcessorConverterHelper.convert((Producer)producer);
            this.prepared = prepared;
            this.exchange = exchange;
            this.pattern = pattern;
            this.prototypeEndpoint = prototypeEndpoint;
        }

        @Override
        public int getIndex() {
            return this.index;
        }

        @Override
        public Exchange getExchange() {
            return this.exchange;
        }

        @Override
        public Producer getProducer() {
            return this.producer;
        }

        @Override
        public Processor getProcessor() {
            return this.prepared;
        }

        @Override
        public void begin() {
            LOG.trace("RecipientProcessorExchangePair #{} begin: {}", (Object)this.index, (Object)this.exchange);
            this.exchange.setProperty("CamelRecipientListEndpoint", (Object)this.endpoint.getEndpointUri());
            MessageHelper.resetStreamCache((Message)this.exchange.getIn());
            if (this.pattern != null) {
                this.originalPattern = this.exchange.getPattern();
                LOG.trace("Using exchangePattern: {} on exchange: {}", (Object)this.pattern, (Object)this.exchange);
                this.exchange.setPattern(this.pattern);
            }
        }

        @Override
        public void done() {
            block4: {
                LOG.trace("RecipientProcessorExchangePair #{} done: {}", (Object)this.index, (Object)this.exchange);
                try {
                    if (this.originalPattern != null) {
                        this.exchange.setPattern(this.originalPattern);
                    }
                    this.producerCache.releaseProducer(this.endpoint, this.producer);
                    if (this.prototypeEndpoint) {
                        ServiceHelper.stopAndShutdownService((Object)this.endpoint);
                    }
                }
                catch (Exception e) {
                    if (!LOG.isDebugEnabled()) break block4;
                    LOG.debug("Error releasing producer: " + this.producer + ". This exception will be ignored.", (Throwable)e);
                }
            }
        }
    }
}

