/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import java.util.Iterator;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.model.FaultToleranceConfigurationDefinition;
import org.apache.camel.model.HystrixConfigurationDefinition;
import org.apache.camel.model.OnFallbackDefinition;
import org.apache.camel.model.OutputDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.Resilience4jConfigurationCommon;
import org.apache.camel.model.Resilience4jConfigurationDefinition;
import org.apache.camel.spi.Metadata;

@Metadata(label="eip,routing,circuitbreaker")
@XmlRootElement(name="circuitBreaker")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class CircuitBreakerDefinition
extends OutputDefinition<CircuitBreakerDefinition> {
    @XmlElement
    private HystrixConfigurationDefinition hystrixConfiguration;
    @XmlElement
    private Resilience4jConfigurationDefinition resilience4jConfiguration;
    @XmlElement
    private FaultToleranceConfigurationDefinition faultToleranceConfiguration;
    @XmlAttribute
    private String configurationRef;
    @XmlTransient
    private OnFallbackDefinition onFallback;

    @Override
    public String toString() {
        return "CircuitBreaker[" + this.getOutputs() + "]";
    }

    @Override
    public String getShortName() {
        return "circuitBreaker";
    }

    @Override
    public String getLabel() {
        return "circuitBreaker";
    }

    @Override
    public List<ProcessorDefinition<?>> getOutputs() {
        return this.outputs;
    }

    @Override
    @XmlElementRef
    public void setOutputs(List<ProcessorDefinition<?>> outputs) {
        super.setOutputs(outputs);
    }

    @Override
    public void addOutput(ProcessorDefinition<?> output) {
        if (output instanceof OnFallbackDefinition) {
            this.onFallback = (OnFallbackDefinition)output;
        } else if (this.onFallback != null) {
            this.onFallback.addOutput(output);
        } else {
            super.addOutput(output);
        }
    }

    @Override
    public ProcessorDefinition<?> end() {
        if (this.onFallback != null) {
            this.onFallback.end();
        }
        return super.end();
    }

    @Override
    public void preCreateProcessor() {
        Iterator it = this.outputs.iterator();
        while (it.hasNext()) {
            ProcessorDefinition out = (ProcessorDefinition)it.next();
            if (!(out instanceof OnFallbackDefinition)) continue;
            this.onFallback = (OnFallbackDefinition)out;
            it.remove();
        }
    }

    @Deprecated
    public HystrixConfigurationDefinition getHystrixConfiguration() {
        return this.hystrixConfiguration;
    }

    @Deprecated
    public void setHystrixConfiguration(HystrixConfigurationDefinition hystrixConfiguration) {
        this.hystrixConfiguration = hystrixConfiguration;
    }

    public Resilience4jConfigurationCommon getResilience4jConfiguration() {
        return this.resilience4jConfiguration;
    }

    public void setResilience4jConfiguration(Resilience4jConfigurationDefinition resilience4jConfiguration) {
        this.resilience4jConfiguration = resilience4jConfiguration;
    }

    public FaultToleranceConfigurationDefinition getFaultToleranceConfiguration() {
        return this.faultToleranceConfiguration;
    }

    public void setFaultToleranceConfiguration(FaultToleranceConfigurationDefinition faultToleranceConfiguration) {
        this.faultToleranceConfiguration = faultToleranceConfiguration;
    }

    public String getConfigurationRef() {
        return this.configurationRef;
    }

    public void setConfigurationRef(String configurationRef) {
        this.configurationRef = configurationRef;
    }

    public OnFallbackDefinition getOnFallback() {
        return this.onFallback;
    }

    public void setOnFallback(OnFallbackDefinition onFallback) {
        this.onFallback = onFallback;
    }

    @Deprecated
    public HystrixConfigurationDefinition hystrixConfiguration() {
        this.hystrixConfiguration = this.hystrixConfiguration == null ? new HystrixConfigurationDefinition(this) : this.hystrixConfiguration;
        return this.hystrixConfiguration;
    }

    @Deprecated
    public CircuitBreakerDefinition hystrixConfiguration(HystrixConfigurationDefinition configuration) {
        this.hystrixConfiguration = configuration;
        return this;
    }

    public Resilience4jConfigurationDefinition resilience4jConfiguration() {
        this.resilience4jConfiguration = this.resilience4jConfiguration == null ? new Resilience4jConfigurationDefinition(this) : this.resilience4jConfiguration;
        return this.resilience4jConfiguration;
    }

    public CircuitBreakerDefinition resilience4jConfiguration(Resilience4jConfigurationDefinition configuration) {
        this.resilience4jConfiguration = configuration;
        return this;
    }

    public FaultToleranceConfigurationDefinition faultToleranceConfiguration() {
        this.faultToleranceConfiguration = this.faultToleranceConfiguration == null ? new FaultToleranceConfigurationDefinition(this) : this.faultToleranceConfiguration;
        return this.faultToleranceConfiguration;
    }

    public CircuitBreakerDefinition faultToleranceConfiguration(FaultToleranceConfigurationDefinition configuration) {
        this.faultToleranceConfiguration = configuration;
        return this;
    }

    public CircuitBreakerDefinition configuration(String ref) {
        this.configurationRef = ref;
        return this;
    }

    public CircuitBreakerDefinition onFallback() {
        this.onFallback = new OnFallbackDefinition();
        this.onFallback.setParent(this);
        return this;
    }

    public CircuitBreakerDefinition onFallbackViaNetwork() {
        this.onFallback = new OnFallbackDefinition();
        this.onFallback.setFallbackViaNetwork(Boolean.toString(true));
        this.onFallback.setParent(this);
        return this;
    }
}

