/*
 * Decompiled with CFR 0.152.
 */
package org.messaginghub.pooled.jms.util;

import javax.jms.IllegalStateException;
import javax.jms.IllegalStateRuntimeException;
import javax.jms.InvalidClientIDException;
import javax.jms.InvalidClientIDRuntimeException;
import javax.jms.InvalidDestinationException;
import javax.jms.InvalidDestinationRuntimeException;
import javax.jms.InvalidSelectorException;
import javax.jms.InvalidSelectorRuntimeException;
import javax.jms.JMSException;
import javax.jms.JMSRuntimeException;
import javax.jms.JMSSecurityException;
import javax.jms.JMSSecurityRuntimeException;
import javax.jms.MessageEOFException;
import javax.jms.MessageFormatException;
import javax.jms.MessageFormatRuntimeException;
import javax.jms.MessageNotWriteableException;
import javax.jms.MessageNotWriteableRuntimeException;
import javax.jms.ResourceAllocationException;
import javax.jms.ResourceAllocationRuntimeException;
import javax.jms.TransactionInProgressException;
import javax.jms.TransactionInProgressRuntimeException;
import javax.jms.TransactionRolledBackException;
import javax.jms.TransactionRolledBackRuntimeException;

public final class JMSExceptionSupport {
    public static JMSException create(String message, Throwable cause) {
        if (cause instanceof JMSException) {
            return (JMSException)cause;
        }
        if (cause.getCause() instanceof JMSException) {
            return (JMSException)cause.getCause();
        }
        if ((message == null || message.isEmpty()) && ((message = cause.getMessage()) == null || message.isEmpty())) {
            message = cause.toString();
        }
        JMSException exception = new JMSException(message);
        if (cause instanceof Exception) {
            exception.setLinkedException((Exception)cause);
        }
        exception.initCause(cause);
        return exception;
    }

    public static JMSException create(Throwable cause) {
        return JMSExceptionSupport.create(null, cause);
    }

    public static MessageEOFException createMessageEOFException(Throwable cause) {
        String message = cause.getMessage();
        if (message == null || message.length() == 0) {
            message = cause.toString();
        }
        MessageEOFException exception = new MessageEOFException(message);
        if (cause instanceof Exception) {
            exception.setLinkedException((Exception)cause);
        }
        exception.initCause(cause);
        return exception;
    }

    public static MessageFormatException createMessageFormatException(Throwable cause) {
        String message = cause.getMessage();
        if (message == null || message.length() == 0) {
            message = cause.toString();
        }
        MessageFormatException exception = new MessageFormatException(message);
        if (cause instanceof Exception) {
            exception.setLinkedException((Exception)cause);
        }
        exception.initCause(cause);
        return exception;
    }

    public static JMSRuntimeException createRuntimeException(Exception exception) {
        Object result = null;
        JMSException source = null;
        if (!(exception instanceof JMSException)) {
            throw new JMSRuntimeException(exception.getMessage(), null, (Throwable)exception);
        }
        source = (JMSException)((Object)exception);
        result = source instanceof IllegalStateException ? new IllegalStateRuntimeException(source.getMessage(), source.getErrorCode(), (Throwable)source) : (source instanceof InvalidClientIDException ? new InvalidClientIDRuntimeException(source.getMessage(), source.getErrorCode(), (Throwable)source) : (source instanceof InvalidDestinationException ? new InvalidDestinationRuntimeException(source.getMessage(), source.getErrorCode(), (Throwable)source) : (source instanceof InvalidSelectorException ? new InvalidSelectorRuntimeException(source.getMessage(), source.getErrorCode(), (Throwable)source) : (source instanceof JMSSecurityException ? new JMSSecurityRuntimeException(source.getMessage(), source.getErrorCode(), (Throwable)source) : (source instanceof MessageFormatException ? new MessageFormatRuntimeException(source.getMessage(), source.getErrorCode(), (Throwable)source) : (source instanceof MessageNotWriteableException ? new MessageNotWriteableRuntimeException(source.getMessage(), source.getErrorCode(), (Throwable)source) : (source instanceof ResourceAllocationException ? new ResourceAllocationRuntimeException(source.getMessage(), source.getErrorCode(), (Throwable)source) : (source instanceof TransactionInProgressException ? new TransactionInProgressRuntimeException(source.getMessage(), source.getErrorCode(), (Throwable)source) : (source instanceof TransactionRolledBackException ? new TransactionRolledBackRuntimeException(source.getMessage(), source.getErrorCode(), (Throwable)source) : new JMSRuntimeException(source.getMessage(), source.getErrorCode(), (Throwable)source))))))))));
        return result;
    }
}

