/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.indexer.analyzers;

import aQute.bnd.indexer.ResourceAnalyzer;
import aQute.bnd.osgi.Jar;
import aQute.bnd.osgi.Resource;
import aQute.bnd.osgi.resource.CapReqBuilder;
import aQute.bnd.osgi.resource.ResourceBuilder;
import java.util.Map;

public class BlueprintAnalyzer
implements ResourceAnalyzer {
    private static final String BUNDLE_BLUEPRINT_HEADER = "Bundle-Blueprint";

    public void analyzeResource(Jar resource, ResourceBuilder rb) throws Exception {
        boolean blueprintEnabled = false;
        String header = resource.getManifest().getMainAttributes().getValue(BUNDLE_BLUEPRINT_HEADER);
        if (header != null) {
            blueprintEnabled = true;
        } else {
            Map<String, Resource> children = resource.getDirectories().get("OSGI-INF/blueprint/");
            if (children != null) {
                for (String child : children.keySet()) {
                    if (!child.toLowerCase().endsWith(".xml")) continue;
                    blueprintEnabled = true;
                    break;
                }
            }
        }
        if (blueprintEnabled) {
            CapReqBuilder builder = new CapReqBuilder("osgi.extender");
            String filter = String.format("(&(%s=%s)(version>=1.0.0)(!(version>=2.0.0)))", "osgi.extender", "osgi.blueprint");
            builder.addDirective("filter", filter).addDirective("effective", "active");
            rb.addRequirement(builder);
        }
    }
}

