/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.tx.control.service.local.impl;

import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.aries.tx.control.service.common.impl.AbstractTransactionContextImpl;
import org.apache.aries.tx.control.service.common.impl.AbstractTransactionControlImpl;
import org.apache.aries.tx.control.service.local.impl.TransactionContextImpl;

public class TransactionControlImpl
extends AbstractTransactionControlImpl {
    private final UUID txControlId = UUID.randomUUID();
    private final AtomicLong txCounter = new AtomicLong();

    @Override
    protected AbstractTransactionContextImpl startTransaction(boolean readOnly) {
        return new TransactionContextImpl(new TxId(this.txControlId, this.txCounter.incrementAndGet()), readOnly);
    }

    private static class TxId {
        private final UUID controlId;
        private final long txId;

        public TxId(UUID controlId, long txId) {
            this.controlId = controlId;
            this.txId = txId;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.controlId.hashCode();
            result = 31 * result + (int)(this.txId ^ this.txId >>> 32);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TxId other = (TxId)obj;
            if (!this.controlId.equals(other.controlId)) {
                return false;
            }
            return this.txId == other.txId;
        }
    }
}

