/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management.mbean;

import java.util.Date;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.api.management.mbean.ManagedCounterMBean;
import org.apache.camel.management.mbean.Statistic;
import org.apache.camel.management.mbean.StatisticCounter;
import org.apache.camel.spi.ManagementStrategy;

@ManagedResource(description="Managed Counter")
public abstract class ManagedCounter
implements ManagedCounterMBean {
    protected Statistic exchangesTotal;
    protected Date startTimestamp;
    protected Date resetTimestamp;

    public void init(ManagementStrategy strategy) {
        Date now;
        this.exchangesTotal = new StatisticCounter();
        this.startTimestamp = now = new Date();
        this.resetTimestamp = now;
    }

    public void reset() {
        this.exchangesTotal.reset();
        this.resetTimestamp = new Date();
    }

    public Date getStartTimestamp() {
        return this.startTimestamp;
    }

    public Date getResetTimestamp() {
        return this.resetTimestamp;
    }

    public long getExchangesTotal() throws Exception {
        return this.exchangesTotal.getValue();
    }

    public void increment() {
        this.exchangesTotal.increment();
    }
}

