/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management.mbean;

import org.apache.camel.CamelContext;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.api.management.mbean.ManagedDelayerMBean;
import org.apache.camel.builder.ExpressionBuilder;
import org.apache.camel.management.mbean.ManagedProcessor;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.processor.Delayer;

@ManagedResource(description="Managed Delayer")
public class ManagedDelayer
extends ManagedProcessor
implements ManagedDelayerMBean {
    private final Delayer delayer;

    public ManagedDelayer(CamelContext context, Delayer delayer, ProcessorDefinition<?> definition) {
        super(context, (Processor)delayer, definition);
        this.delayer = delayer;
    }

    public Delayer getDelayer() {
        return this.delayer;
    }

    public Long getDelay() {
        return this.delayer.getDelayValue();
    }

    public void constantDelay(Integer millis) {
        Expression delay = ExpressionBuilder.constantExpression((Object)millis);
        this.delayer.setDelay(delay);
    }

    public int getDelayedCount() {
        return this.delayer.getDelayedCount();
    }

    public Boolean isAsyncDelayed() {
        return this.delayer.isAsyncDelayed();
    }

    public Boolean isCallerRunsWhenRejected() {
        return this.delayer.isCallerRunsWhenRejected();
    }
}

