/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jms;

import java.time.Duration;
import java.util.Map;
import javax.jms.ConnectionFactory;
import javax.jms.ExceptionListener;
import org.apache.camel.CamelContext;
import org.apache.camel.ExchangePattern;
import org.apache.camel.LoggingLevel;
import org.apache.camel.component.jms.ConsumerType;
import org.apache.camel.component.jms.DefaultTaskExecutorType;
import org.apache.camel.component.jms.JmsEndpoint;
import org.apache.camel.component.jms.JmsKeyFormatStrategy;
import org.apache.camel.component.jms.JmsMessageType;
import org.apache.camel.component.jms.MessageCreatedStrategy;
import org.apache.camel.component.jms.MessageListenerContainerFactory;
import org.apache.camel.component.jms.ReplyToType;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.spi.PropertyConfigurerGetter;
import org.apache.camel.support.component.PropertyConfigurerSupport;
import org.apache.camel.util.CaseInsensitiveMap;
import org.springframework.core.task.TaskExecutor;
import org.springframework.jms.support.converter.MessageConverter;
import org.springframework.jms.support.destination.DestinationResolver;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.util.ErrorHandler;

public class JmsEndpointConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer,
PropertyConfigurerGetter {
    private static final Map<String, Object> ALL_OPTIONS;

    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {
        JmsEndpoint target = (JmsEndpoint)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "acceptmessageswhilestopping": 
            case "acceptMessagesWhileStopping": {
                target.getConfiguration().setAcceptMessagesWhileStopping((Boolean)JmsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "acknowledgementmodename": 
            case "acknowledgementModeName": {
                target.getConfiguration().setAcknowledgementModeName((String)JmsEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "allowadditionalheaders": 
            case "allowAdditionalHeaders": {
                target.getConfiguration().setAllowAdditionalHeaders((String)JmsEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "allownullbody": 
            case "allowNullBody": {
                target.getConfiguration().setAllowNullBody((Boolean)JmsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "allowreplymanagerquickstop": 
            case "allowReplyManagerQuickStop": {
                target.getConfiguration().setAllowReplyManagerQuickStop((Boolean)JmsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "allowserializedheaders": 
            case "allowSerializedHeaders": {
                target.getConfiguration().setAllowSerializedHeaders((Boolean)JmsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "alwayscopymessage": 
            case "alwaysCopyMessage": {
                target.getConfiguration().setAlwaysCopyMessage((Boolean)JmsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "artemisstreamingenabled": 
            case "artemisStreamingEnabled": {
                target.getConfiguration().setArtemisStreamingEnabled((Boolean)JmsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "asyncconsumer": 
            case "asyncConsumer": {
                target.getConfiguration().setAsyncConsumer((Boolean)JmsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "asyncstartlistener": 
            case "asyncStartListener": {
                target.getConfiguration().setAsyncStartListener((Boolean)JmsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "asyncstoplistener": 
            case "asyncStopListener": {
                target.getConfiguration().setAsyncStopListener((Boolean)JmsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "autostartup": 
            case "autoStartup": {
                target.getConfiguration().setAutoStartup((Boolean)JmsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "basicpropertybinding": 
            case "basicPropertyBinding": {
                target.setBasicPropertyBinding((Boolean)JmsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "cachelevel": 
            case "cacheLevel": {
                target.getConfiguration().setCacheLevel((Integer)JmsEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "cachelevelname": 
            case "cacheLevelName": {
                target.getConfiguration().setCacheLevelName((String)JmsEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "clientid": 
            case "clientId": {
                target.getConfiguration().setClientId((String)JmsEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "concurrentconsumers": 
            case "concurrentConsumers": {
                target.getConfiguration().setConcurrentConsumers((Integer)JmsEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "connectionfactory": 
            case "connectionFactory": {
                target.getConfiguration().setConnectionFactory((ConnectionFactory)JmsEndpointConfigurer.property((CamelContext)camelContext, ConnectionFactory.class, (Object)value));
                return true;
            }
            case "consumertype": 
            case "consumerType": {
                target.getConfiguration().setConsumerType((ConsumerType)((Object)JmsEndpointConfigurer.property((CamelContext)camelContext, ConsumerType.class, (Object)value)));
                return true;
            }
            case "correlationproperty": 
            case "correlationProperty": {
                target.getConfiguration().setCorrelationProperty((String)JmsEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "defaulttaskexecutortype": 
            case "defaultTaskExecutorType": {
                target.getConfiguration().setDefaultTaskExecutorType((DefaultTaskExecutorType)((Object)JmsEndpointConfigurer.property((CamelContext)camelContext, DefaultTaskExecutorType.class, (Object)value)));
                return true;
            }
            case "deliverydelay": 
            case "deliveryDelay": {
                target.getConfiguration().setDeliveryDelay((Long)JmsEndpointConfigurer.property((CamelContext)camelContext, Long.TYPE, (Object)value));
                return true;
            }
            case "deliverymode": 
            case "deliveryMode": {
                target.getConfiguration().setDeliveryMode((Integer)JmsEndpointConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "deliverypersistent": 
            case "deliveryPersistent": {
                target.getConfiguration().setDeliveryPersistent((Boolean)JmsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "destinationresolver": 
            case "destinationResolver": {
                target.getConfiguration().setDestinationResolver((DestinationResolver)JmsEndpointConfigurer.property((CamelContext)camelContext, DestinationResolver.class, (Object)value));
                return true;
            }
            case "disablereplyto": 
            case "disableReplyTo": {
                target.getConfiguration().setDisableReplyTo((Boolean)JmsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "disabletimetolive": 
            case "disableTimeToLive": {
                target.getConfiguration().setDisableTimeToLive((Boolean)JmsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "durablesubscriptionname": 
            case "durableSubscriptionName": {
                target.getConfiguration().setDurableSubscriptionName((String)JmsEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "eagerloadingofproperties": 
            case "eagerLoadingOfProperties": {
                target.getConfiguration().setEagerLoadingOfProperties((Boolean)JmsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "eagerpoisonbody": 
            case "eagerPoisonBody": {
                target.getConfiguration().setEagerPoisonBody((String)JmsEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "errorhandler": 
            case "errorHandler": {
                target.getConfiguration().setErrorHandler((ErrorHandler)JmsEndpointConfigurer.property((CamelContext)camelContext, ErrorHandler.class, (Object)value));
                return true;
            }
            case "errorhandlerlogstacktrace": 
            case "errorHandlerLogStackTrace": {
                target.getConfiguration().setErrorHandlerLogStackTrace((Boolean)JmsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "errorhandlerlogginglevel": 
            case "errorHandlerLoggingLevel": {
                target.getConfiguration().setErrorHandlerLoggingLevel((LoggingLevel)JmsEndpointConfigurer.property((CamelContext)camelContext, LoggingLevel.class, (Object)value));
                return true;
            }
            case "exceptionhandler": 
            case "exceptionHandler": {
                target.setExceptionHandler((ExceptionHandler)JmsEndpointConfigurer.property((CamelContext)camelContext, ExceptionHandler.class, (Object)value));
                return true;
            }
            case "exceptionlistener": 
            case "exceptionListener": {
                target.getConfiguration().setExceptionListener((ExceptionListener)JmsEndpointConfigurer.property((CamelContext)camelContext, ExceptionListener.class, (Object)value));
                return true;
            }
            case "exchangepattern": 
            case "exchangePattern": {
                target.setExchangePattern((ExchangePattern)JmsEndpointConfigurer.property((CamelContext)camelContext, ExchangePattern.class, (Object)value));
                return true;
            }
            case "explicitqosenabled": 
            case "explicitQosEnabled": {
                target.getConfiguration().setExplicitQosEnabled((Boolean)JmsEndpointConfigurer.property((CamelContext)camelContext, Boolean.class, (Object)value));
                return true;
            }
            case "exposelistenersession": 
            case "exposeListenerSession": {
                target.getConfiguration().setExposeListenerSession((Boolean)JmsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "forcesendoriginalmessage": 
            case "forceSendOriginalMessage": {
                target.getConfiguration().setForceSendOriginalMessage((Boolean)JmsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "formatdateheaderstoiso8601": 
            case "formatDateHeadersToIso8601": {
                target.getConfiguration().setFormatDateHeadersToIso8601((Boolean)JmsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "headerfilterstrategy": 
            case "headerFilterStrategy": {
                target.setHeaderFilterStrategy((HeaderFilterStrategy)JmsEndpointConfigurer.property((CamelContext)camelContext, HeaderFilterStrategy.class, (Object)value));
                return true;
            }
            case "idleconsumerlimit": 
            case "idleConsumerLimit": {
                target.getConfiguration().setIdleConsumerLimit((Integer)JmsEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "idletaskexecutionlimit": 
            case "idleTaskExecutionLimit": {
                target.getConfiguration().setIdleTaskExecutionLimit((Integer)JmsEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "includealljmsxproperties": 
            case "includeAllJMSXProperties": {
                target.getConfiguration().setIncludeAllJMSXProperties((Boolean)JmsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "includesentjmsmessageid": 
            case "includeSentJMSMessageID": {
                target.getConfiguration().setIncludeSentJMSMessageID((Boolean)JmsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "jmskeyformatstrategy": 
            case "jmsKeyFormatStrategy": {
                target.getConfiguration().setJmsKeyFormatStrategy((JmsKeyFormatStrategy)JmsEndpointConfigurer.property((CamelContext)camelContext, JmsKeyFormatStrategy.class, (Object)value));
                return true;
            }
            case "jmsmessagetype": 
            case "jmsMessageType": {
                target.getConfiguration().setJmsMessageType((JmsMessageType)((Object)JmsEndpointConfigurer.property((CamelContext)camelContext, JmsMessageType.class, (Object)value)));
                return true;
            }
            case "lazycreatetransactionmanager": 
            case "lazyCreateTransactionManager": {
                target.getConfiguration().setLazyCreateTransactionManager((Boolean)JmsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                target.setLazyStartProducer((Boolean)JmsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "mapjmsmessage": 
            case "mapJmsMessage": {
                target.getConfiguration().setMapJmsMessage((Boolean)JmsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "maxconcurrentconsumers": 
            case "maxConcurrentConsumers": {
                target.getConfiguration().setMaxConcurrentConsumers((Integer)JmsEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "maxmessagespertask": 
            case "maxMessagesPerTask": {
                target.getConfiguration().setMaxMessagesPerTask((Integer)JmsEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "messageconverter": 
            case "messageConverter": {
                target.getConfiguration().setMessageConverter((MessageConverter)JmsEndpointConfigurer.property((CamelContext)camelContext, MessageConverter.class, (Object)value));
                return true;
            }
            case "messagecreatedstrategy": 
            case "messageCreatedStrategy": {
                target.getConfiguration().setMessageCreatedStrategy((MessageCreatedStrategy)JmsEndpointConfigurer.property((CamelContext)camelContext, MessageCreatedStrategy.class, (Object)value));
                return true;
            }
            case "messageidenabled": 
            case "messageIdEnabled": {
                target.getConfiguration().setMessageIdEnabled((Boolean)JmsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "messagelistenercontainerfactory": 
            case "messageListenerContainerFactory": {
                target.getConfiguration().setMessageListenerContainerFactory((MessageListenerContainerFactory)JmsEndpointConfigurer.property((CamelContext)camelContext, MessageListenerContainerFactory.class, (Object)value));
                return true;
            }
            case "messagetimestampenabled": 
            case "messageTimestampEnabled": {
                target.getConfiguration().setMessageTimestampEnabled((Boolean)JmsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "password": {
                target.getConfiguration().setPassword((String)JmsEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "preservemessageqos": 
            case "preserveMessageQos": {
                target.getConfiguration().setPreserveMessageQos((Boolean)JmsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "priority": {
                target.getConfiguration().setPriority((Integer)JmsEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "pubsubnolocal": 
            case "pubSubNoLocal": {
                target.getConfiguration().setPubSubNoLocal((Boolean)JmsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "receivetimeout": 
            case "receiveTimeout": {
                target.getConfiguration().setReceiveTimeout(((Duration)JmsEndpointConfigurer.property((CamelContext)camelContext, Duration.class, (Object)value)).toMillis());
                return true;
            }
            case "recoveryinterval": 
            case "recoveryInterval": {
                target.getConfiguration().setRecoveryInterval(((Duration)JmsEndpointConfigurer.property((CamelContext)camelContext, Duration.class, (Object)value)).toMillis());
                return true;
            }
            case "replyto": 
            case "replyTo": {
                target.getConfiguration().setReplyTo((String)JmsEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "replytocachelevelname": 
            case "replyToCacheLevelName": {
                target.getConfiguration().setReplyToCacheLevelName((String)JmsEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "replytoconcurrentconsumers": 
            case "replyToConcurrentConsumers": {
                target.getConfiguration().setReplyToConcurrentConsumers((Integer)JmsEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "replytodeliverypersistent": 
            case "replyToDeliveryPersistent": {
                target.getConfiguration().setReplyToDeliveryPersistent((Boolean)JmsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "replytodestinationselectorname": 
            case "replyToDestinationSelectorName": {
                target.getConfiguration().setReplyToDestinationSelectorName((String)JmsEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "replytomaxconcurrentconsumers": 
            case "replyToMaxConcurrentConsumers": {
                target.getConfiguration().setReplyToMaxConcurrentConsumers((Integer)JmsEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "replytoontimeoutmaxconcurrentconsumers": 
            case "replyToOnTimeoutMaxConcurrentConsumers": {
                target.getConfiguration().setReplyToOnTimeoutMaxConcurrentConsumers((Integer)JmsEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "replytooverride": 
            case "replyToOverride": {
                target.getConfiguration().setReplyToOverride((String)JmsEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "replytosamedestinationallowed": 
            case "replyToSameDestinationAllowed": {
                target.getConfiguration().setReplyToSameDestinationAllowed((Boolean)JmsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "replytotype": 
            case "replyToType": {
                target.getConfiguration().setReplyToType((ReplyToType)((Object)JmsEndpointConfigurer.property((CamelContext)camelContext, ReplyToType.class, (Object)value)));
                return true;
            }
            case "requesttimeout": 
            case "requestTimeout": {
                target.getConfiguration().setRequestTimeout(((Duration)JmsEndpointConfigurer.property((CamelContext)camelContext, Duration.class, (Object)value)).toMillis());
                return true;
            }
            case "requesttimeoutcheckerinterval": 
            case "requestTimeoutCheckerInterval": {
                target.getConfiguration().setRequestTimeoutCheckerInterval(((Duration)JmsEndpointConfigurer.property((CamelContext)camelContext, Duration.class, (Object)value)).toMillis());
                return true;
            }
            case "selector": {
                target.getConfiguration().setSelector((String)JmsEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "streammessagetypeenabled": 
            case "streamMessageTypeEnabled": {
                target.getConfiguration().setStreamMessageTypeEnabled((Boolean)JmsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "subscriptiondurable": 
            case "subscriptionDurable": {
                target.getConfiguration().setSubscriptionDurable((Boolean)JmsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "subscriptionname": 
            case "subscriptionName": {
                target.getConfiguration().setSubscriptionName((String)JmsEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "subscriptionshared": 
            case "subscriptionShared": {
                target.getConfiguration().setSubscriptionShared((Boolean)JmsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "synchronous": {
                target.setSynchronous((Boolean)JmsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "taskexecutor": 
            case "taskExecutor": {
                target.getConfiguration().setTaskExecutor((TaskExecutor)JmsEndpointConfigurer.property((CamelContext)camelContext, TaskExecutor.class, (Object)value));
                return true;
            }
            case "testconnectiononstartup": 
            case "testConnectionOnStartup": {
                target.getConfiguration().setTestConnectionOnStartup((Boolean)JmsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "timetolive": 
            case "timeToLive": {
                target.getConfiguration().setTimeToLive((Long)JmsEndpointConfigurer.property((CamelContext)camelContext, Long.TYPE, (Object)value));
                return true;
            }
            case "transacted": {
                target.getConfiguration().setTransacted((Boolean)JmsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "transactedinout": 
            case "transactedInOut": {
                target.getConfiguration().setTransactedInOut((Boolean)JmsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "transactionmanager": 
            case "transactionManager": {
                target.getConfiguration().setTransactionManager((PlatformTransactionManager)JmsEndpointConfigurer.property((CamelContext)camelContext, PlatformTransactionManager.class, (Object)value));
                return true;
            }
            case "transactionname": 
            case "transactionName": {
                target.getConfiguration().setTransactionName((String)JmsEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "transactiontimeout": 
            case "transactionTimeout": {
                target.getConfiguration().setTransactionTimeout((Integer)JmsEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "transferexception": 
            case "transferException": {
                target.getConfiguration().setTransferException((Boolean)JmsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "transferexchange": 
            case "transferExchange": {
                target.getConfiguration().setTransferExchange((Boolean)JmsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "usemessageidascorrelationid": 
            case "useMessageIDAsCorrelationID": {
                target.getConfiguration().setUseMessageIDAsCorrelationID((Boolean)JmsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "username": {
                target.getConfiguration().setUsername((String)JmsEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "waitforprovisioncorrelationtobeupdatedcounter": 
            case "waitForProvisionCorrelationToBeUpdatedCounter": {
                target.getConfiguration().setWaitForProvisionCorrelationToBeUpdatedCounter((Integer)JmsEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "waitforprovisioncorrelationtobeupdatedthreadsleepingtime": 
            case "waitForProvisionCorrelationToBeUpdatedThreadSleepingTime": {
                target.getConfiguration().setWaitForProvisionCorrelationToBeUpdatedThreadSleepingTime(((Duration)JmsEndpointConfigurer.property((CamelContext)camelContext, Duration.class, (Object)value)).toMillis());
                return true;
            }
        }
        return false;
    }

    public Map<String, Object> getAllOptions(Object target) {
        return ALL_OPTIONS;
    }

    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {
        JmsEndpoint target = (JmsEndpoint)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "acceptmessageswhilestopping": 
            case "acceptMessagesWhileStopping": {
                return target.getConfiguration().isAcceptMessagesWhileStopping();
            }
            case "acknowledgementmodename": 
            case "acknowledgementModeName": {
                return target.getConfiguration().getAcknowledgementModeName();
            }
            case "allowadditionalheaders": 
            case "allowAdditionalHeaders": {
                return target.getConfiguration().getAllowAdditionalHeaders();
            }
            case "allownullbody": 
            case "allowNullBody": {
                return target.getConfiguration().isAllowNullBody();
            }
            case "allowreplymanagerquickstop": 
            case "allowReplyManagerQuickStop": {
                return target.getConfiguration().isAllowReplyManagerQuickStop();
            }
            case "allowserializedheaders": 
            case "allowSerializedHeaders": {
                return target.getConfiguration().isAllowSerializedHeaders();
            }
            case "alwayscopymessage": 
            case "alwaysCopyMessage": {
                return target.getConfiguration().isAlwaysCopyMessage();
            }
            case "artemisstreamingenabled": 
            case "artemisStreamingEnabled": {
                return target.getConfiguration().isArtemisStreamingEnabled();
            }
            case "asyncconsumer": 
            case "asyncConsumer": {
                return target.getConfiguration().isAsyncConsumer();
            }
            case "asyncstartlistener": 
            case "asyncStartListener": {
                return target.getConfiguration().isAsyncStartListener();
            }
            case "asyncstoplistener": 
            case "asyncStopListener": {
                return target.getConfiguration().isAsyncStopListener();
            }
            case "autostartup": 
            case "autoStartup": {
                return target.getConfiguration().isAutoStartup();
            }
            case "basicpropertybinding": 
            case "basicPropertyBinding": {
                return target.isBasicPropertyBinding();
            }
            case "cachelevel": 
            case "cacheLevel": {
                return target.getConfiguration().getCacheLevel();
            }
            case "cachelevelname": 
            case "cacheLevelName": {
                return target.getConfiguration().getCacheLevelName();
            }
            case "clientid": 
            case "clientId": {
                return target.getConfiguration().getClientId();
            }
            case "concurrentconsumers": 
            case "concurrentConsumers": {
                return target.getConfiguration().getConcurrentConsumers();
            }
            case "connectionfactory": 
            case "connectionFactory": {
                return target.getConfiguration().getConnectionFactory();
            }
            case "consumertype": 
            case "consumerType": {
                return target.getConfiguration().getConsumerType();
            }
            case "correlationproperty": 
            case "correlationProperty": {
                return target.getConfiguration().getCorrelationProperty();
            }
            case "defaulttaskexecutortype": 
            case "defaultTaskExecutorType": {
                return target.getConfiguration().getDefaultTaskExecutorType();
            }
            case "deliverydelay": 
            case "deliveryDelay": {
                return target.getConfiguration().getDeliveryDelay();
            }
            case "deliverymode": 
            case "deliveryMode": {
                return target.getConfiguration().getDeliveryMode();
            }
            case "deliverypersistent": 
            case "deliveryPersistent": {
                return target.getConfiguration().isDeliveryPersistent();
            }
            case "destinationresolver": 
            case "destinationResolver": {
                return target.getConfiguration().getDestinationResolver();
            }
            case "disablereplyto": 
            case "disableReplyTo": {
                return target.getConfiguration().isDisableReplyTo();
            }
            case "disabletimetolive": 
            case "disableTimeToLive": {
                return target.getConfiguration().isDisableTimeToLive();
            }
            case "durablesubscriptionname": 
            case "durableSubscriptionName": {
                return target.getConfiguration().getDurableSubscriptionName();
            }
            case "eagerloadingofproperties": 
            case "eagerLoadingOfProperties": {
                return target.getConfiguration().isEagerLoadingOfProperties();
            }
            case "eagerpoisonbody": 
            case "eagerPoisonBody": {
                return target.getConfiguration().getEagerPoisonBody();
            }
            case "errorhandler": 
            case "errorHandler": {
                return target.getConfiguration().getErrorHandler();
            }
            case "errorhandlerlogstacktrace": 
            case "errorHandlerLogStackTrace": {
                return target.getConfiguration().isErrorHandlerLogStackTrace();
            }
            case "errorhandlerlogginglevel": 
            case "errorHandlerLoggingLevel": {
                return target.getConfiguration().getErrorHandlerLoggingLevel();
            }
            case "exceptionhandler": 
            case "exceptionHandler": {
                return target.getExceptionHandler();
            }
            case "exceptionlistener": 
            case "exceptionListener": {
                return target.getConfiguration().getExceptionListener();
            }
            case "exchangepattern": 
            case "exchangePattern": {
                return target.getExchangePattern();
            }
            case "explicitqosenabled": 
            case "explicitQosEnabled": {
                return target.getConfiguration().getExplicitQosEnabled();
            }
            case "exposelistenersession": 
            case "exposeListenerSession": {
                return target.getConfiguration().isExposeListenerSession();
            }
            case "forcesendoriginalmessage": 
            case "forceSendOriginalMessage": {
                return target.getConfiguration().isForceSendOriginalMessage();
            }
            case "formatdateheaderstoiso8601": 
            case "formatDateHeadersToIso8601": {
                return target.getConfiguration().isFormatDateHeadersToIso8601();
            }
            case "headerfilterstrategy": 
            case "headerFilterStrategy": {
                return target.getHeaderFilterStrategy();
            }
            case "idleconsumerlimit": 
            case "idleConsumerLimit": {
                return target.getConfiguration().getIdleConsumerLimit();
            }
            case "idletaskexecutionlimit": 
            case "idleTaskExecutionLimit": {
                return target.getConfiguration().getIdleTaskExecutionLimit();
            }
            case "includealljmsxproperties": 
            case "includeAllJMSXProperties": {
                return target.getConfiguration().isIncludeAllJMSXProperties();
            }
            case "includesentjmsmessageid": 
            case "includeSentJMSMessageID": {
                return target.getConfiguration().isIncludeSentJMSMessageID();
            }
            case "jmskeyformatstrategy": 
            case "jmsKeyFormatStrategy": {
                return target.getConfiguration().getJmsKeyFormatStrategy();
            }
            case "jmsmessagetype": 
            case "jmsMessageType": {
                return target.getConfiguration().getJmsMessageType();
            }
            case "lazycreatetransactionmanager": 
            case "lazyCreateTransactionManager": {
                return target.getConfiguration().isLazyCreateTransactionManager();
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return target.isLazyStartProducer();
            }
            case "mapjmsmessage": 
            case "mapJmsMessage": {
                return target.getConfiguration().isMapJmsMessage();
            }
            case "maxconcurrentconsumers": 
            case "maxConcurrentConsumers": {
                return target.getConfiguration().getMaxConcurrentConsumers();
            }
            case "maxmessagespertask": 
            case "maxMessagesPerTask": {
                return target.getConfiguration().getMaxMessagesPerTask();
            }
            case "messageconverter": 
            case "messageConverter": {
                return target.getConfiguration().getMessageConverter();
            }
            case "messagecreatedstrategy": 
            case "messageCreatedStrategy": {
                return target.getConfiguration().getMessageCreatedStrategy();
            }
            case "messageidenabled": 
            case "messageIdEnabled": {
                return target.getConfiguration().isMessageIdEnabled();
            }
            case "messagelistenercontainerfactory": 
            case "messageListenerContainerFactory": {
                return target.getConfiguration().getMessageListenerContainerFactory();
            }
            case "messagetimestampenabled": 
            case "messageTimestampEnabled": {
                return target.getConfiguration().isMessageTimestampEnabled();
            }
            case "password": {
                return target.getConfiguration().getPassword();
            }
            case "preservemessageqos": 
            case "preserveMessageQos": {
                return target.getConfiguration().isPreserveMessageQos();
            }
            case "priority": {
                return target.getConfiguration().getPriority();
            }
            case "pubsubnolocal": 
            case "pubSubNoLocal": {
                return target.getConfiguration().isPubSubNoLocal();
            }
            case "receivetimeout": 
            case "receiveTimeout": {
                return target.getConfiguration().getReceiveTimeout();
            }
            case "recoveryinterval": 
            case "recoveryInterval": {
                return target.getConfiguration().getRecoveryInterval();
            }
            case "replyto": 
            case "replyTo": {
                return target.getConfiguration().getReplyTo();
            }
            case "replytocachelevelname": 
            case "replyToCacheLevelName": {
                return target.getConfiguration().getReplyToCacheLevelName();
            }
            case "replytoconcurrentconsumers": 
            case "replyToConcurrentConsumers": {
                return target.getConfiguration().getReplyToConcurrentConsumers();
            }
            case "replytodeliverypersistent": 
            case "replyToDeliveryPersistent": {
                return target.getConfiguration().isReplyToDeliveryPersistent();
            }
            case "replytodestinationselectorname": 
            case "replyToDestinationSelectorName": {
                return target.getConfiguration().getReplyToDestinationSelectorName();
            }
            case "replytomaxconcurrentconsumers": 
            case "replyToMaxConcurrentConsumers": {
                return target.getConfiguration().getReplyToMaxConcurrentConsumers();
            }
            case "replytoontimeoutmaxconcurrentconsumers": 
            case "replyToOnTimeoutMaxConcurrentConsumers": {
                return target.getConfiguration().getReplyToOnTimeoutMaxConcurrentConsumers();
            }
            case "replytooverride": 
            case "replyToOverride": {
                return target.getConfiguration().getReplyToOverride();
            }
            case "replytosamedestinationallowed": 
            case "replyToSameDestinationAllowed": {
                return target.getConfiguration().isReplyToSameDestinationAllowed();
            }
            case "replytotype": 
            case "replyToType": {
                return target.getConfiguration().getReplyToType();
            }
            case "requesttimeout": 
            case "requestTimeout": {
                return target.getConfiguration().getRequestTimeout();
            }
            case "requesttimeoutcheckerinterval": 
            case "requestTimeoutCheckerInterval": {
                return target.getConfiguration().getRequestTimeoutCheckerInterval();
            }
            case "selector": {
                return target.getConfiguration().getSelector();
            }
            case "streammessagetypeenabled": 
            case "streamMessageTypeEnabled": {
                return target.getConfiguration().isStreamMessageTypeEnabled();
            }
            case "subscriptiondurable": 
            case "subscriptionDurable": {
                return target.getConfiguration().isSubscriptionDurable();
            }
            case "subscriptionname": 
            case "subscriptionName": {
                return target.getConfiguration().getSubscriptionName();
            }
            case "subscriptionshared": 
            case "subscriptionShared": {
                return target.getConfiguration().isSubscriptionShared();
            }
            case "synchronous": {
                return target.isSynchronous();
            }
            case "taskexecutor": 
            case "taskExecutor": {
                return target.getConfiguration().getTaskExecutor();
            }
            case "testconnectiononstartup": 
            case "testConnectionOnStartup": {
                return target.getConfiguration().isTestConnectionOnStartup();
            }
            case "timetolive": 
            case "timeToLive": {
                return target.getConfiguration().getTimeToLive();
            }
            case "transacted": {
                return target.getConfiguration().isTransacted();
            }
            case "transactedinout": 
            case "transactedInOut": {
                return target.getConfiguration().isTransactedInOut();
            }
            case "transactionmanager": 
            case "transactionManager": {
                return target.getConfiguration().getTransactionManager();
            }
            case "transactionname": 
            case "transactionName": {
                return target.getConfiguration().getTransactionName();
            }
            case "transactiontimeout": 
            case "transactionTimeout": {
                return target.getConfiguration().getTransactionTimeout();
            }
            case "transferexception": 
            case "transferException": {
                return target.getConfiguration().isTransferException();
            }
            case "transferexchange": 
            case "transferExchange": {
                return target.getConfiguration().isTransferExchange();
            }
            case "usemessageidascorrelationid": 
            case "useMessageIDAsCorrelationID": {
                return target.getConfiguration().isUseMessageIDAsCorrelationID();
            }
            case "username": {
                return target.getConfiguration().getUsername();
            }
            case "waitforprovisioncorrelationtobeupdatedcounter": 
            case "waitForProvisionCorrelationToBeUpdatedCounter": {
                return target.getConfiguration().getWaitForProvisionCorrelationToBeUpdatedCounter();
            }
            case "waitforprovisioncorrelationtobeupdatedthreadsleepingtime": 
            case "waitForProvisionCorrelationToBeUpdatedThreadSleepingTime": {
                return target.getConfiguration().getWaitForProvisionCorrelationToBeUpdatedThreadSleepingTime();
            }
        }
        return null;
    }

    static {
        CaseInsensitiveMap map = new CaseInsensitiveMap();
        map.put("destinationType", String.class);
        map.put("destinationName", String.class);
        map.put("clientId", String.class);
        map.put("connectionFactory", ConnectionFactory.class);
        map.put("disableReplyTo", Boolean.TYPE);
        map.put("durableSubscriptionName", String.class);
        map.put("jmsMessageType", JmsMessageType.class);
        map.put("replyTo", String.class);
        map.put("testConnectionOnStartup", Boolean.TYPE);
        map.put("acknowledgementModeName", String.class);
        map.put("asyncConsumer", Boolean.TYPE);
        map.put("autoStartup", Boolean.TYPE);
        map.put("cacheLevel", Integer.TYPE);
        map.put("cacheLevelName", String.class);
        map.put("concurrentConsumers", Integer.TYPE);
        map.put("maxConcurrentConsumers", Integer.TYPE);
        map.put("replyToDeliveryPersistent", Boolean.TYPE);
        map.put("selector", String.class);
        map.put("subscriptionDurable", Boolean.TYPE);
        map.put("subscriptionName", String.class);
        map.put("subscriptionShared", Boolean.TYPE);
        map.put("acceptMessagesWhileStopping", Boolean.TYPE);
        map.put("allowReplyManagerQuickStop", Boolean.TYPE);
        map.put("consumerType", ConsumerType.class);
        map.put("defaultTaskExecutorType", DefaultTaskExecutorType.class);
        map.put("eagerLoadingOfProperties", Boolean.TYPE);
        map.put("eagerPoisonBody", String.class);
        map.put("exceptionHandler", ExceptionHandler.class);
        map.put("exchangePattern", ExchangePattern.class);
        map.put("exposeListenerSession", Boolean.TYPE);
        map.put("replyToSameDestinationAllowed", Boolean.TYPE);
        map.put("taskExecutor", TaskExecutor.class);
        map.put("deliveryDelay", Long.TYPE);
        map.put("deliveryMode", Integer.class);
        map.put("deliveryPersistent", Boolean.TYPE);
        map.put("explicitQosEnabled", Boolean.class);
        map.put("formatDateHeadersToIso8601", Boolean.TYPE);
        map.put("lazyStartProducer", Boolean.TYPE);
        map.put("preserveMessageQos", Boolean.TYPE);
        map.put("priority", Integer.TYPE);
        map.put("replyToConcurrentConsumers", Integer.TYPE);
        map.put("replyToMaxConcurrentConsumers", Integer.TYPE);
        map.put("replyToOnTimeoutMaxConcurrentConsumers", Integer.TYPE);
        map.put("replyToOverride", String.class);
        map.put("replyToType", ReplyToType.class);
        map.put("requestTimeout", Long.TYPE);
        map.put("timeToLive", Long.TYPE);
        map.put("allowAdditionalHeaders", String.class);
        map.put("allowNullBody", Boolean.TYPE);
        map.put("alwaysCopyMessage", Boolean.TYPE);
        map.put("correlationProperty", String.class);
        map.put("disableTimeToLive", Boolean.TYPE);
        map.put("forceSendOriginalMessage", Boolean.TYPE);
        map.put("includeSentJMSMessageID", Boolean.TYPE);
        map.put("replyToCacheLevelName", String.class);
        map.put("replyToDestinationSelectorName", String.class);
        map.put("streamMessageTypeEnabled", Boolean.TYPE);
        map.put("allowSerializedHeaders", Boolean.TYPE);
        map.put("artemisStreamingEnabled", Boolean.TYPE);
        map.put("asyncStartListener", Boolean.TYPE);
        map.put("asyncStopListener", Boolean.TYPE);
        map.put("basicPropertyBinding", Boolean.TYPE);
        map.put("destinationResolver", DestinationResolver.class);
        map.put("errorHandler", ErrorHandler.class);
        map.put("exceptionListener", ExceptionListener.class);
        map.put("headerFilterStrategy", HeaderFilterStrategy.class);
        map.put("idleConsumerLimit", Integer.TYPE);
        map.put("idleTaskExecutionLimit", Integer.TYPE);
        map.put("includeAllJMSXProperties", Boolean.TYPE);
        map.put("jmsKeyFormatStrategy", JmsKeyFormatStrategy.class);
        map.put("mapJmsMessage", Boolean.TYPE);
        map.put("maxMessagesPerTask", Integer.TYPE);
        map.put("messageConverter", MessageConverter.class);
        map.put("messageCreatedStrategy", MessageCreatedStrategy.class);
        map.put("messageIdEnabled", Boolean.TYPE);
        map.put("messageListenerContainerFactory", MessageListenerContainerFactory.class);
        map.put("messageTimestampEnabled", Boolean.TYPE);
        map.put("pubSubNoLocal", Boolean.TYPE);
        map.put("receiveTimeout", Long.TYPE);
        map.put("recoveryInterval", Long.TYPE);
        map.put("requestTimeoutCheckerInterval", Long.TYPE);
        map.put("synchronous", Boolean.TYPE);
        map.put("transferException", Boolean.TYPE);
        map.put("transferExchange", Boolean.TYPE);
        map.put("useMessageIDAsCorrelationID", Boolean.TYPE);
        map.put("waitForProvisionCorrelationToBeUpdatedCounter", Integer.TYPE);
        map.put("waitForProvisionCorrelationToBeUpdatedThreadSleepingTime", Long.TYPE);
        map.put("errorHandlerLoggingLevel", LoggingLevel.class);
        map.put("errorHandlerLogStackTrace", Boolean.TYPE);
        map.put("password", String.class);
        map.put("username", String.class);
        map.put("transacted", Boolean.TYPE);
        map.put("transactedInOut", Boolean.TYPE);
        map.put("lazyCreateTransactionManager", Boolean.TYPE);
        map.put("transactionManager", PlatformTransactionManager.class);
        map.put("transactionName", String.class);
        map.put("transactionTimeout", Integer.TYPE);
        ALL_OPTIONS = map;
    }
}

