/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support.jsse;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.camel.support.jsse.JsseParameters;

public class FilterParameters
extends JsseParameters {
    protected List<String> include;
    protected List<String> exclude;

    public List<String> getInclude() {
        if (this.include == null) {
            this.include = new ArrayList<String>();
        }
        return this.include;
    }

    public List<String> getExclude() {
        if (this.exclude == null) {
            this.exclude = new ArrayList<String>();
        }
        return this.exclude;
    }

    public List<Pattern> getIncludePatterns() {
        return this.getPattern(this.getInclude());
    }

    public List<Pattern> getExcludePatterns() {
        return this.getPattern(this.getExclude());
    }

    public Patterns getPatterns() {
        return new Patterns(this.getIncludePatterns(), this.getExcludePatterns());
    }

    protected List<Pattern> getPattern(List<String> patternStrings) {
        ArrayList<Pattern> patterns = new ArrayList<Pattern>(patternStrings.size());
        for (String expression : patternStrings) {
            patterns.add(Pattern.compile(this.parsePropertyValue(expression)));
        }
        return patterns;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("FilterParameters[include=");
        builder.append(Arrays.toString(this.getInclude().toArray(new String[this.getInclude().size()])));
        builder.append(", exclude=");
        builder.append(Arrays.toString(this.getExclude().toArray(new String[this.getExclude().size()])));
        builder.append("]");
        return builder.toString();
    }

    public static class Patterns {
        private final List<Pattern> includes;
        private final List<Pattern> excludes;

        public Patterns(List<Pattern> includes, List<Pattern> excludes) {
            this.includes = Collections.unmodifiableList(new ArrayList<Pattern>(includes));
            this.excludes = Collections.unmodifiableList(new ArrayList<Pattern>(excludes));
        }

        public List<Pattern> getIncludes() {
            return this.includes;
        }

        public List<Pattern> getExcludes() {
            return this.excludes;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Patterns [includes=");
            builder.append(this.includes);
            builder.append(", excludes=");
            builder.append(this.excludes);
            builder.append("]");
            return builder.toString();
        }
    }
}

