/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.logging.spi.support;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.logging.Level;
import org.ops4j.pax.logging.EventAdminPoster;
import org.ops4j.pax.logging.spi.support.ConfigurationNotifier;
import org.ops4j.pax.logging.spi.support.EventAdminConfigurationNotifier;
import org.ops4j.pax.logging.spi.support.EventAdminTracker;
import org.ops4j.pax.logging.spi.support.FallbackLogFactory;
import org.ops4j.pax.logging.spi.support.LogReaderServiceImpl;
import org.ops4j.pax.logging.spi.support.OsgiUtil;
import org.ops4j.pax.logging.spi.support.RegisteredService;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.log.LogLevel;
import org.osgi.service.log.LogReaderService;

public class BackendSupport {
    private BackendSupport() {
    }

    public static int paxLoggingServiceRanking(BundleContext context) {
        int ranking = 1;
        String rankingProperty = context.getProperty("org.ops4j.pax.logging.ranking");
        if (rankingProperty != null) {
            ranking = Integer.parseInt(rankingProperty);
        }
        return ranking;
    }

    public static RegisteredService<LogReaderService, LogReaderServiceImpl> createAndRegisterLogReaderService(BundleContext context) {
        String enabled = OsgiUtil.systemOrContextProperty(context, "org.ops4j.pax.logging.logReaderEnabled");
        if ("false".equalsIgnoreCase(enabled)) {
            return new RegisteredService(null, null);
        }
        LogReaderServiceImpl logReader = new LogReaderServiceImpl(100, FallbackLogFactory.createFallbackLog(context.getBundle(), "pax-logging"));
        Hashtable<String, Integer> serviceProperties = new Hashtable<String, Integer>();
        ((Dictionary)serviceProperties).put("service.ranking", BackendSupport.paxLoggingServiceRanking(context));
        ServiceRegistration registration = context.registerService(LogReaderService.class, (Object)logReader, serviceProperties);
        return new RegisteredService<LogReaderService, LogReaderServiceImpl>(logReader, registration);
    }

    public static RegisteredService<EventAdminPoster, EventAdminPoster> eventAdminSupport(BundleContext context) {
        String enabled = OsgiUtil.systemOrContextProperty(context, "org.ops4j.pax.logging.eventAdminEnabled");
        if ("false".equalsIgnoreCase(enabled)) {
            return new RegisteredService(null, null);
        }
        EventAdminTracker eventAdmin = null;
        try {
            eventAdmin = new EventAdminTracker(context);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        return new RegisteredService<EventAdminPoster, EventAdminPoster>(eventAdmin, null);
    }

    public static RegisteredService<ConfigurationNotifier, ConfigurationNotifier> eventAdminConfigurationNotifier(BundleContext context) {
        ConfigurationNotifier notifier = new ConfigurationNotifier(){

            @Override
            public void configurationDone() {
            }

            @Override
            public void configurationError(Throwable t) {
            }

            @Override
            public void close() {
            }
        };
        String enabled = OsgiUtil.systemOrContextProperty(context, "org.ops4j.pax.logging.eventAdminEnabled");
        if ("false".equalsIgnoreCase(enabled)) {
            return new RegisteredService<ConfigurationNotifier, ConfigurationNotifier>(notifier, null);
        }
        try {
            notifier = new EventAdminConfigurationNotifier(context);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        return new RegisteredService<ConfigurationNotifier, ConfigurationNotifier>(notifier, null);
    }

    public static String defaultLogLevel(BundleContext bundleContext) {
        String level = OsgiUtil.systemOrContextProperty(bundleContext, "org.ops4j.pax.logging.DefaultServiceLog.level");
        if (level == null || "".equals(level.trim())) {
            return "DEBUG";
        }
        return level;
    }

    public static LogLevel convertR7LogLevel(String levelName, LogLevel defaultLevel) {
        if ("ALL".equalsIgnoreCase(levelName) || "AUDIT".equalsIgnoreCase(levelName)) {
            return LogLevel.AUDIT;
        }
        if ("TRACE".equalsIgnoreCase(levelName) || "FINER".equalsIgnoreCase(levelName) || "FINEST".equalsIgnoreCase(levelName)) {
            return LogLevel.TRACE;
        }
        if ("DEBUG".equalsIgnoreCase(levelName)) {
            return LogLevel.DEBUG;
        }
        if ("INFO".equalsIgnoreCase(levelName)) {
            return LogLevel.INFO;
        }
        if ("ERROR".equalsIgnoreCase(levelName) || "SEVERE".equalsIgnoreCase(levelName) || "FATAL".equalsIgnoreCase(levelName)) {
            return LogLevel.ERROR;
        }
        if ("WARN".equalsIgnoreCase(levelName)) {
            return LogLevel.WARN;
        }
        if ("DISABLED".equalsIgnoreCase(levelName) || "OFF".equalsIgnoreCase(levelName) || "NONE".equalsIgnoreCase(levelName)) {
            return null;
        }
        return defaultLevel;
    }

    public static Level toJULLevel(String levelName) {
        if (levelName == null || levelName.equalsIgnoreCase("OFF")) {
            return Level.OFF;
        }
        if (levelName.equalsIgnoreCase("FATAL") || levelName.equalsIgnoreCase("SEVERE") || levelName.equalsIgnoreCase("ERROR")) {
            return Level.SEVERE;
        }
        if (levelName.equalsIgnoreCase("WARN") || levelName.equalsIgnoreCase("WARNING")) {
            return Level.WARNING;
        }
        if (levelName.equalsIgnoreCase("INFO") || levelName.equalsIgnoreCase("CONFIG") || levelName.equalsIgnoreCase("CONF")) {
            return Level.INFO;
        }
        if (levelName.equalsIgnoreCase("DEBUG") || levelName.equalsIgnoreCase("FINE")) {
            return Level.FINE;
        }
        if (levelName.equalsIgnoreCase("TRACE") || levelName.equalsIgnoreCase("FINER")) {
            return Level.FINER;
        }
        if (levelName.equalsIgnoreCase("FINEST")) {
            return Level.FINEST;
        }
        if (levelName.equalsIgnoreCase("ALL")) {
            return Level.ALL;
        }
        return Level.INFO;
    }

    public static String category(Bundle bundle) {
        Object category = "undefined";
        if (bundle != null && (category = bundle.getSymbolicName()) == null) {
            category = "bundle@" + bundle.getBundleId();
        }
        return category;
    }

    public static boolean isConfigurationAdminAvailable() {
        try {
            BackendSupport.class.getClassLoader().loadClass("org.osgi.service.cm.ConfigurationAdmin");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static String externalFile(BundleContext bundleContext, String defaultFile) {
        String property = OsgiUtil.systemOrContextProperty(bundleContext, "org.ops4j.pax.logging.property.file");
        return property == null ? defaultFile : property;
    }
}

