/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import org.apache.camel.AsyncCallback;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.NoSuchBeanException;
import org.apache.camel.component.bean.BeanEndpoint;
import org.apache.camel.component.bean.BeanProcessor;
import org.apache.camel.component.bean.ConstantBeanHolder;
import org.apache.camel.support.DefaultAsyncProducer;
import org.apache.camel.support.service.ServiceHelper;

public class BeanProducer
extends DefaultAsyncProducer {
    private final BeanProcessor processor;
    private boolean beanStarted;

    public BeanProducer(BeanEndpoint endpoint, BeanProcessor processor) {
        super((Endpoint)endpoint);
        this.processor = processor;
        this.beanStarted = false;
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        return this.processor.process(exchange, callback);
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this.processor.getBeanHolder() instanceof ConstantBeanHolder) {
            try {
                ServiceHelper.startService((Object)this.processor.getBean());
                this.beanStarted = true;
            }
            catch (NoSuchBeanException noSuchBeanException) {
                // empty catch block
            }
        }
    }

    protected void doStop() throws Exception {
        if (this.beanStarted) {
            try {
                ServiceHelper.stopService((Object)this.processor.getBean());
                this.beanStarted = false;
            }
            catch (NoSuchBeanException noSuchBeanException) {
                // empty catch block
            }
        }
        super.doStop();
    }
}

