/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import org.apache.camel.CamelContext;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.LoggingLevel;
import org.apache.camel.NonManagedService;
import org.apache.camel.Route;
import org.apache.camel.ServiceStatus;
import org.apache.camel.impl.engine.DefaultSupervisingRouteController;
import org.apache.camel.spi.RouteController;
import org.apache.camel.spi.SupervisingRouteController;
import org.apache.camel.support.service.ServiceSupport;

public class DefaultRouteController
extends ServiceSupport
implements RouteController,
NonManagedService {
    private CamelContext camelContext;
    private LoggingLevel routeStartupLoggingLevel = LoggingLevel.INFO;

    public DefaultRouteController() {
        this(null);
    }

    public DefaultRouteController(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public LoggingLevel getRouteStartupLoggingLevel() {
        return this.routeStartupLoggingLevel;
    }

    public void setRouteStartupLoggingLevel(LoggingLevel routeStartupLoggingLevel) {
        this.routeStartupLoggingLevel = routeStartupLoggingLevel;
    }

    protected RouteController getInternalRouteController() {
        return ((ExtendedCamelContext)this.camelContext.adapt(ExtendedCamelContext.class)).getInternalRouteController();
    }

    public void startAllRoutes() throws Exception {
        this.getInternalRouteController().startAllRoutes();
    }

    public boolean isStartingRoutes() {
        return this.getInternalRouteController().isStartingRoutes();
    }

    public ServiceStatus getRouteStatus(String routeId) {
        return this.getInternalRouteController().getRouteStatus(routeId);
    }

    public void startRoute(String routeId) throws Exception {
        this.getInternalRouteController().startRoute(routeId);
    }

    public void stopRoute(String routeId) throws Exception {
        this.getInternalRouteController().stopRoute(routeId);
    }

    public void stopRoute(String routeId, long timeout, TimeUnit timeUnit) throws Exception {
        this.getInternalRouteController().stopRoute(routeId, timeout, timeUnit);
    }

    public boolean stopRoute(String routeId, long timeout, TimeUnit timeUnit, boolean abortAfterTimeout) throws Exception {
        return this.getInternalRouteController().stopRoute(routeId, timeout, timeUnit, abortAfterTimeout);
    }

    public void suspendRoute(String routeId) throws Exception {
        this.getInternalRouteController().suspendRoute(routeId);
    }

    public void suspendRoute(String routeId, long timeout, TimeUnit timeUnit) throws Exception {
        this.getInternalRouteController().suspendRoute(routeId, timeout, timeUnit);
    }

    public void resumeRoute(String routeId) throws Exception {
        this.getInternalRouteController().resumeRoute(routeId);
    }

    public <T extends RouteController> T adapt(Class<T> type) {
        return (T)((RouteController)type.cast((Object)this));
    }

    public SupervisingRouteController supervising() {
        if (this instanceof SupervisingRouteController) {
            return (SupervisingRouteController)this;
        }
        DefaultSupervisingRouteController src = new DefaultSupervisingRouteController();
        src.setCamelContext(this.camelContext);
        this.camelContext.setRouteController((RouteController)src);
        return src;
    }

    public Collection<Route> getControlledRoutes() {
        return Collections.emptyList();
    }
}

