/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.session;

import com.codahale.metrics.MetricRegistry;
import com.google.common.annotations.VisibleForTesting;
import java.io.Serializable;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.apache.kyuubi.KyuubiSQLException$;
import org.apache.kyuubi.client.api.v1.dto.Batch;
import org.apache.kyuubi.client.api.v1.dto.BatchRequest;
import org.apache.kyuubi.client.util.BatchUtils;
import org.apache.kyuubi.config.ConfigEntry;
import org.apache.kyuubi.config.KyuubiConf;
import org.apache.kyuubi.config.KyuubiConf$;
import org.apache.kyuubi.credentials.HadoopCredentialsManager;
import org.apache.kyuubi.engine.KyuubiApplicationManager;
import org.apache.kyuubi.metrics.MetricsConstants$;
import org.apache.kyuubi.metrics.MetricsSystem;
import org.apache.kyuubi.metrics.MetricsSystem$;
import org.apache.kyuubi.operation.KyuubiOperationManager;
import org.apache.kyuubi.operation.OperationState$;
import org.apache.kyuubi.plugin.GroupProvider;
import org.apache.kyuubi.plugin.PluginLoader$;
import org.apache.kyuubi.plugin.SessionConfAdvisor;
import org.apache.kyuubi.server.metadata.MetadataManager;
import org.apache.kyuubi.server.metadata.MetadataRequestsRetryRef;
import org.apache.kyuubi.server.metadata.api.Metadata;
import org.apache.kyuubi.server.metadata.api.Metadata$;
import org.apache.kyuubi.server.metadata.api.MetadataFilter;
import org.apache.kyuubi.service.Service;
import org.apache.kyuubi.service.TempFileService;
import org.apache.kyuubi.session.KyuubiBatchSession;
import org.apache.kyuubi.session.KyuubiSessionImpl;
import org.apache.kyuubi.session.Session;
import org.apache.kyuubi.session.SessionHandle;
import org.apache.kyuubi.session.SessionLimiter;
import org.apache.kyuubi.session.SessionLimiter$;
import org.apache.kyuubi.session.SessionManager;
import org.apache.kyuubi.session.SessionType$;
import org.apache.kyuubi.session.UserIpAddress;
import org.apache.kyuubi.shaded.hive.service.rpc.thrift.TProtocolVersion;
import org.apache.kyuubi.sql.parser.server.KyuubiParser;
import org.apache.kyuubi.util.SignUtils$;
import org.apache.kyuubi.util.ThreadUtils$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\r}g\u0001B\"E\u00015C\u0001B\u0015\u0001\u0003\u0002\u0003\u0006Ia\u0015\u0005\u0006A\u0002!I!\u0019\u0005\u0006A\u0002!\t\u0001\u001a\u0005\bK\u0002\u0011\r\u0011\"\u0003g\u0011\u0019\u0001\b\u0001)A\u0005O\"9\u0011\u000f\u0001b\u0001\n\u0003\u0011\bBB=\u0001A\u0003%1\u000fC\u0004{\u0001\t\u0007I\u0011A>\t\u000f\u0005\u0015\u0001\u0001)A\u0005y\"I\u0011q\u0001\u0001A\u0002\u0013\u0005\u0011\u0011\u0002\u0005\n\u0003C\u0001\u0001\u0019!C\u0001\u0003GA\u0001\"a\f\u0001A\u0003&\u00111\u0002\u0005\f\u0003c\u0001\u0001\u0019!a\u0001\n\u0003\t\u0019\u0004C\u0006\u0002B\u0001\u0001\r\u00111A\u0005\u0002\u0005\r\u0003bCA$\u0001\u0001\u0007\t\u0011)Q\u0005\u0003kA!\"!\u0013\u0001\u0011\u000b\u0007I\u0011AA&\u0011)\tY\u0007\u0001EC\u0002\u0013\u0005\u0011Q\u000e\u0005\n\u0003k\u0002\u0001\u0019!C\u0005\u0003oB\u0011\"!!\u0001\u0001\u0004%I!a!\t\u0011\u0005\u001d\u0005\u0001)Q\u0005\u0003sB\u0011\"!#\u0001\u0001\u0004%I!a\u001e\t\u0013\u0005-\u0005\u00011A\u0005\n\u00055\u0005\u0002CAI\u0001\u0001\u0006K!!\u001f\t\u0019\u00055\u0002\u0001%A\t\b\u0004&I!a%\t\u0015\u0005E\u0006\u0001#b\u0001\n\u0003\t\u0019\f\u0003\u0006\u00026\u0002A)\u0019!C\u0001\u0003oC\u0011\"!/\u0001\u0001\u0004%\t!a/\t\u0013\u0005=\u0007\u00011A\u0005\u0002\u0005E\u0007\u0002CAk\u0001\u0001\u0006K!!0\t\u0013\u0005]\u0007A1A\u0005\n\u0005e\u0007\u0002CAq\u0001\u0001\u0006I!a7\t\u0013\u0005\r\bA1A\u0005\u0002\u0005\u0015\b\u0002CAz\u0001\u0001\u0006I!a:\t\u000f\u0005U\b\u0001\"\u0011\u0002x\"9!\u0011\u0002\u0001\u0005R\t-\u0001b\u0002B#\u0001\u0011\u0005#q\t\u0005\b\u00053\u0002A\u0011\tB.\u0011\u001d\u0011\t\u0007\u0001C\u0001\u0005GB\u0011B!*\u0001#\u0003%\tAa*\t\u0011\tu\u0006\u0001\"\u0001G\u0005\u007fCqA!0\u0001\t\u0003\u0011)\rC\u0004\u0003h\u0002!\tA!;\t\u000f\tM\b\u0001\"\u0001\u0003v\"9!1 \u0001\u0005\u0002\tu\bbBB\u0001\u0001\u0011\u000511\u0001\u0005\b\u0007\u000f\u0001A\u0011AB\u0005\u0011\u001d\u00199\u0002\u0001C\u0001\u00073Aqa!\b\u0001\t\u0003\u0019y\u0002C\u0004\u0004.\u0001!\taa\f\t\u0013\r=\u0003!%A\u0005\u0002\rE\u0003bBB+\u0001\u0011\u00051q\u000b\u0005\b\u00077\u0002A\u0011AB/\u0011\u001d\u0019Y\b\u0001C!\u0007{Bqaa \u0001\t\u0003\u0019\t\tC\u0004\u0004\n\u0002!\taa#\t\u000f\rE\u0005\u0001\"\u0015\u0004\u0014\"91Q\u0013\u0001\u0005\n\r]\u0005\u0002CBN\u0001\u0011\u0005ai!(\t\u0011\r\u0015\u0006\u0001\"\u0001G\u0007OC\u0001ba+\u0001\t\u000315Q\u0014\u0005\t\u0007[\u0003A\u0011\u0001$\u00040\"A11\u0017\u0001\u0005\u0002\u0019\u001bi\n\u0003\u0005\u00046\u0002!\tARB\\\u0011\u001d\u0019Y\f\u0001C\u0005\u0007{Cqaa6\u0001\t\u0013\u0019i\bC\u0004\u0004Z\u0002!Iaa7\u0003)-KX/\u001e2j'\u0016\u001c8/[8o\u001b\u0006t\u0017mZ3s\u0015\t)e)A\u0004tKN\u001c\u0018n\u001c8\u000b\u0005\u001dC\u0015AB6zkV\u0014\u0017N\u0003\u0002J\u0015\u00061\u0011\r]1dQ\u0016T\u0011aS\u0001\u0004_J<7\u0001A\n\u0003\u00019\u0003\"a\u0014)\u000e\u0003\u0011K!!\u0015#\u0003\u001dM+7o]5p]6\u000bg.Y4fe\u0006!a.Y7f!\t!VL\u0004\u0002V7B\u0011a+W\u0007\u0002/*\u0011\u0001\fT\u0001\u0007yI|w\u000e\u001e \u000b\u0003i\u000bQa]2bY\u0006L!\u0001X-\u0002\rA\u0013X\rZ3g\u0013\tqvL\u0001\u0004TiJLgn\u001a\u0006\u00039f\u000ba\u0001P5oSRtDC\u00012d!\ty\u0005\u0001C\u0003S\u0005\u0001\u00071\u000bF\u0001c\u0003\u0019\u0001\u0018M]:feV\tq\r\u0005\u0002i]6\t\u0011N\u0003\u0002kW\u000611/\u001a:wKJT!!\u001a7\u000b\u000554\u0015aA:rY&\u0011q.\u001b\u0002\r\u0017f,XOY5QCJ\u001cXM]\u0001\ba\u0006\u00148/\u001a:!\u0003Ay\u0007/\u001a:bi&|g.T1oC\u001e,'/F\u0001t!\t!x/D\u0001v\u0015\t1h)A\u0005pa\u0016\u0014\u0018\r^5p]&\u0011\u00010\u001e\u0002\u0017\u0017f,XOY5Pa\u0016\u0014\u0018\r^5p]6\u000bg.Y4fe\u0006\tr\u000e]3sCRLwN\\'b]\u0006<WM\u001d\u0011\u0002%\r\u0014X\rZ3oi&\fGn]'b]\u0006<WM]\u000b\u0002yB\u0019Q0!\u0001\u000e\u0003yT!a $\u0002\u0017\r\u0014X\rZ3oi&\fGn]\u0005\u0004\u0003\u0007q(\u0001\u0007%bI>|\u0007o\u0011:fI\u0016tG/[1mg6\u000bg.Y4fe\u0006\u00192M]3eK:$\u0018.\u00197t\u001b\u0006t\u0017mZ3sA\u0005yQ.\u001a;bI\u0006$\u0018-T1oC\u001e,'/\u0006\u0002\u0002\fA1\u0011QBA\b\u0003'i\u0011!W\u0005\u0004\u0003#I&AB(qi&|g\u000e\u0005\u0003\u0002\u0016\u0005uQBAA\f\u0015\u0011\tI\"a\u0007\u0002\u00115,G/\u00193bi\u0006T!A\u001b$\n\t\u0005}\u0011q\u0003\u0002\u0010\u001b\u0016$\u0018\rZ1uC6\u000bg.Y4fe\u0006\u0019R.\u001a;bI\u0006$\u0018-T1oC\u001e,'o\u0018\u0013fcR!\u0011QEA\u0016!\u0011\ti!a\n\n\u0007\u0005%\u0012L\u0001\u0003V]&$\b\"CA\u0017\u0017\u0005\u0005\t\u0019AA\u0006\u0003\rAH%M\u0001\u0011[\u0016$\u0018\rZ1uC6\u000bg.Y4fe\u0002\n!#\u00199qY&\u001c\u0017\r^5p]6\u000bg.Y4feV\u0011\u0011Q\u0007\t\u0005\u0003o\ti$\u0004\u0002\u0002:)\u0019\u00111\b$\u0002\r\u0015tw-\u001b8f\u0013\u0011\ty$!\u000f\u00031-KX/\u001e2j\u0003B\u0004H.[2bi&|g.T1oC\u001e,'/\u0001\fbaBd\u0017nY1uS>tW*\u00198bO\u0016\u0014x\fJ3r)\u0011\t)#!\u0012\t\u0013\u00055b\"!AA\u0002\u0005U\u0012aE1qa2L7-\u0019;j_:l\u0015M\\1hKJ\u0004\u0013AE:fgNLwN\\\"p]\u001a\fEM^5t_J,\"!!\u0014\u0011\r\u0005=\u0013\u0011LA0\u001d\u0011\t\t&!\u0016\u000f\u0007Y\u000b\u0019&C\u0001[\u0013\r\t9&W\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\tY&!\u0018\u0003\u0007M+\u0017OC\u0002\u0002Xe\u0003B!!\u0019\u0002h5\u0011\u00111\r\u0006\u0004\u0003K2\u0015A\u00029mk\u001eLg.\u0003\u0003\u0002j\u0005\r$AE*fgNLwN\\\"p]\u001a\fEM^5t_J\fQb\u001a:pkB\u0004&o\u001c<jI\u0016\u0014XCAA8!\u0011\t\t'!\u001d\n\t\u0005M\u00141\r\u0002\u000e\u000fJ|W\u000f\u001d)s_ZLG-\u001a:\u0002\u000f1LW.\u001b;feV\u0011\u0011\u0011\u0010\t\u0007\u0003\u001b\ty!a\u001f\u0011\u0007=\u000bi(C\u0002\u0002\u0000\u0011\u0013abU3tg&|g\u000eT5nSR,'/A\u0006mS6LG/\u001a:`I\u0015\fH\u0003BA\u0013\u0003\u000bC\u0011\"!\f\u0014\u0003\u0003\u0005\r!!\u001f\u0002\u00111LW.\u001b;fe\u0002\nABY1uG\"d\u0015.\\5uKJ\f\u0001CY1uG\"d\u0015.\\5uKJ|F%Z9\u0015\t\u0005\u0015\u0012q\u0012\u0005\n\u0003[1\u0012\u0011!a\u0001\u0003s\nQBY1uG\"d\u0015.\\5uKJ\u0004SCAAK!!\ti!a&\u0002\u001c\u0006-\u0016bAAM3\n1A+\u001e9mKJ\u0002B!!(\u0002(6\u0011\u0011q\u0014\u0006\u0005\u0003C\u000b\u0019+\u0001\u0005tK\u000e,(/\u001b;z\u0015\t\t)+\u0001\u0003kCZ\f\u0017\u0002BAU\u0003?\u0013!\u0002\u0015:jm\u0006$XmS3z!\u0011\ti*!,\n\t\u0005=\u0016q\u0014\u0002\n!V\u0014G.[2LKf\f\u0011c]5h]&tw\r\u0015:jm\u0006$XmS3z+\t\tY*\u0001\ttS\u001et\u0017N\\4Qk\nd\u0017nY&fsV\u0011\u00111V\u0001\u001eK:<\u0017N\\3Ti\u0006\u0014H/\u001e9Qe>\u001cWm]:TK6\f\u0007\u000f[8sKV\u0011\u0011Q\u0018\t\u0007\u0003\u001b\ty!a0\u0011\t\u0005\u0005\u00171Z\u0007\u0003\u0003\u0007TA!!2\u0002H\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\t\u0005%\u00171U\u0001\u0005kRLG.\u0003\u0003\u0002N\u0006\r'!C*f[\u0006\u0004\bn\u001c:f\u0003\u0005*gnZ5oKN#\u0018M\u001d;vaB\u0013xnY3tgN+W.\u00199i_J,w\fJ3r)\u0011\t)#a5\t\u0013\u00055B$!AA\u0002\u0005u\u0016AH3oO&tWm\u0015;beR,\b\u000f\u0015:pG\u0016\u001c8oU3nCBDwN]3!\u0003q)gnZ5oK\u000e{gN\\3di&|g.\u00117jm\u0016\u001c\u0005.Z2lKJ,\"!a7\u0011\t\u0005\u0005\u0017Q\\\u0005\u0005\u0003?\f\u0019M\u0001\rTG\",G-\u001e7fI\u0016CXmY;u_J\u001cVM\u001d<jG\u0016\fQ$\u001a8hS:,7i\u001c8oK\u000e$\u0018n\u001c8BY&4Xm\u00115fG.,'\u000fI\u0001\u0010i\u0016l\u0007OR5mKN+'O^5dKV\u0011\u0011q\u001d\t\u0005\u0003S\fy/\u0004\u0002\u0002l*\u0019\u0011Q\u001e$\u0002\u000fM,'O^5dK&!\u0011\u0011_Av\u0005=!V-\u001c9GS2,7+\u001a:wS\u000e,\u0017\u0001\u0005;f[B4\u0015\u000e\\3TKJ4\u0018nY3!\u0003)Ig.\u001b;jC2L'0\u001a\u000b\u0005\u0003K\tI\u0010C\u0004\u0002|\n\u0002\r!!@\u0002\t\r|gN\u001a\t\u0005\u0003\u007f\u0014)!\u0004\u0002\u0003\u0002)\u0019!1\u0001$\u0002\r\r|gNZ5h\u0013\u0011\u00119A!\u0001\u0003\u0015-KX/\u001e2j\u0007>tg-A\u0007de\u0016\fG/Z*fgNLwN\u001c\u000b\r\u0005\u001b\u0011\u0019B!\r\u00036\te\"Q\b\t\u0004\u001f\n=\u0011b\u0001B\t\t\n91+Z:tS>t\u0007b\u0002B\u000bG\u0001\u0007!qC\u0001\taJ|Go\\2pYB!!\u0011\u0004B\u0017\u001b\t\u0011YB\u0003\u0003\u0003\u001e\t}\u0011A\u0002;ie&4GO\u0003\u0003\u0003\"\t\r\u0012a\u0001:qG*!\u0011Q\u001eB\u0013\u0015\u0011\u00119C!\u000b\u0002\t!Lg/\u001a\u0006\u0004\u0005W1\u0015AB:iC\u0012,G-\u0003\u0003\u00030\tm!\u0001\u0005+Qe>$xnY8m-\u0016\u00148/[8o\u0011\u0019\u0011\u0019d\ta\u0001'\u0006!Qo]3s\u0011\u0019\u00119d\ta\u0001'\u0006A\u0001/Y:to>\u0014H\r\u0003\u0004\u0003<\r\u0002\raU\u0001\nSB\fE\r\u001a:fgNDq!a?$\u0001\u0004\u0011y\u0004E\u0003U\u0005\u0003\u001a6+C\u0002\u0003D}\u00131!T1q\u0003-y\u0007/\u001a8TKN\u001c\u0018n\u001c8\u0015\u0019\t%#q\nB)\u0005'\u0012)Fa\u0016\u0011\u0007=\u0013Y%C\u0002\u0003N\u0011\u0013QbU3tg&|g\u000eS1oI2,\u0007b\u0002B\u000bI\u0001\u0007!q\u0003\u0005\u0007\u0005g!\u0003\u0019A*\t\r\t]B\u00051\u0001T\u0011\u0019\u0011Y\u0004\na\u0001'\"9\u00111 \u0013A\u0002\t}\u0012\u0001D2m_N,7+Z:tS>tG\u0003BA\u0013\u0005;BqAa\u0018&\u0001\u0004\u0011I%A\u0007tKN\u001c\u0018n\u001c8IC:$G.Z\u0001\u0013GJ,\u0017\r^3CCR\u001c\u0007nU3tg&|g\u000e\u0006\r\u0003f\t-$Q\u000eB8\u0005c\u0012\u0019Ha\u001e\u0003~\t\u0005%Q\u0011BF\u00057\u00032a\u0014B4\u0013\r\u0011I\u0007\u0012\u0002\u0013\u0017f,XOY5CCR\u001c\u0007nU3tg&|g\u000e\u0003\u0004\u00034\u0019\u0002\ra\u0015\u0005\u0007\u0005o1\u0003\u0019A*\t\r\tmb\u00051\u0001T\u0011\u001d\tYP\na\u0001\u0005\u007fAaA!\u001e'\u0001\u0004\u0019\u0016!\u00032bi\u000eDG+\u001f9f\u0011\u001d\u0011IH\na\u0001\u0005w\n\u0011BY1uG\"t\u0015-\\3\u0011\u000b\u00055\u0011qB*\t\r\t}d\u00051\u0001T\u0003!\u0011Xm]8ve\u000e,\u0007B\u0002BBM\u0001\u00071+A\u0005dY\u0006\u001c8OT1nK\"9!q\u0011\u0014A\u0002\t%\u0015!\u00032bi\u000eD\u0017I]4t!\u0015\ty%!\u0017T\u0011%\tIB\nI\u0001\u0002\u0004\u0011i\t\u0005\u0004\u0002\u000e\u0005=!q\u0012\t\u0005\u0005#\u00139*\u0004\u0002\u0003\u0014*!!QSA\f\u0003\r\t\u0007/[\u0005\u0005\u00053\u0013\u0019J\u0001\u0005NKR\fG-\u0019;b\u0011\u001d\u0011iJ\na\u0001\u0005?\u000bAB\u001a:p[J+7m\u001c<fef\u0004B!!\u0004\u0003\"&\u0019!1U-\u0003\u000f\t{w\u000e\\3b]\u0006i2M]3bi\u0016\u0014\u0015\r^2i'\u0016\u001c8/[8oI\u0011,g-Y;mi\u0012\n\u0004'\u0006\u0002\u0003**\"!Q\u0012BVW\t\u0011i\u000b\u0005\u0003\u00030\neVB\u0001BY\u0015\u0011\u0011\u0019L!.\u0002\u0013Ut7\r[3dW\u0016$'b\u0001B\\3\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\tm&\u0011\u0017\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017\u0001E8qK:\u0014\u0015\r^2i'\u0016\u001c8/[8o)\u0011\u0011IE!1\t\u000f\t\r\u0007\u00061\u0001\u0003f\u0005a!-\u0019;dQN+7o]5p]RQ!\u0011\nBd\u0005\u0013\u0014YM!4\t\r\tM\u0012\u00061\u0001T\u0011\u0019\u00119$\u000ba\u0001'\"1!1H\u0015A\u0002MCqAa4*\u0001\u0004\u0011\t.\u0001\u0007cCR\u001c\u0007NU3rk\u0016\u001cH\u000f\u0005\u0003\u0003T\n\rXB\u0001Bk\u0015\u0011\u00119N!7\u0002\u0007\u0011$xN\u0003\u0003\u0003\\\nu\u0017A\u0001<2\u0015\u0011\u0011)Ja8\u000b\u0007\t\u0005h)\u0001\u0004dY&,g\u000e^\u0005\u0005\u0005K\u0014)N\u0001\u0007CCR\u001c\u0007NU3rk\u0016\u001cH/\u0001\u000bj]&$\u0018.\u00197ju\u0016\u0014\u0015\r^2i'R\fG/\u001a\u000b\n'\n-(Q\u001eBx\u0005cDaAa\r+\u0001\u0004\u0019\u0006B\u0002B\u001eU\u0001\u00071\u000bC\u0004\u0002|*\u0002\rAa\u0010\t\u000f\t='\u00061\u0001\u0003R\u0006yq-\u001a;CCR\u001c\u0007nU3tg&|g\u000e\u0006\u0003\u0003x\ne\bCBA\u0007\u0003\u001f\u0011)\u0007C\u0004\u0003`-\u0002\rA!\u0013\u0002\u001d%t7/\u001a:u\u001b\u0016$\u0018\rZ1uCR!\u0011Q\u0005B\u0000\u0011\u001d\tI\u0002\fa\u0001\u0005\u001f\u000ba\"\u001e9eCR,W*\u001a;bI\u0006$\u0018\r\u0006\u0003\u0002&\r\u0015\u0001bBA\r[\u0001\u0007!qR\u0001\u001cO\u0016$X*\u001a;bI\u0006$\u0018MU3rk\u0016\u001cHo\u001d*fiJL(+\u001a4\u0015\t\r-11\u0003\t\u0007\u0003\u001b\tya!\u0004\u0011\t\u0005U1qB\u0005\u0005\u0007#\t9B\u0001\rNKR\fG-\u0019;b%\u0016\fX/Z:ugJ+GO]=SK\u001aDaa!\u0006/\u0001\u0004\u0019\u0016AC5eK:$\u0018NZ5fe\u0006\u0011C-\u001a*fO&\u001cH/\u001a:NKR\fG-\u0019;b%\u0016\fX/Z:ugJ+GO]=SK\u001a$B!!\n\u0004\u001c!11QC\u0018A\u0002M\u000b\u0011dZ3u\u0005\u0006$8\r\u001b$s_6lU\r^1eCR\f7\u000b^8sKR!1\u0011EB\u0015!\u0019\ti!a\u0004\u0004$A!!1[B\u0013\u0013\u0011\u00199C!6\u0003\u000b\t\u000bGo\u00195\t\r\r-\u0002\u00071\u0001T\u0003\u001d\u0011\u0017\r^2i\u0013\u0012\f1dZ3u\u0005\u0006$8\r[3t\rJ|W.T3uC\u0012\fG/Y*u_J,GCCB\u0019\u0007g\u0019ida\u0012\u0004LA1\u0011qJA-\u0007GAqa!\u000e2\u0001\u0004\u00199$\u0001\u0004gS2$XM\u001d\t\u0005\u0005#\u001bI$\u0003\u0003\u0004<\tM%AD'fi\u0006$\u0017\r^1GS2$XM\u001d\u0005\b\u0007\u007f\t\u0004\u0019AB!\u0003\u00111'o\\7\u0011\t\u0005511I\u0005\u0004\u0007\u000bJ&aA%oi\"91\u0011J\u0019A\u0002\r\u0005\u0013\u0001B:ju\u0016D\u0011b!\u00142!\u0003\u0005\rAa(\u0002\t\u0011,7oY\u0001&O\u0016$()\u0019;dQ\u0016\u001chI]8n\u001b\u0016$\u0018\rZ1uCN#xN]3%I\u00164\u0017-\u001e7uIQ*\"aa\u0015+\t\t}%1V\u0001\u0011O\u0016$()\u0019;dQ6+G/\u00193bi\u0006$BA!$\u0004Z!111F\u001aA\u0002M\u000bqb\u00197fC:,\b/T3uC\u0012\fG/\u0019\u000b\u0005\u0003K\u0019y\u0006\u0003\u0004\u0004\u0016Q\u0002\ra\u0015\u0015\u0004i\r\r\u0004\u0003BB3\u0007oj!aa\u001a\u000b\t\r%41N\u0001\fC:tw\u000e^1uS>t7O\u0003\u0003\u0004n\r=\u0014AB2p[6|gN\u0003\u0003\u0004r\rM\u0014AB4p_\u001edWM\u0003\u0002\u0004v\u0005\u00191m\\7\n\t\re4q\r\u0002\u0012-&\u001c\u0018N\u00197f\r>\u0014H+Z:uS:<\u0017!B:uCJ$HCAA\u0013\u0003e9W\r\u001e\"bi\u000eD7+Z:tS>t7\u000fV8SK\u000e|g/\u001a:\u0015\t\r\r5Q\u0011\t\u0007\u0003\u001f\nIF!\u001a\t\r\r\u001de\u00071\u0001T\u00039Y\u00170^;cS&s7\u000f^1oG\u0016\f!eZ3u!\u0016,'/\u00138ti\u0006t7-Z\"m_N,GMQ1uG\"\u001cVm]:j_:\u001cH\u0003BBG\u0007\u001f\u0003b!a\u0014\u0002Z\t=\u0005BBBDo\u0001\u00071+\u0001\u0005jgN+'O^3s+\t\u0011y*\u0001\nj]&$8+Z:tS>tG*[7ji\u0016\u0014H\u0003BA\u0013\u00073Cq!a?:\u0001\u0004\ti0A\thKR,f\u000e\\5nSR,G-V:feN,\"aa(\u0011\tQ\u001b\tkU\u0005\u0004\u0007G{&aA*fi\u0006)\"/\u001a4sKNDWK\u001c7j[&$X\rZ+tKJ\u001cH\u0003BA\u0013\u0007SCq!a?<\u0001\u0004\ti0\u0001\u0007hKR$UM\\=Vg\u0016\u00148/\u0001\tsK\u001a\u0014Xm\u001d5EK:LXk]3sgR!\u0011QEBY\u0011\u001d\tY0\u0010a\u0001\u0003{\f!bZ3u\t\u0016t\u00170\u00139t\u00039\u0011XM\u001a:fg\"$UM\\=JaN$B!!\n\u0004:\"9\u00111` A\u0002\u0005u\u0018aE1qa2L8+Z:tS>tG*[7ji\u0016\u0014HCDA=\u0007\u007f\u001b\u0019ma2\u0004L\u000e=71\u001b\u0005\b\u0007\u0003\u0004\u0005\u0019AB!\u0003%)8/\u001a:MS6LG\u000fC\u0004\u0004F\u0002\u0003\ra!\u0011\u0002\u001d%\u0004\u0018\t\u001a3sKN\u001cH*[7ji\"91\u0011\u001a!A\u0002\r\u0005\u0013AE;tKJL\u0005/\u00113ee\u0016\u001c8\u000fT5nSRDqa!4A\u0001\u0004\u0019y*A\tvg\u0016\u0014XK\u001c7j[&$X\r\u001a'jgRDqa!5A\u0001\u0004\u0019y*\u0001\u0007vg\u0016\u0014H)\u001a8z\u0019&\u001cH\u000fC\u0004\u0004V\u0002\u0003\raa(\u0002\u0015%\u0004H)\u001a8z\u0019&\u001cH/A\fti\u0006\u0014H/\u00128hS:,\u0017\t\\5wK\u000eCWmY6fe\u0006\t\u0013N\\5u\u000b:<\u0017N\\3Ti\u0006\u0014H/\u001e9Qe>\u001cWm]:TK6\f\u0007\u000f[8sKR!\u0011QEBo\u0011\u001d\tYP\u0011a\u0001\u0003{\u0004")
public class KyuubiSessionManager
extends SessionManager {
    private Seq<SessionConfAdvisor> sessionConfAdvisor;
    private GroupProvider groupProvider;
    private Tuple2<PrivateKey, PublicKey> x$1;
    private PrivateKey signingPrivateKey;
    private PublicKey signingPublicKey;
    private final KyuubiParser parser = new KyuubiParser();
    private final KyuubiOperationManager operationManager = new KyuubiOperationManager();
    private final HadoopCredentialsManager credentialsManager = new HadoopCredentialsManager();
    private Option<MetadataManager> metadataManager = None$.MODULE$;
    private KyuubiApplicationManager applicationManager;
    private Option<SessionLimiter> limiter = None$.MODULE$;
    private Option<SessionLimiter> batchLimiter = None$.MODULE$;
    private Option<Semaphore> engineStartupProcessSemaphore = None$.MODULE$;
    private final ScheduledExecutorService engineConnectionAliveChecker;
    private final TempFileService tempFileService;
    private volatile byte bitmap$0;

    private KyuubiParser parser() {
        return this.parser;
    }

    public KyuubiOperationManager operationManager() {
        return this.operationManager;
    }

    public HadoopCredentialsManager credentialsManager() {
        return this.credentialsManager;
    }

    public Option<MetadataManager> metadataManager() {
        return this.metadataManager;
    }

    public void metadataManager_$eq(Option<MetadataManager> x$1) {
        this.metadataManager = x$1;
    }

    public KyuubiApplicationManager applicationManager() {
        return this.applicationManager;
    }

    public void applicationManager_$eq(KyuubiApplicationManager x$1) {
        this.applicationManager = x$1;
    }

    private Seq<SessionConfAdvisor> sessionConfAdvisor$lzycompute() {
        KyuubiSessionManager kyuubiSessionManager = this;
        synchronized (kyuubiSessionManager) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.sessionConfAdvisor = PluginLoader$.MODULE$.loadSessionConfAdvisor(this.conf());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.sessionConfAdvisor;
    }

    public Seq<SessionConfAdvisor> sessionConfAdvisor() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.sessionConfAdvisor$lzycompute();
        }
        return this.sessionConfAdvisor;
    }

    private GroupProvider groupProvider$lzycompute() {
        KyuubiSessionManager kyuubiSessionManager = this;
        synchronized (kyuubiSessionManager) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.groupProvider = PluginLoader$.MODULE$.loadGroupProvider(this.conf());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.groupProvider;
    }

    public GroupProvider groupProvider() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.groupProvider$lzycompute();
        }
        return this.groupProvider;
    }

    private Option<SessionLimiter> limiter() {
        return this.limiter;
    }

    private void limiter_$eq(Option<SessionLimiter> x$1) {
        this.limiter = x$1;
    }

    private Option<SessionLimiter> batchLimiter() {
        return this.batchLimiter;
    }

    private void batchLimiter_$eq(Option<SessionLimiter> x$1) {
        this.batchLimiter = x$1;
    }

    private Tuple2<PrivateKey, PublicKey> x$1$lzycompute() {
        KyuubiSessionManager kyuubiSessionManager = this;
        synchronized (kyuubiSessionManager) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                Tuple2 tuple2 = SignUtils$.MODULE$.generateKeyPair(SignUtils$.MODULE$.generateKeyPair$default$1());
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                PrivateKey signingPrivateKey = (PrivateKey)tuple2._1();
                PublicKey signingPublicKey = (PublicKey)tuple2._2();
                this.x$1 = new Tuple2((Object)signingPrivateKey, (Object)signingPublicKey);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.x$1;
    }

    private /* synthetic */ Tuple2 x$1() {
        if ((byte)(this.bitmap$0 & 4) == 0) {
            return this.x$1$lzycompute();
        }
        return this.x$1;
    }

    private PrivateKey signingPrivateKey$lzycompute() {
        KyuubiSessionManager kyuubiSessionManager = this;
        synchronized (kyuubiSessionManager) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.signingPrivateKey = (PrivateKey)this.x$1()._1();
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.signingPrivateKey;
    }

    public PrivateKey signingPrivateKey() {
        if ((byte)(this.bitmap$0 & 8) == 0) {
            return this.signingPrivateKey$lzycompute();
        }
        return this.signingPrivateKey;
    }

    private PublicKey signingPublicKey$lzycompute() {
        KyuubiSessionManager kyuubiSessionManager = this;
        synchronized (kyuubiSessionManager) {
            if ((byte)(this.bitmap$0 & 0x10) == 0) {
                this.signingPublicKey = (PublicKey)this.x$1()._2();
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
            }
        }
        return this.signingPublicKey;
    }

    public PublicKey signingPublicKey() {
        if ((byte)(this.bitmap$0 & 0x10) == 0) {
            return this.signingPublicKey$lzycompute();
        }
        return this.signingPublicKey;
    }

    public Option<Semaphore> engineStartupProcessSemaphore() {
        return this.engineStartupProcessSemaphore;
    }

    public void engineStartupProcessSemaphore_$eq(Option<Semaphore> x$1) {
        this.engineStartupProcessSemaphore = x$1;
    }

    private ScheduledExecutorService engineConnectionAliveChecker() {
        return this.engineConnectionAliveChecker;
    }

    public TempFileService tempFileService() {
        return this.tempFileService;
    }

    public void initialize(KyuubiConf conf) {
        this.conf_$eq(conf);
        if (conf.isRESTEnabled()) {
            this.metadataManager_$eq((Option<MetadataManager>)new Some((Object)new MetadataManager()));
        }
        this.applicationManager_$eq(new KyuubiApplicationManager(this.metadataManager()));
        this.addService((Service)this.applicationManager());
        this.addService((Service)this.credentialsManager());
        this.addService((Service)this.tempFileService());
        this.metadataManager().foreach((Function1 & Serializable & scala.Serializable)service -> {
            this.addService(service);
            return BoxedUnit.UNIT;
        });
        this.initSessionLimiter(conf);
        this.initEngineStartupProcessSemaphore(conf);
        super.initialize(conf);
    }

    public Session createSession(TProtocolVersion protocol, String user, String password, String ipAddress, Map<String, String> conf) {
        KyuubiConf userConf = this.getConf().getUserDefaults(user);
        return new KyuubiSessionImpl(protocol, user, password, ipAddress, conf, this, userConf, BoxesRunTime.unboxToBoolean((Object)userConf.get(KyuubiConf$.MODULE$.ENGINE_DO_AS_ENABLED())), this.parser());
    }

    public SessionHandle openSession(TProtocolVersion protocol, String user, String password, String ipAddress, Map<String, String> conf) {
        SessionHandle sessionHandle;
        String username = (String)Option$.MODULE$.apply((Object)user).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)KyuubiSessionManager.$anonfun$openSession$1(x$2))).getOrElse((Function0 & Serializable & scala.Serializable)() -> "anonymous");
        this.limiter().foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
            x$3.increment(new UserIpAddress(username, ipAddress));
            return BoxedUnit.UNIT;
        });
        try {
            sessionHandle = super.openSession(protocol, username, password, ipAddress, conf);
        }
        catch (Throwable e) {
            MetricsSystem$.MODULE$.tracing((Function1 & Serializable & scala.Serializable)ms -> {
                KyuubiSessionManager.$anonfun$openSession$4(user, ms);
                return BoxedUnit.UNIT;
            });
            throw KyuubiSQLException$.MODULE$.apply(new StringBuilder(46).append("Error opening session for ").append(username).append(" client ip ").append(ipAddress).append(", due to ").append(e.getMessage()).toString(), e, KyuubiSQLException$.MODULE$.apply$default$3(), KyuubiSQLException$.MODULE$.apply$default$4());
        }
        return sessionHandle;
    }

    public void closeSession(SessionHandle sessionHandle) {
        Session session = this.getSession(sessionHandle);
        try {
            super.closeSession(sessionHandle);
        }
        finally {
            Session session2 = session;
            if (session2 instanceof KyuubiBatchSession) {
                this.batchLimiter().foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
                    x$4.decrement(new UserIpAddress(session.user(), session.ipAddress()));
                    return BoxedUnit.UNIT;
                });
            } else {
                this.limiter().foreach((Function1 & Serializable & scala.Serializable)x$5 -> {
                    x$5.decrement(new UserIpAddress(session.user(), session.ipAddress()));
                    return BoxedUnit.UNIT;
                });
            }
        }
    }

    public KyuubiBatchSession createBatchSession(String user, String password, String ipAddress, Map<String, String> conf, String batchType, Option<String> batchName, String resource, String className, Seq<String> batchArgs, Option<Metadata> metadata, boolean fromRecovery) {
        String username = (String)Option$.MODULE$.apply((Object)user).filter((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)KyuubiSessionManager.$anonfun$createBatchSession$1(x$6))).getOrElse((Function0 & Serializable & scala.Serializable)() -> "anonymous");
        KyuubiConf sessionConf = this.getConf().getUserDefaults(user);
        return new KyuubiBatchSession(username, password, ipAddress, conf, this, sessionConf, batchType, batchName, resource, className, batchArgs, metadata, fromRecovery);
    }

    public Option<Metadata> createBatchSession$default$10() {
        return None$.MODULE$;
    }

    public SessionHandle openBatchSession(KyuubiBatchSession batchSession) {
        SessionHandle sessionHandle;
        String user = batchSession.user();
        String ipAddress = batchSession.ipAddress();
        this.batchLimiter().foreach((Function1 & Serializable & scala.Serializable)x$7 -> {
            x$7.increment(new UserIpAddress(user, ipAddress));
            return BoxedUnit.UNIT;
        });
        SessionHandle handle = batchSession.handle();
        try {
            this.setSession(handle, (Session)batchSession);
            batchSession.open();
            this.logSessionCountInfo((Session)batchSession, "opened");
            sessionHandle = handle;
        }
        catch (Exception e) {
            try {
                this.closeSession(handle);
            }
            catch (Throwable t) {
                this.warn((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append("Error closing batch session[").append(handle).append("] for ").append(user).append(" client ip: ").append(ipAddress).toString(), t);
            }
            MetricsSystem$.MODULE$.tracing((Function1 & Serializable & scala.Serializable)ms -> {
                KyuubiSessionManager.$anonfun$openBatchSession$3(user, ms);
                return BoxedUnit.UNIT;
            });
            throw KyuubiSQLException$.MODULE$.apply(new StringBuilder(54).append("Error opening batch session[").append(handle).append("] for ").append(user).append(" client ip ").append(ipAddress).append(",").append(" due to ").append(e.getMessage()).toString(), (Throwable)e, KyuubiSQLException$.MODULE$.apply$default$3(), KyuubiSQLException$.MODULE$.apply$default$4());
        }
        return sessionHandle;
    }

    public SessionHandle openBatchSession(String user, String password, String ipAddress, BatchRequest batchRequest) {
        KyuubiBatchSession batchSession = this.createBatchSession(user, password, ipAddress, (Map<String, String>)((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(batchRequest.getConf()).asScala()).toMap(Predef$.MODULE$.$conforms()), batchRequest.getBatchType(), (Option<String>)Option$.MODULE$.apply((Object)batchRequest.getName()), batchRequest.getResource(), batchRequest.getClassName(), (Seq<String>)((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(batchRequest.getArgs()).asScala()).toSeq(), (Option<Metadata>)None$.MODULE$, false);
        return this.openBatchSession(batchSession);
    }

    public String initializeBatchState(String user, String ipAddress, Map<String, String> conf, BatchRequest batchRequest) {
        String batchId;
        String realUser = (String)conf.getOrElse((Object)"kyuubi.session.real.user", (Function0 & Serializable & scala.Serializable)() -> user);
        String username = (String)Option$.MODULE$.apply((Object)user).filter((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)KyuubiSessionManager.$anonfun$initializeBatchState$2(x$8))).getOrElse((Function0 & Serializable & scala.Serializable)() -> "anonymous");
        String x$1 = batchId = (String)conf.apply((Object)BatchUtils.KYUUBI_BATCH_ID_KEY);
        Enumeration.Value x$2 = SessionType$.MODULE$.BATCH();
        String x$3 = realUser;
        String x$4 = username;
        String x$5 = ipAddress;
        String x$6 = OperationState$.MODULE$.INITIALIZED().toString();
        String x$7 = batchRequest.getResource();
        String x$82 = batchRequest.getClassName();
        String x$92 = batchRequest.getName();
        Map<String, String> x$102 = conf;
        Seq x$11 = ((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(batchRequest.getArgs()).asScala()).toSeq();
        long x$12 = System.currentTimeMillis();
        String x$13 = batchRequest.getBatchType();
        int x$14 = BoxesRunTime.unboxToInt((Object)conf.get((Object)"kyuubi.batch.priority").map((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToInteger((int)KyuubiSessionManager.$anonfun$initializeBatchState$4(x$9))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 10));
        String x$15 = Metadata$.MODULE$.apply$default$6();
        Option<String> x$16 = Metadata$.MODULE$.apply$default$15();
        long x$17 = Metadata$.MODULE$.apply$default$16();
        String x$18 = Metadata$.MODULE$.apply$default$17();
        String x$19 = Metadata$.MODULE$.apply$default$18();
        String x$20 = Metadata$.MODULE$.apply$default$19();
        String x$21 = Metadata$.MODULE$.apply$default$20();
        Option<String> x$22 = Metadata$.MODULE$.apply$default$21();
        long x$23 = Metadata$.MODULE$.apply$default$22();
        boolean x$24 = Metadata$.MODULE$.apply$default$24();
        Metadata metadata = new Metadata(x$1, x$2, x$3, x$4, x$5, x$15, x$6, x$7, x$82, x$92, x$102, (Seq<String>)x$11, x$12, x$13, x$16, x$17, x$18, x$19, x$20, x$21, x$22, x$23, x$14, x$24);
        this.metadataManager().foreach((Function1 & Serializable & scala.Serializable)x$10 -> {
            x$10.insertMetadata(metadata, false);
            return BoxedUnit.UNIT;
        });
        return batchId;
    }

    public Option<KyuubiBatchSession> getBatchSession(SessionHandle sessionHandle) {
        return this.getSessionOption(sessionHandle).map((Function1 & Serializable & scala.Serializable)x$11 -> (KyuubiBatchSession)((Object)x$11));
    }

    public void insertMetadata(Metadata metadata) {
        this.metadataManager().foreach((Function1 & Serializable & scala.Serializable)x$12 -> {
            x$12.insertMetadata(metadata, x$12.insertMetadata$default$2());
            return BoxedUnit.UNIT;
        });
    }

    public void updateMetadata(Metadata metadata) {
        this.metadataManager().foreach((Function1 & Serializable & scala.Serializable)x$13 -> {
            x$13.updateMetadata(metadata, x$13.updateMetadata$default$2());
            return BoxedUnit.UNIT;
        });
    }

    public Option<MetadataRequestsRetryRef> getMetadataRequestsRetryRef(String identifier) {
        return this.metadataManager().flatMap((Function1 & Serializable & scala.Serializable)mm -> Option$.MODULE$.apply((Object)mm.getMetadataRequestsRetryRef(identifier)));
    }

    public void deRegisterMetadataRequestsRetryRef(String identifier) {
        this.metadataManager().foreach((Function1 & Serializable & scala.Serializable)x$14 -> {
            x$14.deRegisterRequestsRetryRef(identifier);
            return BoxedUnit.UNIT;
        });
    }

    public Option<Batch> getBatchFromMetadataStore(String batchId) {
        return this.metadataManager().flatMap((Function1 & Serializable & scala.Serializable)mm -> mm.getBatch(batchId));
    }

    public Seq<Batch> getBatchesFromMetadataStore(MetadataFilter filter, int from, int size, boolean desc) {
        return (Seq)this.metadataManager().map((Function1 & Serializable & scala.Serializable)x$15 -> x$15.getBatches(filter, from, size, desc)).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Nil$.MODULE$);
    }

    public boolean getBatchesFromMetadataStore$default$4() {
        return false;
    }

    public Option<Metadata> getBatchMetadata(String batchId) {
        return this.metadataManager().flatMap((Function1 & Serializable & scala.Serializable)x$16 -> x$16.getBatchSessionMetadata(batchId));
    }

    @VisibleForTesting
    public void cleanupMetadata(String identifier) {
        this.metadataManager().foreach((Function1 & Serializable & scala.Serializable)x$17 -> {
            x$17.cleanupMetadataById(identifier);
            return BoxedUnit.UNIT;
        });
    }

    public synchronized void start() {
        MetricsSystem$.MODULE$.tracing((Function1 & Serializable & scala.Serializable)ms -> {
            KyuubiSessionManager.$anonfun$start$1(this, ms);
            return BoxedUnit.UNIT;
        });
        super.start();
        this.startEngineAliveChecker();
    }

    public Seq<KyuubiBatchSession> getBatchSessionsToRecover(String kyuubiInstance) {
        return (Seq)((TraversableLike)new .colon.colon((Object)OperationState$.MODULE$.PENDING(), (List)new .colon.colon((Object)OperationState$.MODULE$.RUNNING(), (List)Nil$.MODULE$))).flatMap((Function1 & Serializable & scala.Serializable)stateToRecover -> (Seq)this.metadataManager().map((Function1 & Serializable & scala.Serializable)x$18 -> (Seq)x$18.getBatchesRecoveryMetadata(stateToRecover.toString(), kyuubiInstance, 0, Integer.MAX_VALUE).map((Function1 & Serializable & scala.Serializable)metadata -> this.createBatchSession(metadata.username(), "anonymous", metadata.ipAddress(), metadata.requestConf(), metadata.engineType(), (Option<String>)Option$.MODULE$.apply((Object)metadata.requestName()), metadata.resource(), metadata.className(), metadata.requestArgs(), (Option<Metadata>)new Some(metadata), true), Seq$.MODULE$.canBuildFrom())).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Nil$.MODULE$), Seq$.MODULE$.canBuildFrom());
    }

    public Seq<Metadata> getPeerInstanceClosedBatchSessions(String kyuubiInstance) {
        return (Seq)((TraversableLike)new .colon.colon((Object)OperationState$.MODULE$.PENDING(), (List)new .colon.colon((Object)OperationState$.MODULE$.RUNNING(), (List)Nil$.MODULE$))).flatMap((Function1 & Serializable & scala.Serializable)stateToKill -> (Seq)this.metadataManager().map((Function1 & Serializable & scala.Serializable)x$19 -> x$19.getPeerInstanceClosedBatchesMetadata(stateToKill.toString(), kyuubiInstance, 0, Integer.MAX_VALUE)).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Nil$.MODULE$), Seq$.MODULE$.canBuildFrom());
    }

    public boolean isServer() {
        return true;
    }

    private void initSessionLimiter(KyuubiConf conf) {
        int userLimit = BoxesRunTime.unboxToInt((Object)((Option)conf.get((ConfigEntry)KyuubiConf$.MODULE$.SERVER_LIMIT_CONNECTIONS_PER_USER())).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
        int ipAddressLimit = BoxesRunTime.unboxToInt((Object)((Option)conf.get((ConfigEntry)KyuubiConf$.MODULE$.SERVER_LIMIT_CONNECTIONS_PER_IPADDRESS())).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
        int userIpAddressLimit = BoxesRunTime.unboxToInt((Object)((Option)conf.get((ConfigEntry)KyuubiConf$.MODULE$.SERVER_LIMIT_CONNECTIONS_PER_USER_IPADDRESS())).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
        Set userUnlimitedList = (Set)((TraversableLike)conf.get(KyuubiConf$.MODULE$.SERVER_LIMIT_CONNECTIONS_USER_UNLIMITED_LIST())).filter((Function1 & Serializable & scala.Serializable)x$20 -> BoxesRunTime.boxToBoolean((boolean)KyuubiSessionManager.$anonfun$initSessionLimiter$4(x$20)));
        Set userDenyList = (Set)((TraversableLike)conf.get(KyuubiConf$.MODULE$.SERVER_LIMIT_CONNECTIONS_USER_DENY_LIST())).filter((Function1 & Serializable & scala.Serializable)x$21 -> BoxesRunTime.boxToBoolean((boolean)KyuubiSessionManager.$anonfun$initSessionLimiter$5(x$21)));
        Set ipDenyList = (Set)((TraversableLike)conf.get(KyuubiConf$.MODULE$.SERVER_LIMIT_CONNECTIONS_IP_DENY_LIST())).filter((Function1 & Serializable & scala.Serializable)x$22 -> BoxesRunTime.boxToBoolean((boolean)KyuubiSessionManager.$anonfun$initSessionLimiter$6(x$22)));
        this.limiter_$eq(this.applySessionLimiter(userLimit, ipAddressLimit, userIpAddressLimit, (Set<String>)userUnlimitedList, (Set<String>)userDenyList, (Set<String>)ipDenyList));
        int userBatchLimit = BoxesRunTime.unboxToInt((Object)((Option)conf.get((ConfigEntry)KyuubiConf$.MODULE$.SERVER_LIMIT_BATCH_CONNECTIONS_PER_USER())).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
        int ipAddressBatchLimit = BoxesRunTime.unboxToInt((Object)((Option)conf.get((ConfigEntry)KyuubiConf$.MODULE$.SERVER_LIMIT_BATCH_CONNECTIONS_PER_IPADDRESS())).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
        int userIpAddressBatchLimit = BoxesRunTime.unboxToInt((Object)((Option)conf.get((ConfigEntry)KyuubiConf$.MODULE$.SERVER_LIMIT_BATCH_CONNECTIONS_PER_USER_IPADDRESS())).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
        this.batchLimiter_$eq(this.applySessionLimiter(userBatchLimit, ipAddressBatchLimit, userIpAddressBatchLimit, (Set<String>)userUnlimitedList, (Set<String>)userDenyList, (Set<String>)ipDenyList));
    }

    public Set<String> getUnlimitedUsers() {
        return (Set)this.limiter().orElse((Function0 & Serializable & scala.Serializable)() -> this.batchLimiter()).map((Function1 & Serializable & scala.Serializable)limiter -> SessionLimiter$.MODULE$.getUnlimitedUsers((SessionLimiter)limiter)).getOrElse((Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Set().empty());
    }

    public void refreshUnlimitedUsers(KyuubiConf conf) {
        Set unlimitedUsers = (Set)((TraversableLike)conf.get(KyuubiConf$.MODULE$.SERVER_LIMIT_CONNECTIONS_USER_UNLIMITED_LIST())).filter((Function1 & Serializable & scala.Serializable)x$23 -> BoxesRunTime.boxToBoolean((boolean)KyuubiSessionManager.$anonfun$refreshUnlimitedUsers$1(x$23)));
        this.limiter().foreach((Function1 & Serializable & scala.Serializable)x$24 -> {
            SessionLimiter$.MODULE$.resetUnlimitedUsers(x$24, (Set<String>)unlimitedUsers);
            return BoxedUnit.UNIT;
        });
        this.batchLimiter().foreach((Function1 & Serializable & scala.Serializable)x$25 -> {
            SessionLimiter$.MODULE$.resetUnlimitedUsers(x$25, (Set<String>)unlimitedUsers);
            return BoxedUnit.UNIT;
        });
    }

    public Set<String> getDenyUsers() {
        return (Set)this.limiter().orElse((Function0 & Serializable & scala.Serializable)() -> this.batchLimiter()).map((Function1 & Serializable & scala.Serializable)limiter -> SessionLimiter$.MODULE$.getDenyUsers((SessionLimiter)limiter)).getOrElse((Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Set().empty());
    }

    public void refreshDenyUsers(KyuubiConf conf) {
        Set denyUsers = (Set)((TraversableLike)conf.get(KyuubiConf$.MODULE$.SERVER_LIMIT_CONNECTIONS_USER_DENY_LIST())).filter((Function1 & Serializable & scala.Serializable)x$26 -> BoxesRunTime.boxToBoolean((boolean)KyuubiSessionManager.$anonfun$refreshDenyUsers$1(x$26)));
        this.limiter().foreach((Function1 & Serializable & scala.Serializable)x$27 -> {
            SessionLimiter$.MODULE$.resetDenyUsers(x$27, (Set<String>)denyUsers);
            return BoxedUnit.UNIT;
        });
        this.batchLimiter().foreach((Function1 & Serializable & scala.Serializable)x$28 -> {
            SessionLimiter$.MODULE$.resetDenyUsers(x$28, (Set<String>)denyUsers);
            return BoxedUnit.UNIT;
        });
    }

    public Set<String> getDenyIps() {
        return (Set)this.limiter().orElse((Function0 & Serializable & scala.Serializable)() -> this.batchLimiter()).map((Function1 & Serializable & scala.Serializable)limiter -> SessionLimiter$.MODULE$.getDenyIps((SessionLimiter)limiter)).getOrElse((Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Set().empty());
    }

    public void refreshDenyIps(KyuubiConf conf) {
        Set denyIps = (Set)((TraversableLike)conf.get(KyuubiConf$.MODULE$.SERVER_LIMIT_CONNECTIONS_IP_DENY_LIST())).filter((Function1 & Serializable & scala.Serializable)x$29 -> BoxesRunTime.boxToBoolean((boolean)KyuubiSessionManager.$anonfun$refreshDenyIps$1(x$29)));
        this.limiter().foreach((Function1 & Serializable & scala.Serializable)x$30 -> {
            SessionLimiter$.MODULE$.resetDenyIps(x$30, (Set<String>)denyIps);
            return BoxedUnit.UNIT;
        });
        this.batchLimiter().foreach((Function1 & Serializable & scala.Serializable)x$31 -> {
            SessionLimiter$.MODULE$.resetDenyIps(x$31, (Set<String>)denyIps);
            return BoxedUnit.UNIT;
        });
    }

    private Option<SessionLimiter> applySessionLimiter(int userLimit, int ipAddressLimit, int userIpAddressLimit, Set<String> userUnlimitedList, Set<String> userDenyList, Set<String> ipDenyList) {
        if (((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{userLimit, ipAddressLimit, userIpAddressLimit}))).exists((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$32 -> x$32 > 0) || userDenyList.nonEmpty() || ipDenyList.nonEmpty()) {
            return new Some((Object)SessionLimiter$.MODULE$.apply(userLimit, ipAddressLimit, userIpAddressLimit, userUnlimitedList, userDenyList, ipDenyList));
        }
        return None$.MODULE$;
    }

    private void startEngineAliveChecker() {
        long interval = BoxesRunTime.unboxToLong((Object)this.conf().get(KyuubiConf$.MODULE$.ENGINE_ALIVE_PROBE_INTERVAL()));
        Runnable checkTask = () -> this.allSessions().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            KyuubiSessionManager.$anonfun$startEngineAliveChecker$2(this, x0$1);
            return BoxedUnit.UNIT;
        });
        ThreadUtils$.MODULE$.scheduleTolerableRunnableWithFixedDelay(this.engineConnectionAliveChecker(), checkTask, interval, interval, TimeUnit.MILLISECONDS);
    }

    private void initEngineStartupProcessSemaphore(KyuubiConf conf) {
        Option engineCreationLimit = (Option)conf.get((ConfigEntry)KyuubiConf$.MODULE$.SERVER_LIMIT_ENGINE_CREATION());
        engineCreationLimit.filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$33 -> x$33 > 0).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)limit -> this.engineStartupProcessSemaphore_$eq((Option<Semaphore>)new Some((Object)new Semaphore(limit))));
    }

    public static final /* synthetic */ boolean $anonfun$openSession$1(String x$2) {
        return new StringOps(Predef$.MODULE$.augmentString(x$2)).nonEmpty();
    }

    public static final /* synthetic */ void $anonfun$openSession$4(String user$1, MetricsSystem ms) {
        ms.incCount(MetricsConstants$.MODULE$.CONN_FAIL());
        ms.incCount(MetricRegistry.name((String)MetricsConstants$.MODULE$.CONN_FAIL(), (String[])new String[]{user$1}));
        ms.incCount(MetricRegistry.name((String)MetricsConstants$.MODULE$.CONN_FAIL(), (String[])new String[]{SessionType$.MODULE$.INTERACTIVE().toString()}));
    }

    public static final /* synthetic */ boolean $anonfun$createBatchSession$1(String x$6) {
        return new StringOps(Predef$.MODULE$.augmentString(x$6)).nonEmpty();
    }

    public static final /* synthetic */ void $anonfun$openBatchSession$3(String user$2, MetricsSystem ms) {
        ms.incCount(MetricsConstants$.MODULE$.CONN_FAIL());
        ms.incCount(MetricRegistry.name((String)MetricsConstants$.MODULE$.CONN_FAIL(), (String[])new String[]{user$2}));
        ms.incCount(MetricRegistry.name((String)MetricsConstants$.MODULE$.CONN_FAIL(), (String[])new String[]{SessionType$.MODULE$.BATCH().toString()}));
    }

    public static final /* synthetic */ boolean $anonfun$initializeBatchState$2(String x$8) {
        return new StringOps(Predef$.MODULE$.augmentString(x$8)).nonEmpty();
    }

    public static final /* synthetic */ int $anonfun$initializeBatchState$4(String x$9) {
        return new StringOps(Predef$.MODULE$.augmentString(x$9)).toInt();
    }

    public static final /* synthetic */ void $anonfun$start$1(KyuubiSessionManager $this, MetricsSystem ms) {
        ms.registerGauge(MetricsConstants$.MODULE$.CONN_OPEN(), (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> $this.getActiveUserSessionCount(), (Object)BoxesRunTime.boxToInteger((int)0));
        ms.registerGauge(MetricsConstants$.MODULE$.EXEC_POOL_ALIVE(), (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> $this.getExecPoolSize(), (Object)BoxesRunTime.boxToInteger((int)0));
        ms.registerGauge(MetricsConstants$.MODULE$.EXEC_POOL_ACTIVE(), (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> $this.getActiveCount(), (Object)BoxesRunTime.boxToInteger((int)0));
        ms.registerGauge(MetricsConstants$.MODULE$.EXEC_POOL_WORK_QUEUE_SIZE(), (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> $this.getWorkQueueSize(), (Object)BoxesRunTime.boxToInteger((int)0));
    }

    public static final /* synthetic */ boolean $anonfun$initSessionLimiter$4(String x$20) {
        return new StringOps(Predef$.MODULE$.augmentString(x$20)).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$initSessionLimiter$5(String x$21) {
        return new StringOps(Predef$.MODULE$.augmentString(x$21)).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$initSessionLimiter$6(String x$22) {
        return new StringOps(Predef$.MODULE$.augmentString(x$22)).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$refreshUnlimitedUsers$1(String x$23) {
        return new StringOps(Predef$.MODULE$.augmentString(x$23)).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$refreshDenyUsers$1(String x$26) {
        return new StringOps(Predef$.MODULE$.augmentString(x$26)).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$refreshDenyIps$1(String x$29) {
        return new StringOps(Predef$.MODULE$.augmentString(x$29)).nonEmpty();
    }

    public static final /* synthetic */ void $anonfun$startEngineAliveChecker$2(KyuubiSessionManager $this, Session x0$1) {
        Session session = x0$1;
        if (session instanceof KyuubiSessionImpl) {
            BoxedUnit boxedUnit;
            KyuubiSessionImpl kyuubiSessionImpl = (KyuubiSessionImpl)session;
            try {
                if (!kyuubiSessionImpl.checkEngineConnectionAlive()) {
                    $this.closeSession(kyuubiSessionImpl.handle());
                    $this.logger().info(new StringBuilder(98).append("The session ").append(kyuubiSessionImpl.handle()).append(" has been closed ").append("due to engine unresponsiveness (checked by the engine alive checker).").toString());
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            }
            catch (Throwable e) {
                $this.warn((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(22).append("Error closing session ").append(kyuubiSessionImpl.handle()).toString(), e);
                boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
    }

    private KyuubiSessionManager(String name) {
        super(name);
        this.engineConnectionAliveChecker = ThreadUtils$.MODULE$.newDaemonSingleThreadScheduledExecutor(new StringBuilder(21).append(name).append("-engine-alive-checker").toString(), ThreadUtils$.MODULE$.newDaemonSingleThreadScheduledExecutor$default$2());
        this.tempFileService = new TempFileService();
    }

    public KyuubiSessionManager() {
        this(KyuubiSessionManager.class.getSimpleName());
    }
}

