/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.configuration.restful.api;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.configuration.conf.Configuration;
import org.apache.linkis.configuration.entity.CategoryLabelVo;
import org.apache.linkis.configuration.entity.ConfigKey;
import org.apache.linkis.configuration.entity.ConfigKeyValue;
import org.apache.linkis.configuration.entity.ConfigTree;
import org.apache.linkis.configuration.entity.ConfigUserValue;
import org.apache.linkis.configuration.entity.ConfigValue;
import org.apache.linkis.configuration.errorcode.LinkisConfigurationErrorCodeSummary;
import org.apache.linkis.configuration.exception.ConfigurationException;
import org.apache.linkis.configuration.service.CategoryService;
import org.apache.linkis.configuration.service.ConfigKeyService;
import org.apache.linkis.configuration.service.ConfigurationService;
import org.apache.linkis.configuration.util.ConfigurationConfiguration;
import org.apache.linkis.configuration.util.JsonNodeUtil;
import org.apache.linkis.configuration.util.LabelEntityParser;
import org.apache.linkis.configuration.validate.ValidatorManager;
import org.apache.linkis.manager.label.entity.Label;
import org.apache.linkis.manager.label.entity.engine.EngineTypeLabel;
import org.apache.linkis.manager.label.entity.engine.UserCreatorLabel;
import org.apache.linkis.server.BDPJettyServerHelper;
import org.apache.linkis.server.Message;
import org.apache.linkis.server.utils.ModuleUserUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"parameter configuration"})
@RestController
@RequestMapping(path={"/configuration"})
public class ConfigurationRestfulApi {
    private static final Logger logger = LoggerFactory.getLogger(ConfigurationRestfulApi.class);
    @Autowired
    private ConfigurationService configurationService;
    @Autowired
    private CategoryService categoryService;
    @Autowired
    private ConfigKeyService configKeyService;
    @Autowired
    private ValidatorManager validatorManager;
    ObjectMapper mapper = new ObjectMapper();
    private static final String NULL = "null";

    @ApiOperation(value="addKeyForEngine", notes="add key for engine", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="engineType", dataType="String"), @ApiImplicitParam(name="version", required=false, dataType="String", value="version"), @ApiImplicitParam(name="token, required = false", dataType="String", value="token"), @ApiImplicitParam(name="keyJson", required=false, dataType="String", value="key json")})
    @RequestMapping(path={"/addKeyForEngine"}, method={RequestMethod.GET})
    public Message addKeyForEngine(HttpServletRequest req, @RequestParam(value="engineType", required=false) String engineType, @RequestParam(value="version", required=false) String version, @RequestParam(value="token", required=false) String token, @RequestParam(value="keyJson", required=false) String keyJson) throws ConfigurationException {
        if (StringUtils.isBlank((CharSequence)engineType) || StringUtils.isBlank((CharSequence)version) || StringUtils.isBlank((CharSequence)token)) {
            throw new ConfigurationException(LinkisConfigurationErrorCodeSummary.PARAMS_CANNOT_BE_EMPTY.getErrorDesc());
        }
        ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)MessageFormat.format("addKeyForEngine,engineType:{0},version:{1},token:{2}", engineType, version, token));
        if (!token.equals(ConfigurationConfiguration.COPYKEYTOKEN)) {
            throw new ConfigurationException(LinkisConfigurationErrorCodeSummary.TOKEN_IS_ERROR.getErrorDesc());
        }
        ConfigKey configKey = (ConfigKey)BDPJettyServerHelper.gson().fromJson(keyJson, ConfigKey.class);
        this.configurationService.addKeyForEngine(engineType, version, configKey);
        return Message.ok();
    }

    @ApiOperation(value="getFullTreesByAppName", notes="get full trees by app name", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="engineType", dataType="String"), @ApiImplicitParam(name="version", dataType="String", value="version"), @ApiImplicitParam(name="creator", dataType="String", value="creator")})
    @RequestMapping(path={"/getFullTreesByAppName"}, method={RequestMethod.GET})
    public Message getFullTreesByAppName(HttpServletRequest req, @RequestParam(value="engineType", required=false) String engineType, @RequestParam(value="version", required=false) String version, @RequestParam(value="creator", required=false) String creator) throws ConfigurationException {
        if (creator != null && (creator.equals(org.apache.linkis.common.conf.Configuration.GLOBAL_CONF_CHN_NAME()) || creator.equals(org.apache.linkis.common.conf.Configuration.GLOBAL_CONF_CHN_OLDNAME()) || creator.equals(org.apache.linkis.common.conf.Configuration.GLOBAL_CONF_CHN_EN_NAME()))) {
            engineType = "*";
            version = "*";
            creator = "*";
        }
        String username = ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)MessageFormat.format("getFullTreesByAppName,engineType:{0},version:{1},creator:{2}", engineType, version, creator));
        ArrayList<Label<?>> labelList = LabelEntityParser.generateUserCreatorEngineTypeLabelList(username, creator, engineType, version);
        ArrayList<ConfigTree> configTrees = this.configurationService.getFullTreeByLabelList(labelList, true, req.getHeader("Content-Language"));
        return Message.ok().data("fullTree", configTrees);
    }

    @ApiOperation(value="getCategory", notes="get category", response=Message.class)
    @RequestMapping(path={"/getCategory"}, method={RequestMethod.GET})
    public Message getCategory(HttpServletRequest req) {
        List<CategoryLabelVo> categoryLabelList = this.categoryService.getAllCategory(req.getHeader("Content-Language"));
        return Message.ok().data("Category", categoryLabelList);
    }

    @ApiOperation(value="getItemList", notes="get configuration list by engineType", response=Message.class)
    @RequestMapping(path={"/getItemList"}, method={RequestMethod.GET})
    public Message getItemList(HttpServletRequest req, @RequestParam(value="engineType") String engineType) throws ConfigurationException {
        ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)("getItemList with engineType:" + engineType));
        if ("*".equals(engineType)) {
            engineType = "";
        }
        List<ConfigKey> result = this.configKeyService.getConfigKeyList(engineType);
        ArrayList filterResult = new ArrayList();
        for (ConfigKey configKey : result) {
            HashMap<String, Object> temp = new HashMap<String, Object>();
            temp.put("key", configKey.getKey());
            temp.put("name", configKey.getName());
            temp.put("description", configKey.getDescription());
            temp.put("engineType", configKey.getEngineType());
            temp.put("validateType", configKey.getValidateType());
            temp.put("validateRange", configKey.getValidateRange());
            temp.put("boundaryType", configKey.getBoundaryType());
            temp.put("defaultValue", configKey.getDefaultValue());
            temp.put("require", configKey.getTemplateRequired());
            filterResult.add(temp);
        }
        return Message.ok().data("itemList", filterResult);
    }

    @ApiOperation(value="createFirstCategory", notes="create first category", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="categoryName", required=true, dataType="String"), @ApiImplicitParam(name="description", required=true, dataType="String")})
    @ApiOperationSupport(ignoreParameters={"jsonNode"})
    @RequestMapping(path={"/createFirstCategory"}, method={RequestMethod.POST})
    public Message createFirstCategory(HttpServletRequest request, @RequestBody JsonNode jsonNode) throws ConfigurationException {
        String username = ModuleUserUtils.getOperationUser((HttpServletRequest)request, (String)"createFirstCategory");
        this.checkAdmin(username);
        String categoryName = jsonNode.get("categoryName").asText();
        String description = jsonNode.get("description").asText();
        if (StringUtils.isEmpty((CharSequence)categoryName) || categoryName.equals(NULL)) {
            throw new ConfigurationException(LinkisConfigurationErrorCodeSummary.IS_NULL_CANNOT_BE_ADDED.getErrorDesc());
        }
        if (StringUtils.isEmpty((CharSequence)categoryName) || categoryName.contains("-")) {
            throw new ConfigurationException(LinkisConfigurationErrorCodeSummary.CANNOT_BE_INCLUDED.getErrorDesc());
        }
        this.categoryService.createFirstCategory(categoryName, description);
        return Message.ok();
    }

    @ApiOperation(value="deleteCategory", notes="delete category", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="categoryId", required=true, dataType="String", example="54")})
    @ApiOperationSupport(ignoreParameters={"jsonNode"})
    @RequestMapping(path={"/deleteCategory"}, method={RequestMethod.POST})
    public Message deleteCategory(HttpServletRequest request, @RequestBody JsonNode jsonNode) throws ConfigurationException {
        String username = ModuleUserUtils.getOperationUser((HttpServletRequest)request, (String)"deleteCategory");
        this.checkAdmin(username);
        Integer categoryId = jsonNode.get("categoryId").asInt();
        this.categoryService.deleteCategory(categoryId);
        return Message.ok();
    }

    @ApiOperation(value="createSecondCategory", notes="create second category", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="categoryId", required=true, dataType="String", example="39"), @ApiImplicitParam(name="engineType", required=true, dataType="String", example="hive"), @ApiImplicitParam(name="version", required=true, dataType="String", example="1.2.0"), @ApiImplicitParam(name="description", required=true, dataType="String")})
    @ApiOperationSupport(ignoreParameters={"jsonNode"})
    @RequestMapping(path={"/createSecondCategory"}, method={RequestMethod.POST})
    public Message createSecondCategory(HttpServletRequest request, @RequestBody JsonNode jsonNode) throws ConfigurationException {
        String username = ModuleUserUtils.getOperationUser((HttpServletRequest)request, (String)"createSecondCategory");
        this.checkAdmin(username);
        Integer categoryId = jsonNode.get("categoryId").asInt();
        String engineType = jsonNode.get("engineType").asText();
        String version = jsonNode.get("version").asText();
        String description = jsonNode.get("description").asText();
        if (categoryId <= 0) {
            throw new ConfigurationException(LinkisConfigurationErrorCodeSummary.CREATOR_IS_NULL_CANNOT_BE_ADDED.getErrorDesc());
        }
        if (StringUtils.isEmpty((CharSequence)engineType) || engineType.toLowerCase().equals(NULL)) {
            throw new ConfigurationException(LinkisConfigurationErrorCodeSummary.ENGINE_TYPE_IS_NULL.getErrorDesc());
        }
        if (StringUtils.isEmpty((CharSequence)version) || version.toLowerCase().equals(NULL)) {
            version = "*";
        }
        this.categoryService.createSecondCategory(categoryId, engineType, version, description);
        return Message.ok();
    }

    /*
     * WARNING - void declaration
     */
    @ApiOperation(value="saveFullTree", notes="save full tree", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="creator", required=true, dataType="String", example="xwzTest"), @ApiImplicitParam(name="engineType", required=true, dataType="String", example="hive"), @ApiImplicitParam(name="fullTree", required=true, dataType="List", value="full tree"), @ApiImplicitParam(name="name", required=true, dataType="String", value="name"), @ApiImplicitParam(name="description", required=true, dataType="String"), @ApiImplicitParam(name="settings", required=true, dataType="List", value="settings")})
    @ApiOperationSupport(ignoreParameters={"json"})
    @RequestMapping(path={"/saveFullTree"}, method={RequestMethod.POST})
    public Message saveFullTree(HttpServletRequest req, @RequestBody JsonNode json) throws IOException, ConfigurationException {
        List fullTrees = (List)this.mapper.treeToValue((TreeNode)json.get("fullTree"), List.class);
        String creator = JsonNodeUtil.getStringValue(json.get("creator"));
        String engineType = JsonNodeUtil.getStringValue(json.get("engineType"));
        if (creator != null && (creator.equals(org.apache.linkis.common.conf.Configuration.GLOBAL_CONF_CHN_NAME()) || creator.equals(org.apache.linkis.common.conf.Configuration.GLOBAL_CONF_CHN_OLDNAME()) || creator.equals(org.apache.linkis.common.conf.Configuration.GLOBAL_CONF_CHN_EN_NAME()))) {
            creator = "*";
        }
        String username = ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)"saveFullTree");
        ArrayList<ConfigValue> createList = new ArrayList<ConfigValue>();
        ArrayList<ConfigValue> updateList = new ArrayList<ConfigValue>();
        ArrayList<ArrayList<ConfigKeyValue>> chekList = new ArrayList<ArrayList<ConfigKeyValue>>();
        String sparkConf = "";
        for (Object e : fullTrees) {
            String s2 = BDPJettyServerHelper.gson().toJson(e);
            ConfigTree fullTree = (ConfigTree)BDPJettyServerHelper.gson().fromJson(s2, ConfigTree.class);
            ArrayList<ConfigKeyValue> settings = fullTree.getSettings();
            chekList.add(settings);
            for (ConfigKeyValue configKeyValue : settings) {
                if (!configKeyValue.getKey().equals("spark.conf") || !StringUtils.isNotBlank((CharSequence)configKeyValue.getConfigValue())) continue;
                sparkConf = configKeyValue.getConfigValue().trim();
                configKeyValue.setConfigValue(sparkConf);
            }
        }
        for (List list : chekList) {
            this.sparkConfCheck(list, sparkConf);
            Integer userLabelId = this.configurationService.checkAndCreateUserLabel(list, username, creator);
            for (ConfigKeyValue setting : list) {
                this.configurationService.updateUserValue(setting, userLabelId, createList, updateList);
            }
        }
        String engine = null;
        Object var12_15 = null;
        if (engineType != null) {
            String[] tmpString = engineType.split("-");
            if (tmpString.length != 2) {
                throw new ConfigurationException(LinkisConfigurationErrorCodeSummary.INCORRECT_FIXED_SUCH.getErrorDesc());
            }
            engine = tmpString[0];
            String string = tmpString[1];
        }
        this.configurationService.updateUserValue(createList, updateList);
        if (StringUtils.isNotBlank((CharSequence)creator) && creator.equals("*")) {
            List<CategoryLabelVo> allCategory = this.categoryService.getAllCategory(null);
            List categoryLabelVos = allCategory.stream().filter(s -> s.getCategoryName().equals(Configuration.REMOVE_APPLICATION_CACHE())).map(CategoryLabelVo::getChildCategory).findFirst().get();
            categoryLabelVos.stream().map(CategoryLabelVo::getCategoryName).filter(StringUtils::isNotBlank).forEach(info -> {
                String[] tmpString = info.split("-");
                if (tmpString.length == 2) {
                    String engineName = tmpString[0];
                    String engineVersion = tmpString[1];
                    logger.info("Config remove engine cache:engineName:{},engineVersion:{}", (Object)engineName, (Object)engineVersion);
                    this.configurationService.clearAMCacheConf(username, Configuration.REMOVE_APPLICATION_CACHE(), engineName, engineVersion);
                }
            });
            this.configurationService.clearAMCacheConf(username, creator, null, null);
        } else {
            void var12_17;
            this.configurationService.clearAMCacheConf(username, creator, engine, (String)var12_17);
        }
        return Message.ok();
    }

    private void sparkConfCheck(List<ConfigKeyValue> settings, String sparkConf) throws ConfigurationException {
        if (StringUtils.isNotBlank((CharSequence)sparkConf)) {
            String[] split = sparkConf.split(";");
            int setSize = Arrays.stream(split).map(s -> s.split("=")[0].trim()).collect(Collectors.toSet()).size();
            int listSize = Arrays.stream(split).map(s -> s.split("=")[0].trim()).collect(Collectors.toList()).size();
            if (listSize != setSize) {
                throw new ConfigurationException("Spark.conf contains duplicate keys");
            }
            for (String keyValue : split) {
                String key = keyValue.split("=")[0].trim();
                boolean matchResult = settings.stream().anyMatch(settingKey -> key.equals(settingKey.getKey()));
                if (!matchResult) continue;
                throw new ConfigurationException("Saved key is duplicated with the spark conf key , key :" + key);
            }
        }
    }

    @ApiOperation(value="listAllEngineType", notes="list all engine type", response=Message.class)
    @RequestMapping(path={"/engineType"}, method={RequestMethod.GET})
    public Message listAllEngineType(HttpServletRequest request) {
        String[] engineType = this.configurationService.listAllEngineType();
        return Message.ok().data("engineType", (Object)engineType);
    }

    @ApiOperation(value="updateCategoryInfo", notes="update category info", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="description", required=true, dataType="String"), @ApiImplicitParam(name="categoryId", required=true, dataType="String")})
    @ApiOperationSupport(ignoreParameters={"jsonNode"})
    @RequestMapping(path={"/updateCategoryInfo"}, method={RequestMethod.POST})
    public Message updateCategoryInfo(HttpServletRequest request, @RequestBody JsonNode jsonNode) throws ConfigurationException {
        String username = ModuleUserUtils.getOperationUser((HttpServletRequest)request, (String)"updateCategoryInfo");
        this.checkAdmin(username);
        String description = null;
        Integer categoryId = null;
        try {
            description = jsonNode.get("description").asText();
            categoryId = jsonNode.get("categoryId").asInt();
        }
        catch (Exception e) {
            throw new ConfigurationException(LinkisConfigurationErrorCodeSummary.INCOMPLETE_RECONFIRM.getErrorDesc());
        }
        if (description != null) {
            this.categoryService.updateCategory(categoryId, description);
        }
        return Message.ok();
    }

    @ApiOperation(value="rpcTest", notes="rpc test", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="creator", dataType="String", value="creator"), @ApiImplicitParam(name="engineType", dataType="String"), @ApiImplicitParam(name="username", dataType="String"), @ApiImplicitParam(name="version", required=false, dataType="String", value="version")})
    @RequestMapping(path={"/rpcTest"}, method={RequestMethod.GET})
    public Message rpcTest(@RequestParam(value="username", required=false) String username, @RequestParam(value="creator", required=false) String creator, @RequestParam(value="engineType", required=false) String engineType, @RequestParam(value="version", required=false) String version) {
        this.configurationService.queryGlobalConfig(username);
        EngineTypeLabel engineTypeLabel = new EngineTypeLabel();
        engineTypeLabel.setVersion(version);
        engineTypeLabel.setEngineType(engineType);
        this.configurationService.queryDefaultEngineConfig(engineTypeLabel);
        UserCreatorLabel userCreatorLabel = new UserCreatorLabel();
        userCreatorLabel.setCreator(creator);
        userCreatorLabel.setUser(username);
        this.configurationService.queryConfig(userCreatorLabel, engineTypeLabel, "wds.linkis.rm");
        Message message = Message.ok();
        return message;
    }

    private void checkAdmin(String userName) throws ConfigurationException {
        if (!org.apache.linkis.common.conf.Configuration.isAdmin((String)userName)) {
            throw new ConfigurationException(LinkisConfigurationErrorCodeSummary.ONLY_ADMIN_PERFORM.getErrorDesc());
        }
    }

    @ApiOperation(value="getKeyValue", notes="get key value", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="creator", required=false, dataType="String", value="creator"), @ApiImplicitParam(name="engineType", dataType="String"), @ApiImplicitParam(name="configKey", dataType="String"), @ApiImplicitParam(name="version", required=false, dataType="String", value="version")})
    @RequestMapping(path={"/keyvalue"}, method={RequestMethod.GET})
    public Message getKeyValue(HttpServletRequest req, @RequestParam(value="engineType", required=false, defaultValue="*") String engineType, @RequestParam(value="version", required=false, defaultValue="*") String version, @RequestParam(value="creator", required=false, defaultValue="*") String creator, @RequestParam(value="configKey") String configKey) throws ConfigurationException {
        String username = ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)"getKeyValue");
        if (engineType.equals("*") && !version.equals("*")) {
            return Message.error((String)"When engineType is any engine, the version must also be any version");
        }
        ArrayList<Label<?>> labelList = LabelEntityParser.generateUserCreatorEngineTypeLabelList(username, creator, engineType, version);
        List<ConfigValue> configValues = this.configKeyService.getConfigValue(configKey, labelList);
        Message message = Message.ok().data("configValues", configValues);
        if (configValues.size() > 1) {
            message.data("warnMessage", (Object)("There are multiple values for the corresponding Key\uff1a " + configKey));
        }
        return message;
    }

    @ApiOperation(value="saveKeyValue", notes="save key value", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="engineType", required=true, dataType="String"), @ApiImplicitParam(name="version", required=true, dataType="String", value="version"), @ApiImplicitParam(name="creator", required=true, dataType="String", value="creator"), @ApiImplicitParam(name="configKey", required=true, dataType="String"), @ApiImplicitParam(name="configValue", required=true, dataType="String"), @ApiImplicitParam(name="configKeyId", required=false, dataType="String")})
    @ApiOperationSupport(ignoreParameters={"json"})
    @RequestMapping(path={"/keyvalue"}, method={RequestMethod.POST})
    public Message saveKeyValue(HttpServletRequest req, @RequestBody Map<String, Object> json) throws ConfigurationException {
        Message message = Message.ok();
        String username = ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)"saveKey");
        String engineType = ((String)json.getOrDefault("engineType", "*")).trim();
        String user = ((String)json.getOrDefault("user", "")).trim();
        String version = ((String)json.getOrDefault("version", "*")).trim();
        String creator = ((String)json.getOrDefault("creator", "*")).trim();
        String configKey = ((String)json.get("configKey")).trim();
        String value = ((String)json.get("configValue")).trim();
        String configKeyId = ((String)json.getOrDefault("configKeyId", "")).trim();
        boolean force = Boolean.parseBoolean(json.getOrDefault("force", "false").toString());
        if (!org.apache.linkis.common.conf.Configuration.isAdmin((String)username) && !username.equals(user)) {
            return Message.error((String)"Only admin can modify other user configuration data");
        }
        if (engineType.equals("*") && !version.equals("*")) {
            return Message.error((String)"When engineType is any engine, the version must also be any version");
        }
        if (StringUtils.isBlank((CharSequence)configKey)) {
            return Message.error((String)"key cannot be empty");
        }
        if (StringUtils.isNotBlank((CharSequence)user)) {
            username = user;
        }
        ArrayList<Label<?>> labelList = LabelEntityParser.generateUserCreatorEngineTypeLabelList(username, creator, engineType, version);
        ConfigKeyValue configKeyValue = new ConfigKeyValue();
        configKeyValue.setKey(configKey);
        configKeyValue.setConfigValue(value);
        if (StringUtils.isNotBlank((CharSequence)configKeyId)) {
            configKeyValue.setId(Long.valueOf(configKeyId));
        }
        try {
            this.configurationService.paramCheck(configKeyValue);
        }
        catch (Exception e) {
            if (force && e instanceof ConfigurationException) {
                message.data("msg", (Object)("The update was successful, but the value verification failed. Please confirm if it has any impact\uff1a\uff08\u66f4\u65b0\u6210\u529f\uff0c\u4f46\u662f\u503c\u6821\u9a8c\u5931\u8d25\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u6709\u5f71\u54cd\uff09\n" + e.getMessage()));
            }
            return Message.error((String)e.getMessage());
        }
        ConfigValue configValue = this.configKeyService.saveConfigValue(configKeyValue, labelList);
        this.configurationService.clearAMCacheConf(username, creator, engineType, version);
        return message.data("configValue", (Object)configValue);
    }

    @ApiOperation(value="deleteKeyValue", notes="delete key value", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="engineType", required=true, dataType="String"), @ApiImplicitParam(name="version", required=true, dataType="String", value="version"), @ApiImplicitParam(name="creator", required=true, dataType="String", value="creator"), @ApiImplicitParam(name="configKey", required=true, dataType="String")})
    @ApiOperationSupport(ignoreParameters={"json"})
    @RequestMapping(path={"/keyvalue"}, method={RequestMethod.DELETE})
    public Message deleteKeyValue(HttpServletRequest req, @RequestBody Map<String, Object> json) throws ConfigurationException {
        String username = ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)"deleteKeyValue");
        String engineType = ((String)json.getOrDefault("engineType", "*")).trim();
        String version = ((String)json.getOrDefault("version", "*")).trim();
        String creator = ((String)json.getOrDefault("creator", "*")).trim();
        String configKey = ((String)json.get("configKey")).trim();
        if (engineType.equals("*") && !version.equals("*")) {
            return Message.error((String)"When engineType is any engine, the version must also be any version");
        }
        if (StringUtils.isBlank((CharSequence)configKey)) {
            return Message.error((String)"key cannot be empty");
        }
        ArrayList<Label<?>> labelList = LabelEntityParser.generateUserCreatorEngineTypeLabelList(username, creator, engineType, version);
        List<ConfigValue> configValues = this.configKeyService.deleteConfigValue(configKey, labelList);
        return Message.ok().data("configValues", configValues);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="getBaseKeyValue", notes="get key", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="engineType", required=false, dataType="String", value="engineType"), @ApiImplicitParam(name="key", required=false, dataType="String", value="key"), @ApiImplicitParam(name="pageNow", required=false, dataType="Integer", defaultValue="1"), @ApiImplicitParam(name="pageSize", required=false, dataType="Integer", defaultValue="20")})
    @RequestMapping(path={"/baseKeyValue"}, method={RequestMethod.GET})
    public Message getBaseKeyValue(HttpServletRequest req, @RequestParam(value="engineType", required=false) String engineType, @RequestParam(value="key", required=false) String key, @RequestParam(value="pageNow", required=false, defaultValue="1") Integer pageNow, @RequestParam(value="pageSize", required=false, defaultValue="20") Integer pageSize) throws ConfigurationException {
        this.checkAdmin(ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)"getBaseKeyValue"));
        if (StringUtils.isBlank((CharSequence)engineType)) {
            engineType = null;
        }
        if (StringUtils.isBlank((CharSequence)key)) {
            key = null;
        }
        PageHelper.startPage((int)pageNow, (int)pageSize);
        List<ConfigKey> list = null;
        try {
            list = this.configKeyService.getConfigBykey(engineType, key, req.getHeader("Content-Language"));
        }
        finally {
            PageHelper.clearPage();
        }
        PageInfo pageInfo = new PageInfo(list);
        long total = pageInfo.getTotal();
        return Message.ok().data("configKeyList", list).data("totalPage", (Object)total);
    }

    @ApiOperation(value="deleteBaseKeyValue", notes="delete key", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", required=true, dataType="Integer")})
    @RequestMapping(path={"/baseKeyValue"}, method={RequestMethod.DELETE})
    public Message deleteBaseKeyValue(HttpServletRequest req, @RequestParam(value="id") Integer id) throws ConfigurationException {
        this.checkAdmin(ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)("deleteBaseKeyValue  ID:" + id)));
        this.configKeyService.deleteConfigById(id);
        return Message.ok();
    }

    @ApiOperation(value="saveBaseKeyValue", notes="save key", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", required=false, dataType="Integer", value="id"), @ApiImplicitParam(name="key", required=true, dataType="String", value="key"), @ApiImplicitParam(name="name", required=true, dataType="String", value="name"), @ApiImplicitParam(name="description", required=true, dataType="String", value="description"), @ApiImplicitParam(name="defaultValue", required=true, dataType="String", value="defaultValue"), @ApiImplicitParam(name="validateType", required=true, dataType="String", value="validateType"), @ApiImplicitParam(name="validateRange", required=true, dataType="String", value="validateRange"), @ApiImplicitParam(name="boundaryType", required=true, dataType="String", value="boundaryType"), @ApiImplicitParam(name="treeName", required=true, dataType="String", value="treeName"), @ApiImplicitParam(name="engineType", required=true, dataType="String", value="engineType"), @ApiImplicitParam(name="enName", required=false, dataType="String", value="enName"), @ApiImplicitParam(name="enDescription", required=false, dataType="String", value="enDescription"), @ApiImplicitParam(name="enTreeName", required=false, dataType="String", value="enTreeName"), @ApiImplicitParam(name="templateRequired", required=false, dataType="String", value="1")})
    @ApiOperationSupport(ignoreParameters={"json"})
    @RequestMapping(path={"/baseKeyValue"}, method={RequestMethod.POST})
    public Message saveBaseKeyValue(HttpServletRequest req, @RequestBody ConfigKey configKey) throws ConfigurationException, InstantiationException, IllegalAccessException {
        this.checkAdmin(ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)"saveBaseKeyValue"));
        String key = configKey.getKey();
        String defaultValue = configKey.getDefaultValue();
        String validateType = configKey.getValidateType();
        String validateRange = configKey.getValidateRange();
        String engineType = configKey.getEngineType();
        if (StringUtils.isBlank((CharSequence)key)) {
            return Message.error((String)"key cannot be empty");
        }
        configKey.setKey(configKey.getKey().trim());
        if (StringUtils.isBlank((CharSequence)configKey.getName())) {
            return Message.error((String)"name cannot be empty");
        }
        if (StringUtils.isBlank((CharSequence)configKey.getDescription())) {
            return Message.error((String)"description cannot be empty");
        }
        if (StringUtils.isBlank((CharSequence)configKey.getTreeName())) {
            return Message.error((String)"treeName cannot be empty");
        }
        if (StringUtils.isBlank((CharSequence)validateType)) {
            return Message.error((String)"validateType cannot be empty");
        }
        if (!validateType.equals("None") && StringUtils.isBlank((CharSequence)validateRange)) {
            return Message.error((String)"validateRange cannot be empty");
        }
        if (null == configKey.getBoundaryType()) {
            return Message.error((String)"boundaryType cannot be empty");
        }
        if (StringUtils.isNotEmpty((CharSequence)defaultValue) && !this.validatorManager.getOrCreateValidator(validateType).validate(defaultValue, validateRange)) {
            String msg = MessageFormat.format("Parameter configValue verification failed(\u53c2\u6570defaultValue\u6821\u9a8c\u5931\u8d25):key:{0}, ValidateType:{1}, ValidateRange:{2},ConfigValue:{3}", key, validateType, validateRange, defaultValue);
            throw new ConfigurationException(msg);
        }
        configKey.setDefaultValue(configKey.getDefaultValue().trim());
        if (null == configKey.getId()) {
            List<ConfigKey> configBykey = this.configKeyService.getConfigBykey(engineType, key, req.getHeader("Content-Language"));
            if (CollectionUtils.isNotEmpty(configBykey)) {
                return Message.error((String)("The engine has the same key: " + key));
            }
            this.configKeyService.saveConfigKey(configKey);
        } else {
            configKey.setId(configKey.getId());
            this.configKeyService.updateConfigKey(configKey);
        }
        return Message.ok().data("configKey", (Object)configKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="getUserkeyvalue", notes="get key", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="engineType", required=false, dataType="String", value="engineType"), @ApiImplicitParam(name="key", required=false, dataType="String", value="key"), @ApiImplicitParam(name="creator", required=false, dataType="String", value="creator"), @ApiImplicitParam(name="user", required=false, dataType="String", value="user"), @ApiImplicitParam(name="pageNow", required=false, dataType="Integer", defaultValue="1"), @ApiImplicitParam(name="pageSize", required=false, dataType="Integer", defaultValue="20")})
    @RequestMapping(path={"/userKeyValue"}, method={RequestMethod.GET})
    public Message getUserKeyValue(HttpServletRequest req, @RequestParam(value="engineType", required=false) String engineType, @RequestParam(value="key", required=false) String key, @RequestParam(value="creator", required=false) String creator, @RequestParam(value="user", required=false) String user, @RequestParam(value="pageNow", required=false, defaultValue="1") Integer pageNow, @RequestParam(value="pageSize", required=false, defaultValue="20") Integer pageSize) throws ConfigurationException {
        List<ConfigUserValue> list;
        String username = ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)"getUserKeyValue");
        if (StringUtils.isBlank((CharSequence)engineType)) {
            engineType = null;
        }
        if (StringUtils.isBlank((CharSequence)key)) {
            key = null;
        }
        if (StringUtils.isBlank((CharSequence)creator)) {
            creator = null;
        }
        if (StringUtils.isBlank((CharSequence)user)) {
            user = null;
        }
        if (!org.apache.linkis.common.conf.Configuration.isAdmin((String)username) && !username.equals(user)) {
            return Message.error((String)"Only admin can query other user configuration data");
        }
        PageHelper.startPage((int)pageNow, (int)pageSize);
        try {
            list = this.configKeyService.getUserConfigValue(engineType, key, creator, user);
        }
        finally {
            PageHelper.clearPage();
        }
        PageInfo pageInfo = new PageInfo(list);
        long total = pageInfo.getTotal();
        return Message.ok().data("configValueList", list).data("totalPage", (Object)total);
    }
}

