/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.configuration.service.impl;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.configuration.dao.ConfigMapper;
import org.apache.linkis.configuration.dao.LabelMapper;
import org.apache.linkis.configuration.entity.ConfigKey;
import org.apache.linkis.configuration.entity.ConfigKeyValue;
import org.apache.linkis.configuration.entity.ConfigLabel;
import org.apache.linkis.configuration.entity.ConfigUserValue;
import org.apache.linkis.configuration.entity.ConfigValue;
import org.apache.linkis.configuration.errorcode.LinkisConfigurationErrorCodeSummary;
import org.apache.linkis.configuration.exception.ConfigurationException;
import org.apache.linkis.configuration.service.ConfigKeyService;
import org.apache.linkis.configuration.util.LabelEntityParser;
import org.apache.linkis.configuration.util.LabelParameterParser;
import org.apache.linkis.manager.label.builder.CombinedLabelBuilder;
import org.apache.linkis.manager.label.entity.CombinedLabel;
import org.apache.linkis.manager.label.entity.Label;
import org.apache.linkis.manager.label.entity.engine.EngineTypeLabel;
import org.apache.linkis.manager.label.exception.LabelErrorException;
import org.apache.linkis.manager.label.utils.LabelUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ConfigKeyServiceImpl
implements ConfigKeyService {
    private static final Logger logger = LoggerFactory.getLogger(ConfigKeyServiceImpl.class);
    @Autowired
    private ConfigMapper configMapper;
    @Autowired
    private LabelMapper labelMapper;
    private CombinedLabelBuilder combinedLabelBuilder = new CombinedLabelBuilder();

    @Override
    public ConfigValue saveConfigValue(ConfigKeyValue configKeyValue, List<Label<?>> labelList) throws ConfigurationException {
        if (StringUtils.isBlank((CharSequence)configKeyValue.getKey())) {
            throw new ConfigurationException(LinkisConfigurationErrorCodeSummary.KEY_CANNOT_EMPTY.getErrorDesc());
        }
        LabelParameterParser.labelCheck(labelList);
        List<ConfigKey> configKeys = this.configMapper.selectKeyByKeyName(configKeyValue.getKey());
        if (null == configKeys || configKeys.isEmpty()) {
            throw new ConfigurationException(MessageFormat.format(LinkisConfigurationErrorCodeSummary.CONFIG_KEY_NOT_EXISTS.getErrorDesc(), configKeyValue.getKey()));
        }
        ConfigKey configKey = configKeys.get(0);
        EngineTypeLabel engineTypeLabel = LabelUtil.getEngineTypeLabel(labelList);
        for (ConfigKey key : configKeys) {
            if (!engineTypeLabel.getEngineType().equalsIgnoreCase(key.getEngineType())) continue;
            logger.info("config key:{} will be use engineType {}", (Object)key.getKey(), (Object)key.getEngineType());
            configKey = key;
        }
        CombinedLabel combinedLabel = this.getCombinedLabel(labelList);
        ConfigLabel configLabel = this.labelMapper.getLabelByKeyValue(combinedLabel.getLabelKey(), combinedLabel.getStringValue());
        if (null == configLabel || configLabel.getId() < 0) {
            configLabel = LabelEntityParser.parseToConfigLabel(combinedLabel);
            this.labelMapper.insertLabel(configLabel);
            logger.info("succeed to create label: {}", (Object)configLabel.getStringValue());
        }
        List<ConfigValue> configValues = this.getConfigValue(configKeyValue.getKey(), labelList);
        ConfigValue configValue = null;
        if (configValues.size() > 1) {
            throw new ConfigurationException(combinedLabel.getStringValue() + "There are multiple values for the corresponding Key\uff1a " + configKeyValue.getKey());
        }
        if (configValues.size() == 1) {
            configValue = configValues.get(0);
            configValue.setConfigValue(configKeyValue.getConfigValue());
        } else {
            configValue = new ConfigValue();
            configValue.setConfigKeyId(configKey.getId());
            configValue.setConfigValue(configKeyValue.getConfigValue());
            configValue.setConfigLabelId(configLabel.getId());
        }
        this.configMapper.insertValue(configValue);
        logger.info("succeed to save key: {} by label: {} value: {} ", new Object[]{configKeyValue.getKey(), combinedLabel.getStringValue(), configKeyValue.getConfigValue()});
        return configValue;
    }

    private CombinedLabel getCombinedLabel(List<Label<?>> labelList) throws ConfigurationException {
        CombinedLabel combinedLabel = null;
        try {
            combinedLabel = (CombinedLabel)this.combinedLabelBuilder.build("", labelList);
        }
        catch (LabelErrorException e) {
            throw new ConfigurationException(LinkisConfigurationErrorCodeSummary.FAILED_TO_BUILD_LABEL.getErrorDesc(), e);
        }
        if (null == combinedLabel) {
            throw new ConfigurationException(LinkisConfigurationErrorCodeSummary.BUILD_LABEL_IS_NULL.getErrorDesc());
        }
        return combinedLabel;
    }

    @Override
    public List<ConfigValue> getConfigValue(String key, List<Label<?>> labelList) throws ConfigurationException {
        if (StringUtils.isBlank((CharSequence)key)) {
            throw new ConfigurationException(LinkisConfigurationErrorCodeSummary.CONFIGKEY_CANNOT_BE_NULL.getErrorDesc());
        }
        LabelParameterParser.labelCheck(labelList);
        List<ConfigKey> configKeys = this.configMapper.selectKeyByKeyName(key);
        if (null == configKeys || configKeys.isEmpty()) {
            throw new ConfigurationException(MessageFormat.format(LinkisConfigurationErrorCodeSummary.CONFIG_KEY_NOT_EXISTS.getErrorDesc(), key));
        }
        CombinedLabel combinedLabel = this.getCombinedLabel(labelList);
        ConfigLabel configLabel = this.labelMapper.getLabelByKeyValue(combinedLabel.getLabelKey(), combinedLabel.getStringValue());
        if (null == configLabel || configLabel.getId() < 0) {
            throw new ConfigurationException(MessageFormat.format(LinkisConfigurationErrorCodeSummary.LABEL_NOT_EXISTS.getErrorDesc(), combinedLabel.getStringValue()));
        }
        ArrayList<ConfigValue> configValues = new ArrayList<ConfigValue>();
        for (ConfigKey configKey : configKeys) {
            ConfigValue configValue = new ConfigValue();
            configValue.setConfigKeyId(configKey.getId());
            configValue.setConfigLabelId(configLabel.getId());
            ConfigValue configValueByKeyAndLabel = this.configMapper.getConfigValueByKeyAndLabel(configValue);
            if (null == configValueByKeyAndLabel) continue;
            configValues.add(configValueByKeyAndLabel);
        }
        return configValues;
    }

    @Override
    public List<ConfigKey> getConfigKeyList(String engineType) throws ConfigurationException {
        return this.configMapper.selectKeyByEngineType(engineType);
    }

    @Override
    public List<ConfigValue> deleteConfigValue(String key, List<Label<?>> labelList) throws ConfigurationException {
        CombinedLabel combinedLabel = this.getCombinedLabel(labelList);
        List<ConfigValue> configValues = this.getConfigValue(key, labelList);
        for (ConfigValue configValue : configValues) {
            this.configMapper.deleteConfigKeyValue(configValue);
        }
        logger.info("succeed to remove key: {} by label:{} ", (Object)key, (Object)combinedLabel.getStringValue());
        return configValues;
    }

    @Override
    public List<ConfigKey> getConfigBykey(String engineType, String key, String language) {
        List<ConfigKey> configkeyList = "en".equals(language) ? this.configMapper.getConfigEnBykey(engineType, key) : this.configMapper.getConfigBykey(engineType, key);
        return configkeyList;
    }

    @Override
    public void deleteConfigById(Integer id) {
        this.configMapper.deleteConfigKey(id);
    }

    @Override
    public ConfigKey saveConfigKey(ConfigKey configKey) {
        this.configMapper.insertKeyByBase(configKey);
        return null;
    }

    @Override
    public List<ConfigUserValue> getUserConfigValue(String engineType, String key, String creator, String user) {
        return this.configMapper.getUserConfigValue(key, user, creator, engineType);
    }

    @Override
    public void updateConfigKey(ConfigKey configKey) {
        this.configMapper.updateConfigKey(configKey);
    }
}

