/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import java.util.Arrays;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.StructColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.metadata.HiveException;

public class VectorUDFStructField
extends VectorExpression {
    private int structColumnNum;
    private int fieldIndex;

    public VectorUDFStructField() {
    }

    public VectorUDFStructField(int structColumnNum, int fieldIndex, int outputColumnNum) {
        super(outputColumnNum);
        this.structColumnNum = structColumnNum;
        this.fieldIndex = fieldIndex;
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) throws HiveException {
        int n = batch.size;
        if (n == 0) {
            return;
        }
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        ColumnVector outV = batch.cols[this.outputColumnNum];
        int[] sel = batch.selected;
        StructColumnVector structColumnVector = (StructColumnVector)batch.cols[this.structColumnNum];
        ColumnVector fieldColumnVector = structColumnVector.fields[this.fieldIndex];
        boolean[] inputIsNull = structColumnVector.isNull;
        boolean[] outputIsNull = outV.isNull;
        outV.isRepeating = false;
        if (structColumnVector.isRepeating) {
            if (structColumnVector.noNulls || !structColumnVector.isNull[0]) {
                outputIsNull[0] = false;
                outV.setElement(0, 0, fieldColumnVector);
            } else {
                outputIsNull[0] = true;
                outV.noNulls = false;
            }
            outV.isRepeating = true;
            return;
        }
        if (structColumnVector.noNulls) {
            if (batch.selectedInUse) {
                if (!outV.noNulls) {
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        outputIsNull[i] = false;
                        outV.setElement(i, i, fieldColumnVector);
                    }
                } else {
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        outV.setElement(i, i, fieldColumnVector);
                    }
                }
            } else {
                if (!outV.noNulls) {
                    Arrays.fill(outputIsNull, false);
                    outV.noNulls = true;
                }
                for (int i = 0; i != n; ++i) {
                    outV.setElement(i, i, fieldColumnVector);
                }
            }
        } else if (batch.selectedInUse) {
            for (int j = 0; j != n; ++j) {
                int i = sel[j];
                if (!inputIsNull[i]) {
                    outputIsNull[i] = false;
                    outV.setElement(i, i, fieldColumnVector);
                    continue;
                }
                outputIsNull[i] = true;
                outV.noNulls = false;
            }
        } else {
            for (int i = 0; i != n; ++i) {
                if (!inputIsNull[i]) {
                    outputIsNull[i] = false;
                    outV.setElement(i, i, fieldColumnVector);
                    continue;
                }
                outputIsNull[i] = true;
                outV.noNulls = false;
            }
        }
    }

    @Override
    public String vectorExpressionParameters() {
        return this.getColumnParamString(0, this.structColumnNum) + ", " + this.getColumnParamString(1, this.fieldIndex);
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return new VectorExpressionDescriptor.Builder().setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(2).setArgumentTypes(VectorExpressionDescriptor.ArgumentType.STRUCT, VectorExpressionDescriptor.ArgumentType.INT_FAMILY).setInputExpressionTypes(VectorExpressionDescriptor.InputExpressionType.COLUMN, VectorExpressionDescriptor.InputExpressionType.SCALAR).build();
    }
}

