/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import java.util.HashMap;
import org.antlr.runtime.tree.Tree;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.CalcitePlanner;
import org.apache.hadoop.hive.ql.parse.ColumnStatsSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.DDLSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ExplainSQRewriteSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ExplainSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ExportSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.FunctionSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ImportSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.LoadSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.MacroSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.MaterializedViewRebuildSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ReplicationSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.UpdateDeleteSemanticAnalyzer;
import org.apache.hadoop.hive.ql.plan.HiveOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SemanticAnalyzerFactory {
    private static final Logger LOG = LoggerFactory.getLogger(SemanticAnalyzerFactory.class);
    static HashMap<Integer, HiveOperation> commandType = new HashMap();
    static HashMap<Integer, HiveOperation[]> tablePartitionCommandType = new HashMap();

    public static BaseSemanticAnalyzer get(QueryState queryState, ASTNode tree) throws SemanticException {
        BaseSemanticAnalyzer sem = SemanticAnalyzerFactory.getInternal(queryState, tree);
        if (queryState.getHiveOperation() == null) {
            String query = queryState.getQueryString();
            if (query != null && query.length() > 30) {
                query = query.substring(0, 30);
            }
            String msg = "Unknown HiveOperation for query='" + query + "' queryId=" + queryState.getQueryId();
            LOG.debug(msg);
        }
        return sem;
    }

    private static BaseSemanticAnalyzer getInternal(QueryState queryState, ASTNode tree) throws SemanticException {
        if (tree.getToken() == null) {
            throw new RuntimeException("Empty Syntax Tree");
        }
        HiveOperation opType = commandType.get(tree.getType());
        queryState.setCommandType(opType);
        switch (tree.getType()) {
            case 830: {
                return new ExplainSemanticAnalyzer(queryState);
            }
            case 831: {
                return new ExplainSQRewriteSemanticAnalyzer(queryState);
            }
            case 888: {
                return new LoadSemanticAnalyzer(queryState);
            }
            case 833: {
                if (UpdateDeleteSemanticAnalyzer.isAcidExport(tree)) {
                    return new UpdateDeleteSemanticAnalyzer(queryState);
                }
                return new ExportSemanticAnalyzer(queryState);
            }
            case 857: {
                return new ImportSemanticAnalyzer(queryState);
            }
            case 966: {
                return new ReplicationSemanticAnalyzer(queryState);
            }
            case 967: {
                return new ReplicationSemanticAnalyzer(queryState);
            }
            case 968: {
                return new ReplicationSemanticAnalyzer(queryState);
            }
            case 718: {
                Tree child = tree.getChild(1);
                switch (child.getType()) {
                    case 719: 
                    case 720: 
                    case 721: 
                    case 722: 
                    case 727: 
                    case 728: 
                    case 729: 
                    case 730: 
                    case 734: 
                    case 735: 
                    case 736: 
                    case 737: 
                    case 738: 
                    case 740: 
                    case 743: 
                    case 745: 
                    case 746: 
                    case 748: {
                        queryState.setCommandType(commandType.get(child.getType()));
                        return new DDLSemanticAnalyzer(queryState);
                    }
                }
                opType = tablePartitionCommandType.get(child.getType())[tree.getChildCount() > 2 ? 1 : 0];
                queryState.setCommandType(opType);
                return new DDLSemanticAnalyzer(queryState);
            }
            case 750: {
                Tree child = tree.getChild(1);
                switch (child.getType()) {
                    case 751: 
                    case 752: 
                    case 753: 
                    case 754: 
                    case 755: {
                        opType = commandType.get(child.getType());
                        queryState.setCommandType(opType);
                        return new DDLSemanticAnalyzer(queryState);
                    }
                }
                assert (child.getType() == 954);
                queryState.setCommandType(HiveOperation.ALTERVIEW_AS);
                return new SemanticAnalyzer(queryState);
            }
            case 757: {
                Tree child = tree.getChild(1);
                switch (child.getType()) {
                    case 759: {
                        opType = commandType.get(child.getType());
                        queryState.setCommandType(opType);
                        return new DDLSemanticAnalyzer(queryState);
                    }
                    case 758: {
                        opType = commandType.get(child.getType());
                        queryState.setCommandType(opType);
                        return new MaterializedViewRebuildSemanticAnalyzer(queryState);
                    }
                }
                queryState.setCommandType(null);
                return new DDLSemanticAnalyzer(queryState);
            }
            case 708: 
            case 715: 
            case 716: 
            case 717: 
            case 725: 
            case 756: 
            case 760: 
            case 761: 
            case 762: 
            case 769: 
            case 779: 
            case 782: 
            case 785: 
            case 787: 
            case 788: 
            case 789: 
            case 807: 
            case 808: 
            case 809: 
            case 816: 
            case 819: 
            case 820: 
            case 821: 
            case 822: 
            case 823: 
            case 824: 
            case 825: 
            case 826: 
            case 845: 
            case 847: 
            case 878: 
            case 889: 
            case 890: 
            case 895: 
            case 973: 
            case 974: 
            case 993: 
            case 994: 
            case 995: 
            case 996: 
            case 997: 
            case 998: 
            case 999: 
            case 1000: 
            case 1001: 
            case 1002: 
            case 1003: 
            case 1004: 
            case 1005: 
            case 1006: 
            case 1007: 
            case 1008: 
            case 1009: 
            case 1010: 
            case 1011: 
            case 1012: 
            case 1013: 
            case 1014: 
            case 1032: 
            case 1078: 
            case 1087: 
            case 1088: {
                return new DDLSemanticAnalyzer(queryState);
            }
            case 780: 
            case 817: 
            case 959: {
                return new FunctionSemanticAnalyzer(queryState);
            }
            case 763: {
                return new ColumnStatsSemanticAnalyzer(queryState);
            }
            case 781: 
            case 818: {
                return new MacroSemanticAnalyzer(queryState);
            }
            case 806: 
            case 893: 
            case 1091: {
                return new UpdateDeleteSemanticAnalyzer(queryState);
            }
        }
        SemanticAnalyzer semAnalyzer = HiveConf.getBoolVar(queryState.getConf(), HiveConf.ConfVars.HIVE_CBO_ENABLED) ? new CalcitePlanner(queryState) : new SemanticAnalyzer(queryState);
        return semAnalyzer;
    }

    private SemanticAnalyzerFactory() {
    }

    static HiveOperation getOperation(int hiveParserToken) {
        return commandType.get(hiveParserToken);
    }

    static {
        commandType.put(830, HiveOperation.EXPLAIN);
        commandType.put(888, HiveOperation.LOAD);
        commandType.put(833, HiveOperation.EXPORT);
        commandType.put(857, HiveOperation.IMPORT);
        commandType.put(779, HiveOperation.CREATEDATABASE);
        commandType.put(816, HiveOperation.DROPDATABASE);
        commandType.put(1032, HiveOperation.SWITCHDATABASE);
        commandType.put(783, HiveOperation.CREATETABLE);
        commandType.put(1078, HiveOperation.TRUNCATETABLE);
        commandType.put(820, HiveOperation.DROPTABLE);
        commandType.put(809, HiveOperation.DESCTABLE);
        commandType.put(808, HiveOperation.DESCFUNCTION);
        commandType.put(895, HiveOperation.MSCK);
        commandType.put(719, HiveOperation.ALTERTABLE_ADDCOLS);
        commandType.put(740, HiveOperation.ALTERTABLE_REPLACECOLS);
        commandType.put(738, HiveOperation.ALTERTABLE_RENAMECOL);
        commandType.put(737, HiveOperation.ALTERTABLE_RENAME);
        commandType.put(728, HiveOperation.ALTERTABLE_DROPPARTS);
        commandType.put(721, HiveOperation.ALTERTABLE_ADDPARTS);
        commandType.put(745, HiveOperation.ALTERTABLE_TOUCH);
        commandType.put(722, HiveOperation.ALTERTABLE_ARCHIVE);
        commandType.put(746, HiveOperation.ALTERTABLE_UNARCHIVE);
        commandType.put(736, HiveOperation.ALTERTABLE_PROPERTIES);
        commandType.put(729, HiveOperation.ALTERTABLE_PROPERTIES);
        commandType.put(730, HiveOperation.ALTERTABLE_EXCHANGEPARTITION);
        commandType.put(727, HiveOperation.ALTERTABLE_DROPCONSTRAINT);
        commandType.put(720, HiveOperation.ALTERTABLE_ADDCONSTRAINT);
        commandType.put(748, HiveOperation.ALTERTABLE_UPDATECOLUMNS);
        commandType.put(995, HiveOperation.SHOWDATABASES);
        commandType.put(1001, HiveOperation.SHOWTABLES);
        commandType.put(993, HiveOperation.SHOWCOLUMNS);
        commandType.put(1012, HiveOperation.SHOW_TABLESTATUS);
        commandType.put(1013, HiveOperation.SHOW_TBLPROPERTIES);
        commandType.put(1004, HiveOperation.SHOW_CREATEDATABASE);
        commandType.put(1005, HiveOperation.SHOW_CREATETABLE);
        commandType.put(997, HiveOperation.SHOWFUNCTIONS);
        commandType.put(1000, HiveOperation.SHOWPARTITIONS);
        commandType.put(998, HiveOperation.SHOWLOCKS);
        commandType.put(996, HiveOperation.SHOWLOCKS);
        commandType.put(994, HiveOperation.SHOWCONF);
        commandType.put(1002, HiveOperation.SHOWVIEWS);
        commandType.put(999, HiveOperation.SHOWMATERIALIZEDVIEWS);
        commandType.put(780, HiveOperation.CREATEFUNCTION);
        commandType.put(817, HiveOperation.DROPFUNCTION);
        commandType.put(959, HiveOperation.RELOADFUNCTION);
        commandType.put(781, HiveOperation.CREATEMACRO);
        commandType.put(818, HiveOperation.DROPMACRO);
        commandType.put(784, HiveOperation.CREATEVIEW);
        commandType.put(786, HiveOperation.CREATE_MATERIALIZED_VIEW);
        commandType.put(821, HiveOperation.DROPVIEW);
        commandType.put(823, HiveOperation.DROP_MATERIALIZED_VIEW);
        commandType.put(754, HiveOperation.ALTERVIEW_PROPERTIES);
        commandType.put(753, HiveOperation.ALTERVIEW_PROPERTIES);
        commandType.put(751, HiveOperation.ALTERTABLE_ADDPARTS);
        commandType.put(752, HiveOperation.ALTERTABLE_DROPPARTS);
        commandType.put(734, HiveOperation.ALTERTABLE_OWNER);
        commandType.put(755, HiveOperation.ALTERVIEW_RENAME);
        commandType.put(750, HiveOperation.ALTERVIEW_AS);
        commandType.put(759, HiveOperation.ALTER_MATERIALIZED_VIEW_REWRITE);
        commandType.put(954, HiveOperation.QUERY);
        commandType.put(890, HiveOperation.LOCKTABLE);
        commandType.put(1088, HiveOperation.UNLOCKTABLE);
        commandType.put(889, HiveOperation.LOCKDB);
        commandType.put(1087, HiveOperation.UNLOCKDB);
        commandType.put(782, HiveOperation.CREATEROLE);
        commandType.put(819, HiveOperation.DROPROLE);
        commandType.put(845, HiveOperation.GRANT_PRIVILEGE);
        commandType.put(973, HiveOperation.REVOKE_PRIVILEGE);
        commandType.put(1006, HiveOperation.SHOW_GRANT);
        commandType.put(847, HiveOperation.GRANT_ROLE);
        commandType.put(974, HiveOperation.REVOKE_ROLE);
        commandType.put(1007, HiveOperation.SHOW_ROLES);
        commandType.put(1011, HiveOperation.SHOW_ROLES);
        commandType.put(1009, HiveOperation.SHOW_ROLE_PRINCIPALS);
        commandType.put(1008, HiveOperation.SHOW_ROLE_GRANT);
        commandType.put(717, HiveOperation.ALTERDATABASE);
        commandType.put(716, HiveOperation.ALTERDATABASE_OWNER);
        commandType.put(715, HiveOperation.ALTERDATABASE_LOCATION);
        commandType.put(807, HiveOperation.DESCDATABASE);
        commandType.put(743, HiveOperation.ALTERTABLE_SKEWED);
        commandType.put(763, HiveOperation.ANALYZE_TABLE);
        commandType.put(769, HiveOperation.CACHE_METADATA);
        commandType.put(735, HiveOperation.ALTERTABLE_PARTCOLTYPE);
        commandType.put(1003, HiveOperation.SHOW_COMPACTIONS);
        commandType.put(1014, HiveOperation.SHOW_TRANSACTIONS);
        commandType.put(708, HiveOperation.ABORT_TRANSACTIONS);
        commandType.put(1020, HiveOperation.START_TRANSACTION);
        commandType.put(777, HiveOperation.COMMIT);
        commandType.put(979, HiveOperation.ROLLBACK);
        commandType.put(991, HiveOperation.SET_AUTOCOMMIT);
        commandType.put(966, HiveOperation.REPLDUMP);
        commandType.put(967, HiveOperation.REPLLOAD);
        commandType.put(968, HiveOperation.REPLSTATUS);
        commandType.put(878, HiveOperation.KILL_QUERY);
        commandType.put(788, HiveOperation.CREATE_RESOURCEPLAN);
        commandType.put(1010, HiveOperation.SHOW_RESOURCEPLAN);
        commandType.put(761, HiveOperation.ALTER_RESOURCEPLAN);
        commandType.put(825, HiveOperation.DROP_RESOURCEPLAN);
        commandType.put(789, HiveOperation.CREATE_TRIGGER);
        commandType.put(762, HiveOperation.ALTER_TRIGGER);
        commandType.put(826, HiveOperation.DROP_TRIGGER);
        commandType.put(787, HiveOperation.CREATE_POOL);
        commandType.put(760, HiveOperation.ALTER_POOL);
        commandType.put(824, HiveOperation.DROP_POOL);
        commandType.put(785, HiveOperation.CREATE_MAPPING);
        commandType.put(756, HiveOperation.ALTER_MAPPING);
        commandType.put(822, HiveOperation.DROP_MAPPING);
        tablePartitionCommandType.put(731, new HiveOperation[]{HiveOperation.ALTERTABLE_FILEFORMAT, HiveOperation.ALTERPARTITION_FILEFORMAT});
        tablePartitionCommandType.put(732, new HiveOperation[]{HiveOperation.ALTERTABLE_LOCATION, HiveOperation.ALTERPARTITION_LOCATION});
        tablePartitionCommandType.put(733, new HiveOperation[]{HiveOperation.ALTERTABLE_MERGEFILES, HiveOperation.ALTERPARTITION_MERGEFILES});
        tablePartitionCommandType.put(742, new HiveOperation[]{HiveOperation.ALTERTABLE_SERIALIZER, HiveOperation.ALTERPARTITION_SERIALIZER});
        tablePartitionCommandType.put(741, new HiveOperation[]{HiveOperation.ALTERTABLE_SERDEPROPERTIES, HiveOperation.ALTERPARTITION_SERDEPROPERTIES});
        tablePartitionCommandType.put(739, new HiveOperation[]{null, HiveOperation.ALTERTABLE_RENAMEPART});
        tablePartitionCommandType.put(726, new HiveOperation[]{HiveOperation.ALTERTABLE_COMPACT, HiveOperation.ALTERTABLE_COMPACT});
        tablePartitionCommandType.put(744, new HiveOperation[]{HiveOperation.ALTERTBLPART_SKEWED_LOCATION, HiveOperation.ALTERTBLPART_SKEWED_LOCATION});
        tablePartitionCommandType.put(723, new HiveOperation[]{HiveOperation.ALTERTABLE_BUCKETNUM, HiveOperation.ALTERPARTITION_BUCKETNUM});
        tablePartitionCommandType.put(725, new HiveOperation[]{HiveOperation.ALTERTABLE_CLUSTER_SORT, HiveOperation.ALTERTABLE_CLUSTER_SORT});
        tablePartitionCommandType.put(747, new HiveOperation[]{HiveOperation.ALTERTABLE_UPDATETABLESTATS, HiveOperation.ALTERTABLE_UPDATEPARTSTATS});
        tablePartitionCommandType.put(749, new HiveOperation[]{HiveOperation.ALTERTABLE_UPDATETABLESTATS, HiveOperation.ALTERTABLE_UPDATEPARTSTATS});
    }
}

