/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.spark.client.rpc;

import com.google.common.base.Throwables;
import com.google.common.collect.Maps;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.util.concurrent.Promise;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.hadoop.hive.common.classification.InterfaceAudience;
import org.apache.hive.spark.client.rpc.Rpc;
import org.apache.hive.spark.client.rpc.RpcException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public abstract class RpcDispatcher
extends SimpleChannelInboundHandler<Object> {
    private static final Logger LOG = LoggerFactory.getLogger(RpcDispatcher.class);
    private final Map<Class<?>, Method> handlers = Maps.newConcurrentMap();
    private final Collection<OutstandingRpc> rpcs = new ConcurrentLinkedQueue<OutstandingRpc>();
    private volatile Rpc.MessageHeader lastHeader;

    protected String name() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final void channelRead0(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (this.lastHeader == null) {
            if (!(msg instanceof Rpc.MessageHeader)) {
                LOG.warn("[{}] Expected RPC header, got {} instead.", (Object)this.name(), msg != null ? msg.getClass().getName() : null);
                throw new IllegalArgumentException();
            }
            this.lastHeader = (Rpc.MessageHeader)msg;
            return;
        }
        LOG.debug("[{}] Received RPC message: type={} id={} payload={}", new Object[]{this.name(), this.lastHeader.type, this.lastHeader.id, msg != null ? msg.getClass().getName() : null});
        try {
            switch (this.lastHeader.type) {
                case CALL: {
                    this.handleCall(ctx, msg);
                    return;
                }
                case REPLY: {
                    this.handleReply(ctx, msg, this.findRpc(this.lastHeader.id));
                    return;
                }
                case ERROR: {
                    this.handleError(ctx, msg, this.findRpc(this.lastHeader.id));
                    return;
                }
                default: {
                    throw new IllegalArgumentException("Unknown RPC message type: " + (Object)((Object)this.lastHeader.type));
                }
            }
        }
        finally {
            this.lastHeader = null;
        }
    }

    private OutstandingRpc findRpc(long id) {
        Iterator<OutstandingRpc> it = this.rpcs.iterator();
        while (it.hasNext()) {
            OutstandingRpc rpc = it.next();
            if (rpc.id != id) continue;
            it.remove();
            return rpc;
        }
        throw new IllegalArgumentException(String.format("Received RPC reply for unknown RPC (%d).", id));
    }

    private void handleCall(ChannelHandlerContext ctx, Object msg) throws Exception {
        Rpc.MessageType replyType;
        Object replyPayload;
        Method handler = this.handlers.get(msg.getClass());
        if (handler == null) {
            handler = ((Object)((Object)this)).getClass().getDeclaredMethod("handle", ChannelHandlerContext.class, msg.getClass());
            handler.setAccessible(true);
            this.handlers.put(msg.getClass(), handler);
        }
        try {
            replyPayload = handler.invoke((Object)this, ctx, msg);
            if (replyPayload == null) {
                replyPayload = new Rpc.NullMessage();
            }
            replyType = Rpc.MessageType.REPLY;
        }
        catch (InvocationTargetException ite) {
            LOG.debug(String.format("[%s] Error in RPC handler.", this.name()), ite.getCause());
            replyPayload = Throwables.getStackTraceAsString(ite.getCause());
            replyType = Rpc.MessageType.ERROR;
        }
        ctx.channel().write((Object)new Rpc.MessageHeader(this.lastHeader.id, replyType));
        ctx.channel().writeAndFlush(replyPayload);
    }

    private void handleReply(ChannelHandlerContext ctx, Object msg, OutstandingRpc rpc) throws Exception {
        rpc.future.setSuccess(msg instanceof Rpc.NullMessage ? null : msg);
    }

    private void handleError(ChannelHandlerContext ctx, Object msg, OutstandingRpc rpc) throws Exception {
        if (msg instanceof String) {
            LOG.warn("Received error message:{}.", msg);
            rpc.future.setFailure((Throwable)new RpcException((String)msg));
        } else {
            String error = String.format("Received error with unexpected payload (%s).", msg != null ? msg.getClass().getName() : null);
            LOG.warn(String.format("[%s] %s", this.name(), error));
            rpc.future.setFailure((Throwable)new IllegalArgumentException(error));
            ctx.close();
        }
    }

    public final void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        LOG.error(String.format("[%s] Closing channel due to exception in pipeline.", this.name()), cause);
        if (this.lastHeader != null) {
            ctx.channel().write((Object)new Rpc.MessageHeader(this.lastHeader.id, Rpc.MessageType.ERROR));
            ctx.channel().writeAndFlush((Object)Throwables.getStackTraceAsString(cause));
            this.lastHeader = null;
        }
        ctx.close();
    }

    public final void channelInactive(ChannelHandlerContext ctx) throws Exception {
        if (this.rpcs.size() > 0) {
            LOG.warn("[{}] Closing RPC channel with {} outstanding RPCs.", (Object)this.name(), (Object)this.rpcs.size());
            for (OutstandingRpc rpc : this.rpcs) {
                rpc.future.cancel(true);
            }
        }
        super.channelInactive(ctx);
    }

    void registerRpc(long id, Promise promise, String type) {
        LOG.debug("[{}] Registered outstanding rpc {} ({}).", new Object[]{this.name(), id, type});
        this.rpcs.add(new OutstandingRpc(id, promise));
    }

    void discardRpc(long id) {
        LOG.debug("[{}] Discarding failed RPC {}.", (Object)this.name(), (Object)id);
        this.findRpc(id);
    }

    private static class OutstandingRpc {
        final long id;
        final Promise future;

        OutstandingRpc(long id, Promise future) {
            this.id = id;
            this.future = future;
        }
    }
}

