/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.basedatamanager.server.service.impl;

import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.linkis.basedatamanager.server.dao.CgManagerLabelMapper;
import org.apache.linkis.basedatamanager.server.dao.ConfigurationConfigKeyMapper;
import org.apache.linkis.basedatamanager.server.dao.ConfigurationConfigValueMapper;
import org.apache.linkis.basedatamanager.server.dao.ConfigurationKeyEngineRelationMapper;
import org.apache.linkis.basedatamanager.server.dao.EngineConnPluginBmlResourcesMapper;
import org.apache.linkis.basedatamanager.server.domain.CgManagerLabel;
import org.apache.linkis.basedatamanager.server.domain.ConfigurationConfigKey;
import org.apache.linkis.basedatamanager.server.domain.ConfigurationConfigValue;
import org.apache.linkis.basedatamanager.server.domain.ConfigurationKeyEngineRelation;
import org.apache.linkis.basedatamanager.server.request.ConfigurationTemplateSaveRequest;
import org.apache.linkis.basedatamanager.server.response.EngineLabelResponse;
import org.apache.linkis.basedatamanager.server.service.ConfigurationTemplateService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class ConfigurationTemplateServiceImpl
implements ConfigurationTemplateService {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigurationTemplateService.class);
    @Resource
    ConfigurationConfigKeyMapper configKeyMapper;
    @Resource
    ConfigurationKeyEngineRelationMapper relationMapper;
    @Resource
    CgManagerLabelMapper managerLabelMapper;
    @Resource
    ConfigurationConfigValueMapper configValueMapper;
    @Resource
    EngineConnPluginBmlResourcesMapper engineConnPluginBmlResourcesMapper;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Boolean saveConfigurationTemplate(ConfigurationTemplateSaveRequest request) {
        CgManagerLabel label = (CgManagerLabel)this.managerLabelMapper.selectById((Serializable)((Object)request.getEngineLabelId()));
        ConfigurationConfigKey configKey = new ConfigurationConfigKey();
        BeanUtils.copyProperties((Object)request, (Object)configKey);
        Long keyId = request.getId();
        ConfigurationConfigValue configValue = new ConfigurationConfigValue();
        configValue.setConfigLabelId(label.getId());
        configValue.setConfigValue(request.getDefaultValue());
        if (!StringUtils.isEmpty((Object)keyId)) {
            LOG.info("update configuration config key: [ keyId: " + keyId + " ]");
            int updateKey = this.configKeyMapper.updateById(configKey);
            configValue.setConfigKeyId(configKey.getId());
            LOG.info("update configuration config value: [ keyId: " + keyId + " ]");
            int updateValue = this.configValueMapper.updateByKeyId(configValue);
            return updateKey > 0 && updateValue > 0;
        }
        int insertKey = this.configKeyMapper.insert(configKey);
        LOG.info("insert a configuration config key: [ keyId: " + configKey.getKey() + " ]");
        ConfigurationKeyEngineRelation relation = new ConfigurationKeyEngineRelation();
        relation.setConfigKeyId(configKey.getId());
        relation.setEngineTypeLabelId(label.getId().longValue());
        int insertRelation = this.relationMapper.insert(relation);
        LOG.info("insert a configuration key engine relation: [ relationId: " + relation.getId() + " ]");
        configValue.setConfigKeyId(configKey.getId());
        int insertValue = this.configValueMapper.insert(configValue);
        LOG.info("insert a configuration config value: [ valueId: " + configValue.getId() + " ]");
        return insertKey > 0 & insertRelation > 0 & insertValue > 0;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Boolean deleteConfigurationTemplate(Long keyId) {
        int deleteValue = this.configValueMapper.deleteByKeyId(keyId);
        LOG.info("delete a configuration config value: [ keyId: " + keyId + " ]");
        int deleteRelation = this.relationMapper.deleteByKeyId(keyId);
        LOG.info("delete a configuration key engine relation: [ keyId: " + keyId + " ]");
        int deleteKey = this.configKeyMapper.deleteById(keyId);
        LOG.info("delete a configuration config key: [ keyId: " + keyId + " ]");
        return deleteValue > 0 & deleteRelation > 0 & deleteKey > 0;
    }

    @Override
    public List<EngineLabelResponse> getEngineList() {
        List<CgManagerLabel> cgEngineList = this.managerLabelMapper.getEngineList();
        if (CollectionUtils.isEmpty(cgEngineList)) {
            return Lists.newArrayList();
        }
        List<String> installedList = this.engineConnPluginBmlResourcesMapper.getEngineTypeList();
        return cgEngineList.stream().map(e -> {
            String installedFlag;
            String labelValue = e.getLabelValue().split(",")[1];
            String string = installedFlag = installedList.contains(labelValue) ? "yes" : "no";
            if ("*-*".equals(labelValue)) {
                labelValue = "\u5168\u5c40\u8bbe\u7f6e";
                installedFlag = "yes";
            }
            return new EngineLabelResponse(e.getId(), labelValue, installedFlag);
        }).collect(Collectors.toList());
    }

    @Override
    public List<ConfigurationConfigKey> getTemplateListByLabelId(String engineLabelId) {
        return this.configKeyMapper.getTemplateListByLabelId(engineLabelId);
    }
}

