/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.filesystem.service;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.HashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.linkis.common.io.FsPath;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.common.utils.Utils$;
import org.apache.linkis.filesystem.cache.FsCache$;
import org.apache.linkis.filesystem.conf.WorkSpaceConfiguration;
import org.apache.linkis.filesystem.entity.FSInfo;
import org.apache.linkis.filesystem.exception.WorkSpaceException;
import org.apache.linkis.filesystem.exception.WorkspaceExceptionManager;
import org.apache.linkis.storage.FSFactory$;
import org.apache.linkis.storage.fs.FileSystem;
import org.apache.linkis.storage.utils.StorageUtils$;
import org.slf4j.Logger;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.IndexedSeqOptimized;
import scala.collection.JavaConverters$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ResizableArray;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ObjectRef;

@Service
@ScalaSignature(bytes="\u0006\u0001)4AAB\u0004\u0001%!)\u0011\u0005\u0001C\u0001E!)Q\u0005\u0001C\u0001M!)A\t\u0001C\u0001\u000b\")1\u000b\u0001C\u0001)\")Q\f\u0001C\u0001=\nIai]*feZL7-\u001a\u0006\u0003\u0011%\tqa]3sm&\u001cWM\u0003\u0002\u000b\u0017\u0005Qa-\u001b7fgf\u001cH/Z7\u000b\u00051i\u0011A\u00027j].L7O\u0003\u0002\u000f\u001f\u00051\u0011\r]1dQ\u0016T\u0011\u0001E\u0001\u0004_J<7\u0001A\n\u0004\u0001MI\u0002C\u0001\u000b\u0018\u001b\u0005)\"\"\u0001\f\u0002\u000bM\u001c\u0017\r\\1\n\u0005a)\"AB!osJ+g\r\u0005\u0002\u001b?5\t1D\u0003\u0002\u001d;\u0005)Q\u000f^5mg*\u0011adC\u0001\u0007G>lWn\u001c8\n\u0005\u0001Z\"a\u0002'pO\u001eLgnZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\r\u0002\"\u0001\n\u0001\u000e\u0003\u001d\t!cZ3u\r&dWmU=ti\u0016l7)Y2iKR\u0019qe\f\u001f\u0011\u0005!jS\"A\u0015\u000b\u0005)Z\u0013A\u00014t\u0015\ta3\"A\u0004ti>\u0014\u0018mZ3\n\u00059J#A\u0003$jY\u0016\u001c\u0016p\u001d;f[\")\u0001G\u0001a\u0001c\u0005!Qo]3s!\t\u0011\u0014H\u0004\u00024oA\u0011A'F\u0007\u0002k)\u0011a'E\u0001\u0007yI|w\u000e\u001e \n\u0005a*\u0012A\u0002)sK\u0012,g-\u0003\u0002;w\t11\u000b\u001e:j]\u001eT!\u0001O\u000b\t\u000bu\u0012\u0001\u0019\u0001 \u0002\r\u0019\u001c\b+\u0019;i!\ty$)D\u0001A\u0015\t\tU$\u0001\u0002j_&\u00111\t\u0011\u0002\u0007\rN\u0004\u0016\r\u001e5\u0002\u001b\u001d,GOR5mKNK8\u000f^3n)\r9ci\u0012\u0005\u0006a\r\u0001\r!\r\u0005\u0006{\r\u0001\rA\u0010\u0015\u0004\u0007%\u0013\u0006c\u0001\u000bK\u0019&\u00111*\u0006\u0002\u0007i\"\u0014xn^:\u0011\u00055\u0003V\"\u0001(\u000b\u0005=K\u0011!C3yG\u0016\u0004H/[8o\u0013\t\tfJ\u0001\nX_J\\7\u000b]1dK\u0016C8-\u001a9uS>t7%\u0001'\u0002\u001bA\u0014x\u000eZ;dK\u001a\u001b\u0016J\u001c4p)\r)6\f\u0018\t\u0003-fk\u0011a\u0016\u0006\u00031&\ta!\u001a8uSRL\u0018B\u0001.X\u0005\u001915+\u00138g_\")\u0001\u0007\u0002a\u0001c!)Q\b\u0002a\u0001}\u0005!r-\u001a;GS2,7+_:uK64uN\u001d*fC\u0012$2aJ0a\u0011\u0015\u0001T\u00011\u00012\u0011\u0015iT\u00011\u0001?Q\t\u0001!\r\u0005\u0002dQ6\tAM\u0003\u0002fM\u0006Q1\u000f^3sK>$\u0018\u0010]3\u000b\u0005\u001d|\u0011aD:qe&twM\u001a:b[\u0016<xN]6\n\u0005%$'aB*feZL7-\u001a")
public class FsService
implements Logging {
    private Logger logger;
    private volatile boolean bitmap$0;

    public void trace(Function0<String> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.error$((Logging)this, message);
    }

    private Logger logger$lzycompute() {
        FsService fsService = this;
        synchronized (fsService) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public FileSystem getFileSystemCache(String user, FsPath fsPath) {
        BoxedUnit boxedUnit;
        if (FsCache$.MODULE$.fsInfo().get(user) != null) {
            ArrayBuffer<FSInfo> arrayBuffer = FsCache$.MODULE$.fsInfo().get(user);
            synchronized (arrayBuffer) {
                ArrayBuffer arrayBuffer2;
                if (!((IndexedSeqOptimized)FsCache$.MODULE$.fsInfo().get(user)).exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)FsService.$anonfun$getFileSystemCache$1(fsPath, x$1)))) {
                    arrayBuffer2 = FsCache$.MODULE$.fsInfo().get(user).$plus$eq((Object)this.produceFSInfo(user, fsPath));
                } else {
                    ((FSInfo)((ResizableArray)((TraversableLike)FsCache$.MODULE$.fsInfo().get(user)).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)FsService.$anonfun$getFileSystemCache$2(fsPath, x$2)))).apply(0)).lastAccessTime_$eq(System.currentTimeMillis());
                    arrayBuffer2 = BoxedUnit.UNIT;
                }
                ArrayBuffer arrayBuffer3 = arrayBuffer2;
                // MONITOREXIT @DISABLED, blocks:[0, 4, 13] lbl11 : MonitorExitStatement: MONITOREXIT : var3_3
                boxedUnit = arrayBuffer3;
            }
        }
        HashMap<String, ArrayBuffer<FSInfo>> hashMap = FsCache$.MODULE$.fsInfo();
        synchronized (hashMap) {
            ArrayBuffer<FSInfo> arrayBuffer = FsCache$.MODULE$.fsInfo().get(user) == null ? FsCache$.MODULE$.fsInfo().put(user, (ArrayBuffer<FSInfo>)ArrayBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FSInfo[]{this.produceFSInfo(user, fsPath)}))) : BoxedUnit.UNIT;
        }
        if (!((IndexedSeqOptimized)FsCache$.MODULE$.fsInfo().get(user)).exists((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)FsService.$anonfun$getFileSystemCache$3(fsPath, x$3)))) {
            ArrayBuffer<FSInfo> arrayBuffer = FsCache$.MODULE$.fsInfo().get(user);
            synchronized (arrayBuffer) {
                BoxedUnit boxedUnit2 = !((IndexedSeqOptimized)FsCache$.MODULE$.fsInfo().get(user)).exists((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)FsService.$anonfun$getFileSystemCache$4(fsPath, x$4))) ? FsCache$.MODULE$.fsInfo().get(user).$plus$eq((Object)this.produceFSInfo(user, fsPath)) : BoxedUnit.UNIT;
                // MONITOREXIT @DISABLED, blocks:[2, 5, 10] lbl32 : MonitorExitStatement: MONITOREXIT : var6_6
                boxedUnit = boxedUnit2;
            }
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return ((FSInfo)((ResizableArray)((TraversableLike)((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(FsCache$.MODULE$.fsInfo()).asScala()).apply((Object)user)).filter((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)FsService.$anonfun$getFileSystemCache$5(fsPath, x$5)))).apply(0)).fs();
    }

    public FileSystem getFileSystem(String user, FsPath fsPath) throws WorkSpaceException {
        ObjectRef fs = ObjectRef.create(null);
        long start = System.currentTimeMillis();
        FutureTask<FileSystem> task = new FutureTask<FileSystem>(new Callable<FileSystem>(this, fs, user, fsPath){
            private final /* synthetic */ FsService $outer;
            private final ObjectRef fs$1;
            private final String user$1;
            private final FsPath fsPath$2;

            public FileSystem call() {
                this.fs$1.elem = (FileSystem)Utils$.MODULE$.tryAndError((Function0 & Serializable & scala.Serializable)() -> $this.$outer.getFileSystemCache($this.user$1, $this.fsPath$2), this.$outer.logger());
                return (FileSystem)this.fs$1.elem;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.fs$1 = fs$1;
                this.user$1 = user$1;
                this.fsPath$2 = fsPath$2;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$call$1(org.apache.linkis.filesystem.service.FsService$$anon$1 )}, serializedLambda);
            }
        });
        WorkSpaceConfiguration.executorService.execute(task);
        long timeout = Predef$.MODULE$.Long2long((Long)WorkSpaceConfiguration.FILESYSTEM_GET_TIMEOUT.getValue());
        try {
            FileSystem fileSystem;
            try {
                fileSystem = task.get(timeout, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                this.logger().error("Failed to getFileSystem", (Throwable)e);
                task.cancel(true);
                fileSystem = null;
            }
            catch (ExecutionException e) {
                this.logger().error("Failed to getFileSystem", (Throwable)e);
                task.cancel(true);
                fileSystem = null;
            }
            catch (TimeoutException e) {
                this.logger().error("Failed to getFileSystem", (Throwable)e);
                task.cancel(true);
                fileSystem = null;
            }
        }
        finally {
            long end = System.currentTimeMillis();
            this.logger().info(new StringBuilder(81).append(user).append(" gets the ").append(fsPath.getFsType()).append(" type filesystem using a total of ").append(end - start).append(" milliseconds(").append(user).append("\u83b7\u53d6").append(fsPath.getFsType()).append("\u7c7b\u578b\u7684filesystem\u4e00\u5171\u4f7f\u7528\u4e86").append(end - start).append("\u6beb\u79d2)").toString());
        }
        if ((FileSystem)fs.elem == null) {
            throw WorkspaceExceptionManager.createException(80002, BoxesRunTime.boxToLong((long)timeout), BoxesRunTime.boxToLong((long)timeout));
        }
        return (FileSystem)fs.elem;
    }

    public FSInfo produceFSInfo(String user, FsPath fsPath) {
        FSInfo fSInfo;
        try {
            FileSystem fs = (FileSystem)FSFactory$.MODULE$.getFsByProxyUser(fsPath, user);
            fs.init(null);
            fSInfo = new FSInfo(user, fs, System.currentTimeMillis());
        }
        catch (Exception e) {
            this.logger().error("Requesting IO-Engine to initialize fileSystem failed", (Throwable)e);
            throw WorkspaceExceptionManager.createException(80001, new Object[0]);
        }
        return fSInfo;
    }

    public FileSystem getFileSystemForRead(String user, FsPath fsPath) {
        if (Predef$.MODULE$.Boolean2boolean((Boolean)WorkSpaceConfiguration.FILESYSTEM_JVM_USER_SWITCH.getValue()) && !fsPath.getFsType().equals(StorageUtils$.MODULE$.FILE())) {
            FileSystem fs = this.getFileSystem(StorageUtils$.MODULE$.getJvmUser(), fsPath);
            if (fs.exists(fsPath) && !fs.canRead(fsPath, user)) {
                throw WorkspaceExceptionManager.createException(80012, new Object[0]);
            }
            return fs;
        }
        return this.getFileSystem(user, fsPath);
    }

    public static final /* synthetic */ boolean $anonfun$getFileSystemCache$1(FsPath fsPath$1, FSInfo x$1) {
        return x$1.fs().fsName().equals(fsPath$1.getFsType());
    }

    public static final /* synthetic */ boolean $anonfun$getFileSystemCache$2(FsPath fsPath$1, FSInfo x$2) {
        return x$2.fs().fsName().equals(fsPath$1.getFsType());
    }

    public static final /* synthetic */ boolean $anonfun$getFileSystemCache$3(FsPath fsPath$1, FSInfo x$3) {
        return x$3.fs().fsName().equals(fsPath$1.getFsType());
    }

    public static final /* synthetic */ boolean $anonfun$getFileSystemCache$4(FsPath fsPath$1, FSInfo x$4) {
        return x$4.fs().fsName().equals(fsPath$1.getFsType());
    }

    public static final /* synthetic */ boolean $anonfun$getFileSystemCache$5(FsPath fsPath$1, FSInfo x$5) {
        return x$5.fs().fsName().equals(fsPath$1.getFsType());
    }

    public FsService() {
        Logging.$init$((Logging)this);
    }
}

