/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.engineconn.computation.concurrent.monitor;

import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.linkis.common.conf.CommonVars;
import org.apache.linkis.common.conf.TimeType;
import org.apache.linkis.common.utils.Utils;
import org.apache.linkis.engineconn.acessible.executor.conf.AccessibleExecutorConfiguration;
import org.apache.linkis.engineconn.acessible.executor.entity.AccessibleExecutor;
import org.apache.linkis.engineconn.computation.concurrent.monitor.MonitorService;
import org.apache.linkis.engineconn.core.EngineConnObject;
import org.apache.linkis.engineconn.core.executor.ExecutorManager$;
import org.apache.linkis.manager.common.entity.enumeration.NodeStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TimingMonitorService
implements InitializingBean,
Runnable {
    private static Logger LOG = LoggerFactory.getLogger(TimingMonitorService.class);
    private static CommonVars<TimeType> MONITOR_INTERVAL = CommonVars.apply((String)"linkis.engineconn.concurrent.monitor.interval", (Object)new TimeType("30s"));
    @Autowired
    private List<MonitorService> monitorServiceList;
    private boolean isAvailable = true;
    private AccessibleExecutor concurrentExecutor = null;
    private static final Object EXECUTOR_STATUS_LOCKER = new Object();

    public void afterPropertiesSet() throws Exception {
        if (((Boolean)AccessibleExecutorConfiguration.ENGINECONN_SUPPORT_PARALLELISM().getValue()).booleanValue()) {
            Utils.defaultScheduler().scheduleAtFixedRate(this, 180000L, ((TimeType)MONITOR_INTERVAL.getValue()).toLong(), TimeUnit.MILLISECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block12: {
            if (!EngineConnObject.isReady()) {
                return;
            }
            try {
                Object executor;
                if (null == this.concurrentExecutor && (executor = ExecutorManager$.MODULE$.getInstance().getReportExecutor()) instanceof AccessibleExecutor) {
                    this.concurrentExecutor = (AccessibleExecutor)executor;
                }
                if (null == this.concurrentExecutor) {
                    LOG.warn("Executor can not is null");
                    return;
                }
                this.isAvailable = true;
                this.monitorServiceList.forEach(monitorService -> {
                    if (!monitorService.isAvailable()) {
                        this.isAvailable = false;
                    }
                });
                if (this.isAvailable) {
                    if (!this.concurrentExecutor.isBusy()) break block12;
                    executor = EXECUTOR_STATUS_LOCKER;
                    synchronized (executor) {
                        LOG.info("monitor turn to executor status from busy to unlock");
                        this.concurrentExecutor.transition(NodeStatus.Unlock);
                        break block12;
                    }
                }
                if (!this.concurrentExecutor.isIdle()) break block12;
                executor = EXECUTOR_STATUS_LOCKER;
                synchronized (executor) {
                    LOG.info("monitor turn to executor status from unlock to busy");
                    this.concurrentExecutor.transition(NodeStatus.Busy);
                }
            }
            catch (Exception e) {
                LOG.warn("Failed to executor monitor ", (Throwable)e);
            }
        }
    }
}

