/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.mybatis;

import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.druid.pool.ValidConnectionChecker;
import com.alibaba.druid.pool.vendor.MySqlValidConnectionChecker;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.mybatis.conf.MybatisConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSourceUtils {
    private static final Logger logger = LoggerFactory.getLogger(DataSourceUtils.class);

    public static DataSource buildDataSource(String dbUrl, String username, String pwd) {
        if (StringUtils.isBlank((CharSequence)dbUrl)) {
            dbUrl = (String)MybatisConfiguration.BDP_SERVER_MYBATIS_DATASOURCE_URL.getValue();
        }
        if (StringUtils.isBlank((CharSequence)username)) {
            username = (String)MybatisConfiguration.BDP_SERVER_MYBATIS_DATASOURCE_USERNAME.getValue();
        }
        if (StringUtils.isBlank((CharSequence)pwd)) {
            pwd = (String)MybatisConfiguration.BDP_SERVER_MYBATIS_DATASOURCE_PASSWORD.getValue();
        }
        String driverClassName = (String)MybatisConfiguration.BDP_SERVER_MYBATIS_DATASOURCE_DRIVER_CLASS_NAME.getValue();
        int initialSize = (Integer)MybatisConfiguration.BDP_SERVER_MYBATIS_DATASOURCE_INITIALSIZE.getValue();
        int minIdle = (Integer)MybatisConfiguration.BDP_SERVER_MYBATIS_DATASOURCE_MINIDLE.getValue();
        int maxActive = (Integer)MybatisConfiguration.BDP_SERVER_MYBATIS_DATASOURCE_MAXACTIVE.getValue();
        int maxWait = (Integer)MybatisConfiguration.BDP_SERVER_MYBATIS_DATASOURCE_MAXWAIT.getValue();
        int timeBetweenEvictionRunsMillis = (Integer)MybatisConfiguration.BDP_SERVER_MYBATIS_DATASOURCE_TBERM.getValue();
        int minEvictableIdleTimeMillis = (Integer)MybatisConfiguration.BDP_SERVER_MYBATIS_DATASOURCE_MEITM.getValue();
        String validationQuery = (String)MybatisConfiguration.BDP_SERVER_MYBATIS_DATASOURCE_VALIDATIONQUERY.getValue();
        boolean testWhileIdle = (Boolean)MybatisConfiguration.BDP_SERVER_MYBATIS_DATASOURCE_TESTWHILEIDLE.getValue();
        boolean testOnBorrow = (Boolean)MybatisConfiguration.BDP_SERVER_MYBATIS_DATASOURCE_TESTONBORROW.getValue();
        boolean testOnReturn = (Boolean)MybatisConfiguration.BDP_SERVER_MYBATIS_DATASOURCE_TESTONRETURN.getValue();
        boolean poolPreparedStatements = (Boolean)MybatisConfiguration.BDP_SERVER_MYBATIS_DATASOURCE_POOLPREPAREDSTATEMENTS.getValue();
        boolean removeAbandoned = (Boolean)MybatisConfiguration.MYBATIS_DATASOURCE_REMOVE_ABANDONED_ENABLED.getValue();
        int removeAbandonedTimeout = (Integer)MybatisConfiguration.MYBATIS_DATASOURCE_REMOVE_ABANDONED_TIMEOUT.getValue();
        boolean jdbcKeepAlive = (Boolean)MybatisConfiguration.MYBATIS_DATASOURCE_KEEPALIVE_ENABLED.getValue();
        boolean jdbcUsePingMethod = (Boolean)MybatisConfiguration.MYBATIS_DATASOURCE_USE_PING_ENABLED.getValue();
        DruidDataSource datasource = new DruidDataSource();
        logger.info("Database connection address information(\u6570\u636e\u5e93\u8fde\u63a5\u5730\u5740\u4fe1\u606f)=" + dbUrl);
        datasource.setUrl(dbUrl);
        datasource.setUsername(username);
        datasource.setPassword(pwd);
        datasource.setDriverClassName(driverClassName);
        datasource.setInitialSize(initialSize);
        datasource.setMinIdle(minIdle);
        datasource.setMaxActive(maxActive);
        datasource.setMaxWait((long)maxWait);
        datasource.setTimeBetweenEvictionRunsMillis((long)timeBetweenEvictionRunsMillis);
        datasource.setMinEvictableIdleTimeMillis((long)minEvictableIdleTimeMillis);
        datasource.setValidationQuery(validationQuery);
        datasource.setTestWhileIdle(testWhileIdle);
        datasource.setTestOnBorrow(testOnBorrow);
        datasource.setTestOnReturn(testOnReturn);
        datasource.setKeepAlive(jdbcKeepAlive);
        if (!jdbcUsePingMethod) {
            MySqlValidConnectionChecker checker = new MySqlValidConnectionChecker();
            checker.setUsePingMethod(false);
            datasource.setValidConnectionChecker((ValidConnectionChecker)checker);
        }
        datasource.setPoolPreparedStatements(poolPreparedStatements);
        datasource.setRemoveAbandoned(removeAbandoned);
        datasource.setRemoveAbandonedTimeout(removeAbandonedTimeout);
        return datasource;
    }
}

