/*
 * Decompiled with CFR 0.152.
 */
package com.github.xiaoymin.knife4j.spring.filter;

import com.github.xiaoymin.knife4j.spring.filter.BasicFilter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;

public class ProductionSecurityFilter
extends BasicFilter
implements Filter {
    private boolean production = false;

    public void init(FilterConfig filterConfig) throws ServletException {
        Enumeration enumeration = filterConfig.getInitParameterNames();
        if (enumeration.hasMoreElements()) {
            this.setProduction(Boolean.valueOf(filterConfig.getInitParameter("production")));
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        if (this.production) {
            String uri = httpServletRequest.getRequestURI();
            if (!this.match(uri)) {
                chain.doFilter(request, response);
            } else {
                response.setContentType("text/palin;charset=UTF-8");
                PrintWriter pw = response.getWriter();
                pw.write("You do not have permission to access this page");
                pw.flush();
            }
        } else {
            chain.doFilter(request, response);
        }
    }

    public void destroy() {
    }

    public ProductionSecurityFilter(boolean production) {
        this.production = production;
    }

    public ProductionSecurityFilter() {
    }

    public boolean isProduction() {
        return this.production;
    }

    public void setProduction(boolean production) {
        this.production = production;
    }
}

