/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.httpclient.dws;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.linkis.common.io.Fs;
import org.apache.linkis.common.io.FsPath;
import org.apache.linkis.httpclient.AbstractHttpClient;
import org.apache.linkis.httpclient.config.ClientConfig;
import org.apache.linkis.httpclient.discovery.Discovery;
import org.apache.linkis.httpclient.dws.DWSHttpClient$;
import org.apache.linkis.httpclient.dws.config.DWSClientConfig;
import org.apache.linkis.httpclient.dws.config.GatewayHttpClientConf$;
import org.apache.linkis.httpclient.dws.discovery.DWSGatewayDiscovery;
import org.apache.linkis.httpclient.dws.discovery.DefaultConfigDiscovery;
import org.apache.linkis.httpclient.dws.request.DWSHttpAction;
import org.apache.linkis.httpclient.dws.response.DWSHttpMessageFactory$;
import org.apache.linkis.httpclient.dws.response.DWSHttpMessageResultInfo;
import org.apache.linkis.httpclient.dws.response.DWSResult;
import org.apache.linkis.httpclient.request.HttpAction;
import org.apache.linkis.httpclient.response.HttpResult;
import org.apache.linkis.httpclient.response.ListResult;
import org.apache.linkis.httpclient.response.Result;
import org.apache.linkis.httpclient.response.Result$;
import org.apache.linkis.httpclient.response.impl.DefaultHttpResult;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Some;
import scala.collection.JavaConverters$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.NonLocalReturnControl;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001dd\u0001\u0002\t\u0012\u0001qA\u0001\"\u000b\u0001\u0003\u0002\u0003\u0006IA\u000b\u0005\ta\u0001\u0011\t\u0011)A\u0005c!)a\b\u0001C\u0001\u007f!)A\t\u0001C)\u000b\")A\n\u0001C)\u001b\")a\u000b\u0001C)/\")A\u000e\u0001C\t[\")!\u000f\u0001C\tg\")q\u000f\u0001C\tq\"9\u0011Q\u0004\u0001\u0005R\u0005}qaBA\u001e#!\u0005\u0011Q\b\u0004\u0007!EA\t!a\u0010\t\rybA\u0011AA$\u0011%\tI\u0005\u0004b\u0001\n\u0003\tY\u0005\u0003\u0005\u0002f1\u0001\u000b\u0011BA'\u00055!uk\u0015%uiB\u001cE.[3oi*\u0011!cE\u0001\u0004I^\u001c(B\u0001\u000b\u0016\u0003)AG\u000f\u001e9dY&,g\u000e\u001e\u0006\u0003-]\ta\u0001\\5oW&\u001c(B\u0001\r\u001a\u0003\u0019\t\u0007/Y2iK*\t!$A\u0002pe\u001e\u001c\u0001aE\u0002\u0001;\u0005\u0002\"AH\u0010\u000e\u0003MI!\u0001I\n\u0003%\u0005\u00137\u000f\u001e:bGRDE\u000f\u001e9DY&,g\u000e\u001e\t\u0003E\u001dj\u0011a\t\u0006\u0003I\u0015\nQ!\u001e;jYNT!AJ\u000b\u0002\r\r|W.\\8o\u0013\tA3EA\u0004M_\u001e<\u0017N\\4\u0002\u0019\rd\u0017.\u001a8u\u0007>tg-[4\u0011\u0005-rS\"\u0001\u0017\u000b\u00055\n\u0012AB2p]\u001aLw-\u0003\u00020Y\tyAiV*DY&,g\u000e^\"p]\u001aLw-\u0001\u0006dY&,g\u000e\u001e(b[\u0016\u0004\"AM\u001e\u000f\u0005MJ\u0004C\u0001\u001b8\u001b\u0005)$B\u0001\u001c\u001c\u0003\u0019a$o\\8u})\t\u0001(A\u0003tG\u0006d\u0017-\u0003\u0002;o\u00051\u0001K]3eK\u001aL!\u0001P\u001f\u0003\rM#(/\u001b8h\u0015\tQt'\u0001\u0004=S:LGO\u0010\u000b\u0004\u0001\n\u001b\u0005CA!\u0001\u001b\u0005\t\u0002\"B\u0015\u0004\u0001\u0004Q\u0003\"\u0002\u0019\u0004\u0001\u0004\t\u0014aD2sK\u0006$X\rR5tG>4XM]=\u0015\u0003\u0019\u0003\"a\u0012&\u000e\u0003!S!!S\n\u0002\u0013\u0011L7oY8wKJL\u0018BA&I\u0005%!\u0015n]2pm\u0016\u0014\u00180A\u0007qe\u0016\u0004\u0018M]3BGRLwN\u001c\u000b\u0003\u001dR\u0003\"a\u0014*\u000e\u0003AS!!U\n\u0002\u000fI,\u0017/^3ti&\u00111\u000b\u0015\u0002\u000b\u0011R$\b/Q2uS>t\u0007\"B+\u0006\u0001\u0004q\u0015!\u0004:fcV,7\u000f^!di&|g.\u0001\u000biiR\u0004(+Z:q_:\u001cX\rV8SKN,H\u000e\u001e\u000b\u00051\nL'\u000eE\u0002Z5rk\u0011aN\u0005\u00037^\u0012aa\u00149uS>t\u0007CA/a\u001b\u0005q&BA0\u0014\u0003!\u0011Xm\u001d9p]N,\u0017BA1_\u0005\u0019\u0011Vm];mi\")qL\u0002a\u0001GB\u0011AmZ\u0007\u0002K*\u0011amF\u0001\u0005QR$\b/\u0003\u0002iK\na\u0001\n\u001e;q%\u0016\u001c\bo\u001c8tK\")QK\u0002a\u0001\u001d\")1N\u0002a\u0001c\u0005a!/Z:q_:\u001cXMQ8es\u00069B-Z:fe&\fG.\u001b>f%\u0016\u001c\bo\u001c8tK\n{G-\u001f\u000b\u0003]F\u0004\"!W8\n\u0005A<$aA!os\")1n\u0002a\u0001c\u00051bn\u001c8E/N\u0013Vm\u001d9p]N,Gk\u001c*fgVdG\u000f\u0006\u0003YiV4\b\"B0\t\u0001\u0004\u0019\u0007\"B+\t\u0001\u0004q\u0005\"B6\t\u0001\u0004\t\u0014\u0001\u00054jY2\u0014Vm];mi\u001aKW\r\u001c3t)\u0011IH0!\u0007\u0011\u0005eS\u0018BA>8\u0005\u0011)f.\u001b;\t\u000buL\u0001\u0019\u0001@\u0002\u0017I,7\u000f]8og\u0016l\u0015\r\u001d\t\u0007\u007f\u0006%\u0011'!\u0004\u000e\u0005\u0005\u0005!\u0002BA\u0002\u0003\u000b\tA!\u001e;jY*\u0011\u0011qA\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002\f\u0005\u0005!aA'baB!\u0011qBA\u000b\u001b\t\t\tB\u0003\u0003\u0002\u0014\u0005\u0015\u0011\u0001\u00027b]\u001eLA!a\u0006\u0002\u0012\t1qJ\u00196fGRDa!a\u0007\n\u0001\u0004a\u0016!\u0002<bYV,\u0017aC4fi\u001a\u001b()_+tKJ$b!!\t\u0002.\u0005E\u0002\u0003BA\u0012\u0003Si!!!\n\u000b\u0007\u0005\u001dR%\u0001\u0002j_&!\u00111FA\u0013\u0005\t15\u000f\u0003\u0004\u00020)\u0001\r!M\u0001\u0005kN,'\u000fC\u0004\u00024)\u0001\r!!\u000e\u0002\tA\fG\u000f\u001b\t\u0005\u0003G\t9$\u0003\u0003\u0002:\u0005\u0015\"A\u0002$t!\u0006$\b.A\u0007E/NCE\u000f\u001e9DY&,g\u000e\u001e\t\u0003\u00032\u00192\u0001DA!!\rI\u00161I\u0005\u0004\u0003\u000b:$AB!osJ+g\r\u0006\u0002\u0002>\u0005Y!.Y2lg>t'j]8o+\t\ti\u0005\u0005\u0003\u0002P\u0005\u0005TBAA)\u0015\u0011\t\u0019&!\u0016\u0002\u0011\u0011\fG/\u00192j]\u0012TA!a\u0016\u0002Z\u00059!.Y2lg>t'\u0002BA.\u0003;\n\u0011BZ1ti\u0016\u0014\b0\u001c7\u000b\u0005\u0005}\u0013aA2p[&!\u00111MA)\u00051y%M[3di6\u000b\u0007\u000f]3s\u00031Q\u0017mY6t_:T5o\u001c8!\u0001")
public class DWSHttpClient
extends AbstractHttpClient {
    private final DWSClientConfig clientConfig;

    public static ObjectMapper jacksonJson() {
        return DWSHttpClient$.MODULE$.jacksonJson();
    }

    public Discovery createDiscovery() {
        if (GatewayHttpClientConf$.MODULE$.enableDefaultDiscovery()) {
            return new DefaultConfigDiscovery();
        }
        return new DWSGatewayDiscovery();
    }

    public HttpAction prepareAction(HttpAction requestAction) {
        block0: {
            HttpAction httpAction = requestAction;
            if (!(httpAction instanceof DWSHttpAction)) break block0;
            HttpAction httpAction2 = httpAction;
            ((DWSHttpAction)httpAction2).setDWSVersion(this.clientConfig.getDWSVersion());
        }
        return requestAction;
    }

    public Option<Result> httpResponseToResult(HttpResponse response, HttpAction requestAction, String responseBody) {
        Option option;
        Object object = new Object();
        try {
            HttpEntity entity = response.getEntity();
            int statusCode = response.getStatusLine().getStatusCode();
            String url = requestAction.getURL();
            if (entity.getContentType() == null && statusCode == 200) {
                this.logger().info("response is null, return success Result");
                return new Some((Object)Result$.MODULE$.apply());
            }
            String contentType = entity.getContentType().getValue();
            option = DWSHttpMessageFactory$.MODULE$.getDWSHttpMessageResult(url).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                DWSHttpMessageResultInfo dWSHttpMessageResultInfo = x0$1;
                if (dWSHttpMessageResultInfo != null) {
                    Class<?> clazz = dWSHttpMessageResultInfo.clazz();
                    Class<?> clazz2 = clazz;
                    if (ClassUtils.isAssignable(clazz2, DWSResult.class)) {
                        DWSResult dwsResult = (DWSResult)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                        dwsResult.set(responseBody, statusCode, url, contentType);
                        BeanUtils.populate((Object)dwsResult, dwsResult.getData());
                        throw new NonLocalReturnControl(object, (Object)new Some((Object)dwsResult));
                    }
                    Object object = this.deserializeResponseBody(responseBody);
                    if (object instanceof Map) {
                        Map map2 = (Map)object;
                        Result value = (Result)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                        this.transfer$1(value, map2, responseBody, statusCode, url, contentType);
                        return value;
                    }
                    if (object instanceof List) {
                        List list = (List)object;
                        Result[] results = (Result[])((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(list).asScala()).map((Function1 & Serializable & scala.Serializable)map -> {
                            Result value = (Result)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                            this.transfer$1(value, (Map)map, responseBody, statusCode, url, contentType);
                            return value;
                        }, Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Result.class));
                        return new ListResult(responseBody, results);
                    }
                    throw new MatchError(object);
                }
                throw new MatchError((Object)dWSHttpMessageResultInfo);
            }).orElse((Function0 & Serializable & scala.Serializable)() -> this.nonDWSResponseToResult(response, requestAction, responseBody));
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                option = (Option)ex.value();
            }
            throw ex;
        }
        return option;
    }

    public Object deserializeResponseBody(String responseBody) {
        if (responseBody.startsWith("{") && responseBody.endsWith("}")) {
            return DWSHttpClient$.MODULE$.jacksonJson().readValue(responseBody, Map.class);
        }
        if (responseBody.startsWith("[") && responseBody.endsWith("]")) {
            return DWSHttpClient$.MODULE$.jacksonJson().readValue(responseBody, List.class);
        }
        if (StringUtils.isEmpty((CharSequence)responseBody)) {
            return new HashMap();
        }
        if (responseBody.length() > 200) {
            throw new HttpException(responseBody.substring(0, 200));
        }
        throw new HttpException(responseBody);
    }

    public Option<Result> nonDWSResponseToResult(HttpResponse response, HttpAction requestAction, String responseBody) {
        DefaultHttpResult httpResult = new DefaultHttpResult();
        httpResult.set(responseBody, response.getStatusLine().getStatusCode(), requestAction.getURL(), response.getEntity().getContentType().getValue());
        return new Some((Object)httpResult);
    }

    public void fillResultFields(Map<String, Object> responseMap, Result value) {
    }

    public Fs getFsByUser(String user, FsPath path) {
        return null;
    }

    private final void transfer$1(Result value, Map map, String responseBody$1, int statusCode$1, String url$1, String contentType$1) {
        Result result = value;
        if (result instanceof HttpResult) {
            HttpResult httpResult = (HttpResult)result;
            httpResult.set(responseBody$1, statusCode$1, url$1, contentType$1);
        }
        BeanUtils.populate((Object)value, (Map)map);
        this.fillResultFields(map, value);
    }

    public DWSHttpClient(DWSClientConfig clientConfig, String clientName) {
        this.clientConfig = clientConfig;
        super((ClientConfig)clientConfig, clientName);
    }
}

