/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.engineplugin.spark.datacalc.sink;

import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.engineplugin.spark.datacalc.api.DataCalcPlugin;
import org.apache.linkis.engineplugin.spark.datacalc.api.DataCalcSink;
import org.apache.linkis.engineplugin.spark.datacalc.exception.HiveSinkException;
import org.apache.linkis.engineplugin.spark.datacalc.model.DataCalcPluginConfig;
import org.apache.linkis.engineplugin.spark.datacalc.model.SinkConfig;
import org.apache.linkis.engineplugin.spark.datacalc.sink.FileFormat$;
import org.apache.linkis.engineplugin.spark.datacalc.sink.HiveSinkConfig;
import org.apache.linkis.engineplugin.spark.errorcode.SparkErrorCodeSummary;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.DataFrameWriter;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.datasources.FileFormat;
import org.apache.spark.sql.execution.datasources.HadoopFsRelation;
import org.apache.spark.sql.execution.datasources.LogicalRelation;
import org.apache.spark.sql.execution.datasources.parquet.ParquetFileFormat;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.sql.sources.DataSourceRegister;
import org.apache.spark.sql.types.StructField;
import org.slf4j.Logger;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005eb\u0001B\u0005\u000b\u0001eAQA\r\u0001\u0005\u0002MBQ!\u000e\u0001\u0005\u0002YBQA\u0013\u0001\u0005\u0002-CQ\u0001\u001b\u0001\u0005\u0002%DQ!\u001c\u0001\u0005\u00029Dq!a\u0002\u0001\t\u0003\tI\u0001C\u0004\u0002\u0016\u0001!\t!a\u0006\t\u000f\u00055\u0002\u0001\"\u0001\u00020\tA\u0001*\u001b<f'&t7N\u0003\u0002\f\u0019\u0005!1/\u001b8l\u0015\tia\"\u0001\u0005eCR\f7-\u00197d\u0015\ty\u0001#A\u0003ta\u0006\u00148N\u0003\u0002\u0012%\u0005aQM\\4j]\u0016\u0004H.^4j]*\u00111\u0003F\u0001\u0007Y&t7.[:\u000b\u0005U1\u0012AB1qC\u000eDWMC\u0001\u0018\u0003\ry'oZ\u0002\u0001'\u0011\u0001!\u0004\t\u0016\u0011\u0005mqR\"\u0001\u000f\u000b\u0003u\tQa]2bY\u0006L!a\b\u000f\u0003\r\u0005s\u0017PU3g!\r\tCEJ\u0007\u0002E)\u00111\u0005D\u0001\u0004CBL\u0017BA\u0013#\u00051!\u0015\r^1DC2\u001c7+\u001b8l!\t9\u0003&D\u0001\u000b\u0013\tI#B\u0001\bISZ,7+\u001b8l\u0007>tg-[4\u0011\u0005-\u0002T\"\u0001\u0017\u000b\u00055r\u0013!B;uS2\u001c(BA\u0018\u0013\u0003\u0019\u0019w.\\7p]&\u0011\u0011\u0007\f\u0002\b\u0019><w-\u001b8h\u0003\u0019a\u0014N\\5u}Q\tA\u0007\u0005\u0002(\u0001\u00051q.\u001e;qkR$2a\u000e\u001eC!\tY\u0002(\u0003\u0002:9\t!QK\\5u\u0011\u0015y!\u00011\u0001<!\ta\u0004)D\u0001>\u0015\tqt(A\u0002tc2T!a\u0004\u000b\n\u0005\u0005k$\u0001D*qCJ\\7+Z:tS>t\u0007\"B\"\u0003\u0001\u0004!\u0015A\u00013t!\raTiR\u0005\u0003\rv\u0012q\u0001R1uCN,G\u000f\u0005\u0002=\u0011&\u0011\u0011*\u0010\u0002\u0004%><\u0018!D4fiN\u000bg/Z,sSR,'\u000f\u0006\u0003M\u001fB[\u0006c\u0001\u001fN\u000f&\u0011a*\u0010\u0002\u0010\t\u0006$\u0018M\u0012:b[\u0016<&/\u001b;fe\")1i\u0001a\u0001\t\")\u0011k\u0001a\u0001%\u0006aA/\u0019:hKR4\u0015.\u001a7egB\u00191dU+\n\u0005Qc\"!B!se\u0006L\bC\u0001,Z\u001b\u00059&B\u0001->\u0003\u0015!\u0018\u0010]3t\u0013\tQvKA\u0006TiJ,8\r\u001e$jK2$\u0007\"\u0002/\u0004\u0001\u0004i\u0016a\u0003;be\u001e,G\u000fV1cY\u0016\u0004\"AX3\u000f\u0005}\u001b\u0007C\u00011\u001d\u001b\u0005\t'B\u00012\u0019\u0003\u0019a$o\\8u}%\u0011A\rH\u0001\u0007!J,G-\u001a4\n\u0005\u0019<'AB*ue&twM\u0003\u0002e9\u0005IAn\\4GS\u0016dGm\u001d\u000b\u0004o)d\u0007\"B6\u0005\u0001\u0004\u0011\u0016\u0001D:pkJ\u001cWMR5fY\u0012\u001c\b\"B)\u0005\u0001\u0004\u0011\u0016AD:fcV,gnY3GS\u0016dGm\u001d\u000b\t_z\f\t!a\u0001\u0002\u0006A\u0011\u0001o\u001f\b\u0003cft!A\u001d=\u000f\u0005M<hB\u0001;w\u001d\t\u0001W/C\u0001\u0018\u0013\t)b#\u0003\u0002\u0010)%\u0011ahP\u0005\u0003uv\nq\u0001]1dW\u0006<W-\u0003\u0002}{\nIA)\u0019;b\rJ\fW.\u001a\u0006\u0003uvBQa`\u0003A\u0002\u0011\u000b\u0001\u0002Z:T_V\u00148-\u001a\u0005\u0006W\u0016\u0001\rA\u0015\u0005\u0006#\u0016\u0001\rA\u0015\u0005\u00069\u0016\u0001\r!X\u0001\fO\u0016$Hj\\2bi&|g\u000eF\u0004^\u0003\u0017\ti!a\u0004\t\u000b=1\u0001\u0019A\u001e\t\u000bq3\u0001\u0019A/\t\u000f\u0005Ea\u00011\u0001\u0002\u0014\u0005\t\u0002/\u0019:uSRLwN\\:D_2,XN\\:\u0011\u0007m\u0019V,\u0001\nhKR$\u0016M\u00197f\r&dWMR8s[\u0006$HCBA\r\u0003S\tY\u0003\u0005\u0003\u0002\u001c\u0005\u0005bbA\u0014\u0002\u001e%\u0019\u0011q\u0004\u0006\u0002\u0015\u0019KG.\u001a$pe6\fG/\u0003\u0003\u0002$\u0005\u0015\"!\u0002,bYV,\u0017bAA\u00149\tYQI\\;nKJ\fG/[8o\u0011\u0015yq\u00011\u0001<\u0011\u0015av\u00011\u0001^\u0003A\u0011XM\u001a:fg\"\u0004\u0016M\u001d;ji&|g\u000eF\u00048\u0003c\t\u0019$!\u000e\t\u000b=A\u0001\u0019A\u001e\t\u000bqC\u0001\u0019A/\t\r\u0005]\u0002\u00021\u0001^\u0003%\u0001\u0018M\u001d;ji&|g\u000e")
public class HiveSink
implements DataCalcSink<HiveSinkConfig>,
Logging {
    private Logger logger;
    private HiveSinkConfig config;
    private volatile boolean bitmap$0;

    public void trace(Function0<String> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.error$((Logging)this, message);
    }

    @Override
    public Object getConfig() {
        return DataCalcPlugin.getConfig$(this);
    }

    @Override
    public void setConfig(Object config) {
        DataCalcPlugin.setConfig$(this, config);
    }

    @Override
    public void prepare(SparkSession spark) {
        DataCalcPlugin.prepare$(this, spark);
    }

    private Logger logger$lzycompute() {
        HiveSink hiveSink = this;
        synchronized (hiveSink) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public HiveSinkConfig config() {
        return this.config;
    }

    @Override
    public void config_$eq(HiveSinkConfig x$1) {
        this.config = x$1;
    }

    @Override
    public void output(SparkSession spark, Dataset<Row> ds) {
        String targetTable = StringUtils.isBlank((CharSequence)((HiveSinkConfig)this.config()).getTargetDatabase()) ? ((HiveSinkConfig)this.config()).getTargetTable() : new StringBuilder(1).append(((HiveSinkConfig)this.config()).getTargetDatabase()).append(".").append(((HiveSinkConfig)this.config()).getTargetTable()).toString();
        StructField[] targetFields = spark.table(targetTable).schema().fields();
        if (((HiveSinkConfig)this.config()).getWriteAsFile() != null && Predef$.MODULE$.Boolean2boolean(((HiveSinkConfig)this.config()).getWriteAsFile())) {
            String[] partitionsColumns = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])spark.catalog().listColumns(targetTable).where(functions$.MODULE$.col("isPartition").$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)true))).select("name", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).collect())).map((Function1 & Serializable & scala.Serializable)x$1 -> (String)x$1.getAs("name"), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
            String location = this.getLocation(spark, targetTable, partitionsColumns);
            Enumeration.Value fileFormat = this.getTableFileFormat(spark, targetTable);
            this.logger().info(new StringBuilder(53).append("Write ").append(fileFormat).append(" into target table: ").append(targetTable).append(", location: ").append(location).append(", file format: ").append(fileFormat).toString());
            DataFrameWriter<Row> writer = this.getSaveWriter(ds, (StructField[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])targetFields)).filter((Function1 & Serializable & scala.Serializable)field -> BoxesRunTime.boxToBoolean((boolean)HiveSink.$anonfun$output$2(partitionsColumns, field))), targetTable);
            Enumeration.Value value = fileFormat;
            Enumeration.Value value2 = FileFormat$.MODULE$.PARQUET();
            Enumeration.Value value3 = value;
            if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                writer.parquet(location);
            } else {
                Enumeration.Value value4 = FileFormat$.MODULE$.ORC();
                Enumeration.Value value5 = value;
                if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                    writer.orc(location);
                }
            }
            String partition = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partitionsColumns)).map((Function1 & Serializable & scala.Serializable)colName -> new StringBuilder(3).append((String)colName).append("='").append((Object)((DataCalcPluginConfig)this.config()).getVariables().get(colName)).append("'").toString(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString(",");
            if (StringUtils.isNotBlank((CharSequence)partition)) {
                this.logger().info(new StringBuilder(25).append("Refresh table partition: ").append(partition).toString());
                this.refreshPartition(spark, targetTable, partition);
                return;
            }
            return;
        }
        DataFrameWriter<Row> writer = this.getSaveWriter(ds, targetFields, targetTable);
        this.logger().info(new StringBuilder(31).append("InsertInto data to hive table: ").append(targetTable).toString());
        writer.format("hive").insertInto(targetTable);
    }

    public DataFrameWriter<Row> getSaveWriter(Dataset<Row> ds, StructField[] targetFields, String targetTable) {
        Dataset<Row> dsSource = this.sequenceFields(ds, ds.schema().fields(), targetFields, targetTable);
        StructField[] sourceFields = dsSource.schema().fields();
        if (((HiveSinkConfig)this.config()).getStrongCheck() != null && Predef$.MODULE$.Boolean2boolean(((HiveSinkConfig)this.config()).getStrongCheck())) {
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sourceFields)).indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                StructField targetField = targetFields[i];
                StructField sourceField = sourceFields[i];
                if (!targetField.dataType().equals((Object)sourceField.dataType())) {
                    this.logFields(sourceFields, targetFields);
                    throw new HiveSinkException(SparkErrorCodeSummary.DATA_CALC_COLUMN_NOT_MATCH.getErrorCode(), new StringBuilder(72).append(i + 1).append("st column (").append(sourceField.name()).append("[").append(sourceField.dataType()).append("]) name or data type does not match target table column (").append(targetField.name()).append("[").append(targetField.dataType()).append("])").toString());
                }
            });
        }
        DataFrameWriter writer = dsSource.repartition(Predef$.MODULE$.Integer2int(((HiveSinkConfig)this.config()).getNumPartitions())).write().mode(((HiveSinkConfig)this.config()).getSaveMode());
        Object object = ((SinkConfig)this.config()).getOptions() != null && !((SinkConfig)this.config()).getOptions().isEmpty() ? writer.options(((SinkConfig)this.config()).getOptions()) : BoxedUnit.UNIT;
        return writer;
    }

    public void logFields(StructField[] sourceFields, StructField[] targetFields) {
        this.logger().info(new StringBuilder(14).append("sourceFields: ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sourceFields)).mkString("Array(", ", ", ")")).toString());
        this.logger().info(new StringBuilder(14).append("targetFields: ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])targetFields)).mkString("Array(", ", ", ")")).toString());
    }

    public Dataset<Row> sequenceFields(Dataset<Row> dsSource, StructField[] sourceFields, StructField[] targetFields, String targetTable) {
        if (targetFields.length != sourceFields.length) {
            this.logFields(sourceFields, targetFields);
            throw new HiveSinkException(SparkErrorCodeSummary.DATA_CALC_COLUMN_NUM_NOT_MATCH.getErrorCode(), new StringBuilder(156).append(targetTable).append(" requires that the data to be inserted have the same number of columns ").append("as the target table: target table has ").append(targetFields.length).append(" column(s) ").append("but the inserted data has ").append(sourceFields.length).append(" column(s)").toString());
        }
        Map sourceFieldMap = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sourceFields)).map((Function1 & Serializable & scala.Serializable)field -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)field.name().toLowerCase()), field), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toMap(Predef$.MODULE$.$conforms());
        Map targetFieldMap = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])targetFields)).map((Function1 & Serializable & scala.Serializable)field -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)field.name().toLowerCase()), field), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toMap(Predef$.MODULE$.$conforms());
        Set subSet = (Set)targetFieldMap.keySet().$minus$minus((GenTraversableOnce)sourceFieldMap.keySet());
        if (subSet.isEmpty()) {
            return dsSource.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])targetFields)).map((Function1 & Serializable & scala.Serializable)field -> functions$.MODULE$.col(field.name()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Column.class)))));
        }
        if (subSet.size() == targetFieldMap.size()) {
            this.logger().info("None target table fields match with source fields, write in order");
            return dsSource.toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])targetFields)).map((Function1 & Serializable & scala.Serializable)field -> field.name(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))));
        }
        throw new HiveSinkException(SparkErrorCodeSummary.DATA_CALC_FIELD_NOT_EXIST.getErrorCode(), new StringBuilder(40).append(targetTable).append(" fields(").append(subSet.mkString(",")).append(") are not exist in source fields").toString());
    }

    public String getLocation(SparkSession spark, String targetTable, String[] partitionsColumns) {
        Row[] locations = (Row[])spark.sql(new StringBuilder(15).append("desc formatted ").append(targetTable).toString()).filter(functions$.MODULE$.col("col_name").$eq$eq$eq((Object)"Location")).collect();
        ObjectRef location = ObjectRef.create((Object)locations[0].getString(1));
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partitionsColumns)).foreach((Function1 & Serializable & scala.Serializable)partitionColName -> {
            HiveSink.$anonfun$getLocation$1(this, partitionsColumns, location, partitionColName);
            return BoxedUnit.UNIT;
        });
        return (String)location.elem;
    }

    public Enumeration.Value getTableFileFormat(SparkSession spark, String targetTable) {
        Enumeration.Value value;
        try {
            Enumeration.Value fileFormat = FileFormat$.MODULE$.OTHER();
            LogicalPlan logicalPlan = spark.table(targetTable).queryExecution().optimizedPlan();
            if (logicalPlan instanceof LogicalRelation) {
                LogicalRelation logicalRelation = (LogicalRelation)logicalPlan;
                BaseRelation baseRelation = logicalRelation.relation();
                if (baseRelation instanceof HadoopFsRelation) {
                    HadoopFsRelation hadoopFsRelation = (HadoopFsRelation)baseRelation;
                    FileFormat fileFormat2 = hadoopFsRelation.fileFormat();
                    if (fileFormat2 instanceof ParquetFileFormat) {
                        fileFormat = FileFormat$.MODULE$.PARQUET();
                    } else if (fileFormat2 instanceof DataSourceRegister) {
                        FileFormat fileFormat3 = fileFormat2;
                        fileFormat = FileFormat$.MODULE$.withName(((DataSourceRegister)fileFormat3).shortName().toUpperCase());
                    } else if (hadoopFsRelation.fileFormat().getClass().getSimpleName().equals("OrcFileFormat")) {
                        fileFormat = FileFormat$.MODULE$.ORC();
                    }
                } else {
                    throw new MatchError((Object)baseRelation);
                }
            }
            value = fileFormat;
        }
        catch (Exception exception) {
            value = FileFormat$.MODULE$.OTHER();
        }
        return value;
    }

    public void refreshPartition(SparkSession spark, String targetTable, String partition) {
        spark.sql(new StringBuilder(39).append("ALTER TABLE ").append(targetTable).append(" DROP IF EXISTS partition(").append(partition).append(")").toString());
        spark.sql(new StringBuilder(42).append("ALTER TABLE ").append(targetTable).append(" ADD IF NOT EXISTS partition(").append(partition).append(")").toString());
    }

    public static final /* synthetic */ boolean $anonfun$output$2(String[] partitionsColumns$1, StructField field) {
        return !new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partitionsColumns$1)).contains((Object)field.name());
    }

    public static final /* synthetic */ void $anonfun$getLocation$1(HiveSink $this, String[] partitionsColumns$2, ObjectRef location$1, String partitionColName) {
        if (!((DataCalcPluginConfig)$this.config()).getVariables().containsKey(partitionColName) || StringUtils.isBlank((CharSequence)((DataCalcPluginConfig)$this.config()).getVariables().get(partitionColName))) {
            throw new HiveSinkException(SparkErrorCodeSummary.DATA_CALC_VARIABLE_NOT_EXIST.getErrorCode(), new StringBuilder(26).append("Please set [").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partitionsColumns$2)).mkString(", ")).append("] in variables").toString());
        }
        location$1.elem = new StringBuilder(2).append((String)location$1.elem).append("/").append(partitionColName).append("=").append((Object)((DataCalcPluginConfig)$this.config()).getVariables().get(partitionColName)).toString();
    }

    public HiveSink() {
        DataCalcPlugin.$init$(this);
        Logging.$init$((Logging)this);
    }
}

