/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.schema;

import com.fasterxml.classmate.ResolvedType;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import springfox.documentation.schema.Model;
import springfox.documentation.schema.ModelProvider;
import springfox.documentation.schema.ModelSpecification;
import springfox.documentation.schema.ModelSpecificationProvider;
import springfox.documentation.spi.schema.contexts.ModelContext;

@Component
@Qualifier(value="cachedModels")
public class CachingModelProvider
implements ModelProvider,
ModelSpecificationProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(CachingModelProvider.class);
    private final Map<ModelContext, Optional<Model>> cache;
    private final Map<ModelContext, Optional<ModelSpecification>> specificationCache;
    private final Function<ModelContext, Optional<Model>> lookup;
    private final Function<ModelContext, Optional<ModelSpecification>> specificationLookup;
    private final ModelProvider delegate;
    private final ModelSpecificationProvider specificationDelegate;

    @Autowired
    public CachingModelProvider(@Qualifier(value="default") ModelProvider delegate, @Qualifier(value="default") ModelSpecificationProvider specificationDelegate) {
        this.delegate = delegate;
        this.specificationDelegate = specificationDelegate;
        this.cache = new HashMap<ModelContext, Optional<Model>>();
        this.specificationCache = new HashMap<ModelContext, Optional<ModelSpecification>>();
        this.lookup = delegate::modelFor;
        this.specificationLookup = specificationDelegate::modelSpecificationsFor;
    }

    @Override
    public Optional<Model> modelFor(ModelContext modelContext) {
        try {
            return this.cache.computeIfAbsent(modelContext, this.lookup);
        }
        catch (Exception e) {
            LOGGER.warn("Failed to get the model for -> {}. {}", (Object)modelContext.description(), (Object)e.getMessage());
            return Optional.empty();
        }
    }

    @Override
    public Map<ResolvedType, Model> dependencies(ModelContext modelContext) {
        return this.delegate.dependencies(modelContext);
    }

    @Override
    public Optional<ModelSpecification> modelSpecificationsFor(ModelContext modelContext) {
        try {
            return this.specificationCache.computeIfAbsent(modelContext, this.specificationLookup);
        }
        catch (Exception e) {
            LOGGER.warn("Failed to get the model for -> {}. {}", (Object)modelContext.description(), (Object)e.getMessage());
            return Optional.empty();
        }
    }

    @Override
    public Set<ModelSpecification> modelDependenciesSpecifications(ModelContext modelContext) {
        return this.specificationDelegate.modelDependenciesSpecifications(modelContext);
    }
}

