/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.web.readers.operation;

import com.fasterxml.classmate.ResolvedType;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import springfox.documentation.schema.ModelReference;
import springfox.documentation.schema.ResolvedTypes;
import springfox.documentation.schema.TypeNameExtractor;
import springfox.documentation.schema.plugins.SchemaPluginsManager;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.schema.EnumTypeDeterminer;
import springfox.documentation.spi.schema.ViewProviderPlugin;
import springfox.documentation.spi.schema.contexts.ModelContext;
import springfox.documentation.spi.service.OperationBuilderPlugin;
import springfox.documentation.spi.service.contexts.OperationContext;

@Component
@Order(value=-2147483648)
public class OperationResponseClassReader
implements OperationBuilderPlugin {
    private static Logger log = LoggerFactory.getLogger(OperationResponseClassReader.class);
    private final EnumTypeDeterminer enumTypeDeterminer;
    private final TypeNameExtractor nameExtractor;
    private final SchemaPluginsManager pluginsManager;

    @Autowired
    public OperationResponseClassReader(SchemaPluginsManager pluginsManager, EnumTypeDeterminer enumTypeDeterminer, TypeNameExtractor nameExtractor) {
        this.enumTypeDeterminer = enumTypeDeterminer;
        this.nameExtractor = nameExtractor;
        this.pluginsManager = pluginsManager;
    }

    public void apply(OperationContext context) {
        ResolvedType returnType = context.getReturnType();
        returnType = context.alternateFor(returnType);
        ViewProviderPlugin viewProvider = this.pluginsManager.viewProvider(context.getDocumentationContext().getDocumentationType());
        ModelContext modelContext = context.operationModelsBuilder().addReturn(returnType, viewProvider.viewFor(context));
        HashMap knownNames = new HashMap();
        ((Set)Optional.ofNullable((Set)context.getKnownModels().get(modelContext.getParameterId())).orElse(new HashSet())).forEach(model -> knownNames.put(model.getId(), model.getName()));
        String responseTypeName = this.nameExtractor.typeName(modelContext);
        log.debug("Setting spring response class to: {}", (Object)responseTypeName);
        context.operationBuilder().responseModel((ModelReference)ResolvedTypes.modelRefFactory((ModelContext)modelContext, (EnumTypeDeterminer)this.enumTypeDeterminer, (TypeNameExtractor)this.nameExtractor, knownNames).apply(returnType));
    }

    public boolean supports(DocumentationType delimiter) {
        return true;
    }
}

