/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Locale;
import java.util.NavigableSet;
import java.util.Set;
import java.util.TreeSet;

public class NameSet {
    public static final Comparator<String> COMPARATOR = new Comparator<String>(){

        @Override
        public int compare(String o1, String o2) {
            int c = o1.compareToIgnoreCase(o2);
            if (c == 0) {
                c = o1.compareTo(o2);
            }
            return c;
        }
    };
    private final NavigableSet<String> names;

    private NameSet(NavigableSet<String> names) {
        this.names = names;
        assert (names.comparator() == COMPARATOR);
    }

    public NameSet() {
        this(new TreeSet<String>(COMPARATOR));
    }

    public static NameSet immutableCopyOf(Set<String> names) {
        return new NameSet((NavigableSet<String>)ImmutableSortedSet.copyOf(COMPARATOR, names));
    }

    public void add(String name) {
        this.names.add(name);
    }

    public Collection<String> range(String name, boolean caseSensitive) {
        if (caseSensitive) {
            if (this.names.contains(name)) {
                return ImmutableList.of((Object)name);
            }
            return ImmutableList.of();
        }
        return this.names.subSet(name.toUpperCase(Locale.ROOT), true, name.toLowerCase(Locale.ROOT), true);
    }

    public boolean contains(String name, boolean caseSensitive) {
        if (this.names.contains(name)) {
            return true;
        }
        if (!caseSensitive) {
            String s = this.names.ceiling(name.toLowerCase(Locale.ROOT));
            return s != null && s.equalsIgnoreCase(name);
        }
        return false;
    }

    public Iterable<String> iterable() {
        return Collections.unmodifiableSet(this.names);
    }
}

