/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.bml.service.impl;

import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.bml.common.ResourceHelper;
import org.apache.linkis.bml.common.ResourceHelperFactory;
import org.apache.linkis.bml.dao.VersionDao;
import org.apache.linkis.bml.entity.ResourceVersion;
import org.apache.linkis.bml.entity.Version;
import org.apache.linkis.bml.service.ResourceService;
import org.apache.linkis.bml.service.VersionService;
import org.apache.linkis.common.io.Fs;
import org.apache.linkis.common.io.FsPath;
import org.apache.linkis.storage.FSFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class VersionServiceImpl
implements VersionService {
    private static final Logger logger = LoggerFactory.getLogger(VersionServiceImpl.class);
    private static final boolean OVER_WRITE = false;
    @Autowired
    private VersionDao versionDao;
    @Autowired
    private ResourceService resourceService;

    @Override
    public Version getVersion(String resourceId, String version) {
        return this.versionDao.getVersion(resourceId, version);
    }

    @Override
    public List<ResourceVersion> getResourcesVersions(Map paramMap) {
        return this.versionDao.getResourcesVersions(paramMap);
    }

    @Override
    public void deleteResourceVersion(String resourceId, String version) {
        this.versionDao.deleteVersion(resourceId, version);
    }

    @Override
    public void deleteResourceVersions(String resourceId) {
    }

    @Override
    public void deleteResourcesVersions(List<String> resourceIds, List<String> versions) {
    }

    @Override
    public String updateVersion(String resourceId, String user, MultipartFile file, Map<String, Object> params) throws Exception {
        ResourceHelper resourceHelper = ResourceHelperFactory.getResourceHelper();
        InputStream inputStream = file.getInputStream();
        String newVersion = params.get("newVersion").toString();
        String path = this.versionDao.getResourcePath(resourceId);
        if (resourceHelper.checkBmlResourceStoragePrefixPathIfChanged(path)) {
            path = resourceHelper.generatePath(user, path.substring(path.lastIndexOf("/") + 1), new HashMap<String, Object>());
        }
        path = path + "_" + newVersion;
        StringBuilder stringBuilder = new StringBuilder();
        long size = resourceHelper.upload(path, user, inputStream, stringBuilder, false);
        String md5String = stringBuilder.toString();
        String clientIp = params.get("clientIp").toString();
        ResourceVersion resourceVersion = ResourceVersion.createNewResourceVersion(resourceId, path, md5String, clientIp, size, newVersion, 1L);
        this.versionDao.insertNewVersion(resourceVersion);
        return newVersion;
    }

    private String generateNewVersion(String version) {
        int next = Integer.parseInt(version.substring(1, version.length())) + 1;
        return "v" + String.format("%06d", next);
    }

    @Override
    public String getNewestVersion(String resourceId) {
        return this.versionDao.getNewestVersion(resourceId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean downloadResource(String user, String resourceId, String version, OutputStream outputStream, Map<String, Object> properties) throws IOException {
        ResourceVersion resourceVersion = this.versionDao.findResourceVersion(resourceId, version);
        long startByte = resourceVersion.getStartByte();
        long endByte = resourceVersion.getEndByte();
        String path = resourceVersion.getResource();
        Fs fileSystem = FSFactory.getFsByProxyUser((FsPath)new FsPath(path), (String)user);
        fileSystem.init(new HashMap());
        InputStream inputStream = fileSystem.read(new FsPath(path));
        inputStream.skip(startByte - 1L);
        logger.info("{} downLoad source {} inputStream skipped {} bytes", new Object[]{user, resourceId, startByte - 1L});
        byte[] buffer = new byte[1024];
        long size = endByte - startByte + 1L;
        int left = (int)size;
        try {
            while (left > 0) {
                int readed = inputStream.read(buffer);
                int useful = Math.min(readed, left);
                if (useful < 0) {
                    break;
                }
                left -= useful;
                byte[] bytes = new byte[useful];
                for (int i = 0; i < useful; ++i) {
                    bytes[i] = buffer[i];
                }
                outputStream.write(bytes);
            }
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
            fileSystem.close();
        }
        return size >= 0L;
    }

    @Override
    public List<Version> getVersions(String resourceId) {
        return this.versionDao.getVersions(resourceId);
    }

    @Override
    public List<Version> selectVersionByPage(int currentPage, int pageSize, String resourceId) {
        List<Object> rvList = null;
        if (StringUtils.isNotEmpty((CharSequence)resourceId)) {
            PageHelper.startPage((int)currentPage, (int)pageSize);
            rvList = this.versionDao.selectVersionByPage(resourceId);
        } else {
            rvList = new ArrayList();
        }
        PageInfo pageInfo = new PageInfo(rvList);
        return pageInfo.getList();
    }

    @Override
    public List<ResourceVersion> getAllResourcesViaSystem(String system, String user) {
        return this.versionDao.getAllResourcesViaSystem(system, user);
    }

    @Override
    public List<ResourceVersion> selectResourcesViaSystemByPage(int currentPage, int pageSize, String system, String user) {
        List<Object> resourceVersions = null;
        if (StringUtils.isNotEmpty((CharSequence)system) || StringUtils.isNotEmpty((CharSequence)user)) {
            PageHelper.startPage((int)currentPage, (int)pageSize);
            resourceVersions = this.versionDao.selectResourcesViaSystemByPage(system, user);
        } else {
            resourceVersions = new ArrayList();
        }
        PageInfo pageInfo = new PageInfo(resourceVersions);
        return pageInfo.getList();
    }

    @Override
    public boolean checkVersion(String resourceId, String version) {
        return this.versionDao.checkVersion(resourceId, version) == 1;
    }

    @Override
    public boolean canAccess(String resourceId, String version) {
        return this.versionDao.selectResourceVersionEnbleFlag(resourceId, version) == 1;
    }
}

