/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.engineplugin.loader.loaders;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.common.exception.ErrorException;
import org.apache.linkis.engineplugin.loader.EngineConnPluginLoaderConf;
import org.apache.linkis.engineplugin.loader.classloader.EngineConnPluginClassLoader;
import org.apache.linkis.engineplugin.loader.loaders.CacheablesEngineConnPluginLoader;
import org.apache.linkis.engineplugin.loader.loaders.EngineConnPluginsResourceLoader;
import org.apache.linkis.engineplugin.loader.loaders.resource.LocalEngineConnPluginResourceLoader;
import org.apache.linkis.engineplugin.loader.loaders.resource.PluginResource;
import org.apache.linkis.engineplugin.loader.utils.EngineConnPluginUtils;
import org.apache.linkis.engineplugin.loader.utils.ExceptionHelper;
import org.apache.linkis.manager.engineplugin.common.EngineConnPlugin;
import org.apache.linkis.manager.engineplugin.common.exception.EngineConnPluginLoadException;
import org.apache.linkis.manager.engineplugin.common.exception.EngineConnPluginNotFoundException;
import org.apache.linkis.manager.engineplugin.common.loader.entity.EngineConnPluginInfo;
import org.apache.linkis.manager.engineplugin.common.loader.entity.EngineConnPluginInstance;
import org.apache.linkis.manager.label.entity.engine.EngineTypeLabel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultEngineConnPluginLoader
extends CacheablesEngineConnPluginLoader {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultEngineConnPluginLoader.class);
    private final List<EngineConnPluginsResourceLoader> resourceLoaders = new ArrayList<EngineConnPluginsResourceLoader>();
    private String rootStorePath;
    private String pluginPropsName;
    private static final String PLUGIN_DIR = "plugin";

    public DefaultEngineConnPluginLoader() throws ErrorException {
        String storePath = (String)EngineConnPluginLoaderConf.ENGINE_PLUGIN_STORE_PATH().getValue();
        LOG.info("DefaultEngineConnPluginLoader, storePath:" + storePath);
        if (StringUtils.isBlank((CharSequence)storePath)) {
            ExceptionHelper.dealErrorException(70061, "You should defined [" + EngineConnPluginLoaderConf.ENGINE_PLUGIN_STORE_PATH().key() + "] in properties file", null);
        }
        try {
            URI storeUri = new URI(storePath);
            if (null != storeUri.getScheme()) {
                File storeDir = new File(storeUri);
                storePath = storeDir.getAbsolutePath();
            }
        }
        catch (URISyntaxException storeUri) {
        }
        catch (IllegalArgumentException e) {
            ExceptionHelper.dealErrorException(70061, "The value:[" + storePath + "] of [" + EngineConnPluginLoaderConf.ENGINE_PLUGIN_STORE_PATH().key() + "] is incorrect", e);
        }
        this.rootStorePath = storePath;
        this.pluginPropsName = (String)EngineConnPluginLoaderConf.ENGINE_PLUGIN_PROPERTIES_NAME().getValue();
        this.resourceLoaders.add(new LocalEngineConnPluginResourceLoader());
    }

    @Override
    protected EngineConnPluginInstance loadEngineConnPluginInternal(EngineConnPluginInfo enginePluginInfo) throws Exception {
        String savePath = this.rootStorePath;
        LOG.info("EngineConnPluginInstance, savePath:" + savePath);
        EngineTypeLabel typeLabel = enginePluginInfo.typeLabel();
        if (!savePath.endsWith(String.valueOf(IOUtils.DIR_SEPARATOR))) {
            savePath = savePath + IOUtils.DIR_SEPARATOR;
        }
        savePath = savePath + typeLabel.getEngineType() + IOUtils.DIR_SEPARATOR + PLUGIN_DIR + IOUtils.DIR_SEPARATOR;
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{typeLabel.getVersion()})) {
            savePath = savePath + typeLabel.getVersion() + IOUtils.DIR_SEPARATOR;
        }
        EngineConnPlugin enginePlugin = null;
        PluginResource pluginResource = null;
        for (int i = 0; i < this.resourceLoaders.size(); ++i) {
            PluginResource resource = this.resourceLoaders.get(i).loadEngineConnPluginResource(enginePluginInfo, savePath);
            if (null == resource) continue;
            if (null == pluginResource) {
                pluginResource = resource;
                continue;
            }
            pluginResource.merge(pluginResource);
        }
        if (null != pluginResource && null != pluginResource.getUrls() && pluginResource.getUrls().length > 0) {
            Map<String, Object> props = this.readFromProperties(savePath + this.pluginPropsName);
            ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
            EngineConnPluginClassLoader enginePluginClassLoader = new EngineConnPluginClassLoader(pluginResource.getUrls(), currentClassLoader);
            enginePlugin = this.loadEngineConnPlugin(enginePluginClassLoader, props);
            if (null != enginePlugin) {
                LOG.info("Init engine conn plugin:[name: " + typeLabel.getEngineType() + ", version: " + typeLabel.getVersion() + "], invoke method init() ");
                this.initEngineConnPlugin(enginePlugin, props);
                EngineConnPluginInfo newPluginInfo = new EngineConnPluginInfo(typeLabel, pluginResource.getUpdateTime(), pluginResource.getId(), pluginResource.getVersion(), (ClassLoader)enginePluginClassLoader);
                return new EngineConnPluginInstance(newPluginInfo, enginePlugin);
            }
        }
        throw new EngineConnPluginNotFoundException("No plugin found " + enginePluginInfo.typeLabel().getStringValue() + ", please check your configuration", null);
    }

    private void initEngineConnPlugin(EngineConnPlugin plugin, Map<String, Object> props) throws EngineConnPluginLoadException {
        try {
            plugin.init(props);
        }
        catch (Exception e) {
            throw new EngineConnPluginLoadException("Failed to init engine conn plugin instance", (Throwable)e);
        }
    }

    private EngineConnPlugin loadEngineConnPlugin(EngineConnPluginClassLoader enginePluginClassLoader, Map<String, Object> props) throws EngineConnPluginLoadException {
        String pluginClass;
        EngineConnPlugin enginePlugin = EngineConnPluginUtils.loadSubEngineConnPluginInSpi(enginePluginClassLoader);
        if (null == enginePlugin && StringUtils.isNotBlank((CharSequence)(pluginClass = EngineConnPluginUtils.getEngineConnPluginClass(enginePluginClassLoader)))) {
            Class<? extends EngineConnPlugin> enginePluginClass = this.loadEngineConnPluginClass(pluginClass, enginePluginClassLoader);
            return this.loadEngineConnPlugin(enginePluginClass, enginePluginClassLoader, props);
        }
        return null;
    }

    private EngineConnPlugin loadEngineConnPlugin(Class<? extends EngineConnPlugin> pluginClass, EngineConnPluginClassLoader enginePluginClassLoader, Map<String, Object> props) throws EngineConnPluginLoadException {
        ClassLoader storeClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(enginePluginClassLoader);
        try {
            Class<?>[] parameters;
            Constructor<?> constructor;
            block11: {
                Constructor<?>[] constructors = pluginClass.getConstructors();
                if (constructors.length == 0) {
                    throw new EngineConnPluginLoadException("No public constructor in pluginClass [" + pluginClass.getName() + "]", null);
                }
                constructor = constructors[0];
                parameters = constructor.getParameterTypes();
                try {
                    if (constructor.getParameterCount() != 0) break block11;
                    EngineConnPlugin engineConnPlugin = (EngineConnPlugin)constructor.newInstance(new Object[0]);
                    return engineConnPlugin;
                }
                catch (Exception e) {
                    if (e instanceof EngineConnPluginLoadException) {
                        throw (EngineConnPluginLoadException)e;
                    }
                    throw new EngineConnPluginLoadException("Unable to construct pluginClass [" + pluginClass.getName() + "]", null);
                }
            }
            if (constructor.getParameterCount() == 1 && parameters[0] == Map.class) {
                EngineConnPlugin engineConnPlugin = (EngineConnPlugin)constructor.newInstance(props);
                return engineConnPlugin;
            }
            throw new EngineConnPluginLoadException("Illegal arguments in constructor of pluginClass [" + pluginClass.getName() + "]", null);
        }
        finally {
            Thread.currentThread().setContextClassLoader(storeClassLoader);
        }
    }

    private Class<? extends EngineConnPlugin> loadEngineConnPluginClass(String pluginClass, EngineConnPluginClassLoader classLoader) throws EngineConnPluginLoadException {
        try {
            return classLoader.loadClass(pluginClass).asSubclass(EngineConnPlugin.class);
        }
        catch (ClassNotFoundException e) {
            throw new EngineConnPluginLoadException("Unable to load class:[" + pluginClass + "]", (Throwable)e);
        }
    }

    private Map<String, Object> readFromProperties(String propertiesFile) {
        HashMap<Object, Object> map = new HashMap<String, Object>();
        Properties properties = new Properties();
        try {
            BufferedReader reader = new BufferedReader(new FileReader(propertiesFile));
            properties.load(reader);
            map = new HashMap<Object, Object>(properties);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return map;
    }
}

