/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.engineplugin.server.restful;

import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.bml.protocol.Version;
import org.apache.linkis.common.conf.Configuration;
import org.apache.linkis.engineplugin.server.entity.EngineConnBmlResource;
import org.apache.linkis.engineplugin.server.service.EngineConnResourceService;
import org.apache.linkis.engineplugin.server.service.EnginePluginAdminService;
import org.apache.linkis.engineplugin.server.service.RefreshEngineConnResourceRequest;
import org.apache.linkis.engineplugin.vo.EnginePluginBMLVo;
import org.apache.linkis.server.Message;
import org.apache.linkis.server.utils.ModuleUserUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Api(tags={"ECP(engineconn plugin) operation"})
@RestController
@RequestMapping(path={"/engineplugin"})
public class EnginePluginRestful {
    private static final Logger log = LoggerFactory.getLogger(EnginePluginRestful.class);
    @Autowired
    private EngineConnResourceService engineConnResourceService;
    @Autowired
    private EnginePluginAdminService enginePluginAdminService;

    @ApiOperation(value="rollBack", notes="modify the default bmlResourceVersion of the engineplugin", response=Message.class)
    @RequestMapping(path={"/rollBack"}, method={RequestMethod.POST})
    public Message rollBackEnginePlugin(HttpServletRequest req, @RequestBody EngineConnBmlResource engineConnBmlResource) {
        String username = ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)"rollBackEnginePlugin");
        if (Configuration.isAdmin((String)username)) {
            log.info("{} start to rollBack EnginePlugin {} {}", new Object[]{username, engineConnBmlResource.getEngineConnType(), engineConnBmlResource.getVersion()});
            try {
                this.enginePluginAdminService.rollBackEnginePlugin(engineConnBmlResource);
                log.info("{} finished to rollBack EnginePlugin {} {}", new Object[]{username, engineConnBmlResource.getEngineConnType(), engineConnBmlResource.getVersion()});
                return Message.ok();
            }
            catch (Exception e) {
                return Message.error((String)e.getMessage());
            }
        }
        return Message.error((String)"Only administrators can operate");
    }

    @ApiOperation(value="getVersionList", notes="get all bmlResourceVersion of engineplugin", response=Message.class)
    @RequestMapping(path={"/getVersionList"}, method={RequestMethod.GET})
    public Message getVersionList(HttpServletRequest req, @RequestParam(value="ecType", required=false) String ecType, @RequestParam(value="version", required=false) String version, @RequestParam(value="bmlResourceId", required=false) String bmlResourceId) {
        String username = ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)"getVersionList");
        if (Configuration.isAdmin((String)username)) {
            log.info("{} start to get all ec resource versionList", (Object)username);
            try {
                List<Version> typeList = this.enginePluginAdminService.getVersionList(username, bmlResourceId);
                log.info("{} finished get all ec resource versionList", (Object)username);
                return Message.ok().data("versionList", typeList);
            }
            catch (Exception e) {
                return Message.error((String)e.getMessage());
            }
        }
        return Message.error((String)"Only administrators can operate");
    }

    @ApiOperation(value="getTypeList", notes="get all types of engineplugin", response=Message.class)
    @RequestMapping(path={"/getTypeList"}, method={RequestMethod.GET})
    public Message getTypeList(HttpServletRequest req) {
        String username = ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)"getTypeList");
        if (Configuration.isAdmin((String)username)) {
            log.info("{} start to get all ec resource TypeList", (Object)username);
            try {
                List<String> typeList = this.enginePluginAdminService.getTypeList();
                log.info("{} finished get all ec resource TypeList", (Object)username);
                return Message.ok().data("typeList", typeList);
            }
            catch (Exception e) {
                return Message.error((String)e.getMessage());
            }
        }
        return Message.error((String)"Only administrators can operate");
    }

    @ApiOperation(value="getTypeVersionList", notes="get all versions of the engineplgin type", response=Message.class)
    @RequestMapping(path={"/getTypeVersionList/{type}"}, method={RequestMethod.GET})
    public Message getTypeVersionList(@PathVariable(value="type") String type, HttpServletRequest req) {
        String username = ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)"getTypeList");
        if (Configuration.isAdmin((String)username)) {
            log.info("{} start to get all ec resource TypeList", (Object)username);
            try {
                List<String> typeList = this.enginePluginAdminService.getTypeVersionList(type);
                log.info("{} finished get all ec resource TypeList", (Object)username);
                return Message.ok().data("queryList", typeList);
            }
            catch (Exception e) {
                return Message.error((String)e.getMessage());
            }
        }
        return Message.error((String)"Only administrators can operate");
    }

    @ApiOperation(value="updateEnginePluginBML", notes="Add a new version of the engineplugin", response=Message.class)
    @RequestMapping(path={"/updateEnginePluginBML"}, method={RequestMethod.POST})
    public Message updateEnginePluginBML(@RequestParam(value="file") MultipartFile file, @RequestParam(value="ecType") String ecType, @RequestParam(value="version") String version, @RequestParam(value="force", required=false, defaultValue="false") Boolean force, HttpServletRequest req) {
        if (StringUtils.isBlank((CharSequence)ecType)) {
            return Message.error((String)"ecType cannot be null");
        }
        if (StringUtils.isBlank((CharSequence)version)) {
            return Message.error((String)"version cannot be null");
        }
        if (file.getOriginalFilename().toLowerCase().endsWith(".zip")) {
            String username = ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)"updateEnginePluginBML");
            if (Configuration.isAdmin((String)username)) {
                log.info("{} start to update enginePlugin {} {}", new Object[]{username, ecType, version});
                try {
                    this.enginePluginAdminService.uploadToECHome(file);
                    RefreshEngineConnResourceRequest refreshEngineConnResourceRequest = new RefreshEngineConnResourceRequest();
                    refreshEngineConnResourceRequest.setEngineConnType(ecType);
                    refreshEngineConnResourceRequest.setVersion(version);
                    this.engineConnResourceService.refresh(refreshEngineConnResourceRequest, force);
                }
                catch (Exception e) {
                    return Message.error((String)e.getMessage());
                }
                log.info("{} finished to update enginePlugin {} {}", new Object[]{username, ecType, version});
                return Message.ok().data("msg", (Object)"upload file success");
            }
            return Message.error((String)"Only administrators can operate");
        }
        return Message.error((String)"Only support zip format file");
    }

    @ApiOperation(value="list", notes="list all engineplugin", response=Message.class)
    @RequestMapping(path={"/list"}, method={RequestMethod.GET})
    public Message list(@RequestParam(value="ecType", required=false) String ecType, @RequestParam(value="version", required=false) String version, @RequestParam(value="currentPage", required=false) Integer currentPage, @RequestParam(value="pageSize", required=false) Integer pageSize, HttpServletRequest req) {
        String username = ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)"list");
        if (Configuration.isAdmin((String)username)) {
            log.info("{} start to list all ec resource", (Object)username);
            EnginePluginBMLVo enginePluginBMLVo = new EnginePluginBMLVo(ecType, version);
            enginePluginBMLVo.setCurrentPage(null != currentPage ? currentPage : 1);
            enginePluginBMLVo.setPageSize(null != pageSize ? pageSize : 10);
            PageInfo<EngineConnBmlResource> engineConnBmlResourcePageInfo = this.enginePluginAdminService.queryDataSourceInfoPage(enginePluginBMLVo);
            log.info("{} finished to list all ec resource", (Object)username);
            List queryList = engineConnBmlResourcePageInfo.getList();
            return Message.ok().data("queryList", (Object)queryList).data("totalPage", (Object)engineConnBmlResourcePageInfo.getTotal());
        }
        return Message.error((String)"Only administrators can operate");
    }

    @ApiOperation(value="uploadEnginePluginBML", notes="add one engineplugin bml", response=Message.class)
    @RequestMapping(path={"/uploadEnginePluginBML"}, method={RequestMethod.POST})
    public Message uploadEnginePluginBML(@RequestParam(value="file") MultipartFile file, HttpServletRequest req) {
        if (file.getOriginalFilename().toLowerCase().endsWith(".zip")) {
            String username = ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)"uploadEnginePluginBML");
            if (Configuration.isAdmin((String)username)) {
                log.info("{} start to upload enginePlugin", (Object)username);
                try {
                    this.enginePluginAdminService.uploadToECHome(file);
                }
                catch (Exception e) {
                    return Message.error((String)e.getMessage());
                }
                this.engineConnResourceService.refreshAll(true, false);
                log.info("{} finished to upload enginePlugin", (Object)username);
                return Message.ok().data("msg", (Object)"upload file success");
            }
            return Message.error((String)"Only administrators can operate");
        }
        return Message.error((String)"Only suppose zip format file");
    }

    @ApiOperation(value="deleteEnginePluginBML", notes="delete one engineplugin bml", response=Message.class)
    @RequestMapping(path={"/deleteEnginePluginBML"}, method={RequestMethod.GET})
    public Message deleteEnginePluginBML(HttpServletRequest req, @RequestParam(value="ecType") String ecType, @RequestParam(value="version", required=false) String version) {
        String username = ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)"deleteEnginePluginBML");
        if (Configuration.isAdmin((String)username)) {
            log.info("{} start to delete engineplugin {} {}", new Object[]{username, ecType, version});
            try {
                this.enginePluginAdminService.deleteEnginePluginBML(ecType, version, username);
            }
            catch (Exception e) {
                return Message.error((String)e.getMessage());
            }
            log.info("{} finished to delete engineplugin {} {}", new Object[]{username, ecType, version});
            return Message.ok().data("msg", (Object)"delete successfully");
        }
        return Message.error((String)"Only administrators can operate");
    }

    @ApiOperation(value="refreshAll", notes="refresh all engineconn resource", response=Message.class)
    @RequestMapping(path={"/refreshAll"}, method={RequestMethod.GET})
    public Message refreshAll(HttpServletRequest req, @RequestParam(value="force", required=false, defaultValue="false") Boolean force) {
        String username = ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)"refreshAll");
        if (Configuration.isAdmin((String)username)) {
            log.info("{} start to refresh all ec resource", (Object)username);
            this.engineConnResourceService.refreshAll(true, force);
            log.info("{} finished to refresh all ec resource", (Object)username);
            return Message.ok().data("msg", (Object)"Refresh successfully");
        }
        return Message.error((String)"Only administrators can operate");
    }

    @ApiOperation(value="refreshOne", notes="refresh one engineconn resource", response=Message.class)
    @RequestMapping(path={"/refresh"}, method={RequestMethod.GET})
    public Message refreshOne(HttpServletRequest req, @RequestParam(value="ecType") String ecType, @RequestParam(value="version", required=false) String version, @RequestParam(value="force", required=false, defaultValue="false") Boolean force) {
        String username = ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)"refreshOne");
        if (Configuration.isAdmin((String)username)) {
            log.info("{} start to refresh {} ec resource", (Object)username, (Object)ecType);
            RefreshEngineConnResourceRequest refreshEngineConnResourceRequest = new RefreshEngineConnResourceRequest();
            refreshEngineConnResourceRequest.setEngineConnType(ecType);
            refreshEngineConnResourceRequest.setVersion(version);
            this.engineConnResourceService.refresh(refreshEngineConnResourceRequest, force);
            log.info("{} finished to refresh {} ec resource", (Object)username, (Object)ecType);
            return Message.ok().data("msg", (Object)"Refresh successfully");
        }
        return Message.error((String)"Only administrators can operate");
    }
}

