/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.manager.am.label;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.linkis.manager.am.label.LabelChecker;
import org.apache.linkis.manager.label.entity.Label;
import org.apache.linkis.manager.label.entity.em.EMInstanceLabel;
import org.apache.linkis.manager.label.entity.engine.EngineTypeLabel;
import org.apache.linkis.manager.label.entity.engine.UserCreatorLabel;
import org.springframework.stereotype.Component;

@Component
class AMLabelChecker
implements LabelChecker {
    AMLabelChecker() {
    }

    @Override
    public boolean checkEngineLabel(List<Label<?>> labelList) {
        return this.checkCorrespondingLabel(labelList, EngineTypeLabel.class, UserCreatorLabel.class);
    }

    @Override
    public boolean checkEMLabel(List<Label<?>> labelList) {
        return this.checkCorrespondingLabel(labelList, EMInstanceLabel.class);
    }

    @Override
    public boolean checkCorrespondingLabel(List<Label<?>> labelList, Class ... clazz) {
        List<Class> classes = Arrays.asList(clazz);
        return labelList.stream().filter(Objects::nonNull).map(Object::getClass).collect(Collectors.toList()).containsAll(classes);
    }
}

